/* $NetBSD: meson_sdioreg.h,v 1.1 2019/01/19 20:56:03 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _MESON_SDIOREG_H
#define _MESON_SDIOREG_H

#define SDIO_ARGU_REG		0x00
#define SDIO_SEND_REG		0x04
#define SDIO_CONF_REG		0x08
#define SDIO_IRQS_REG		0x0c
#define SDIO_IRQC_REG		0x10
#define SDIO_MULT_REG		0x14
#define SDIO_ADDR_REG		0x18
#define SDIO_EXT_REG		0x1c
#define SDIO_CCTL_REG		0x40
#define SDIO_CDAT_REG		0x44

#define SDIO_SEND_COMMAND_INDEX		__BITS(7,0)
#define SDIO_SEND_RESPONSE_BITS		__BITS(15,8)
#define SDIO_SEND_RESPONSE_NO_CRC	__BIT(16)
#define SDIO_SEND_RESPONSE_DATA		__BIT(17)
#define SDIO_SEND_RESPONSE_CRC7_FROM_8	__BIT(18)
#define SDIO_SEND_CHECK_BUSY_DAT0	__BIT(19)
#define SDIO_SEND_COMMAND_HAS_DATA	__BIT(20)
#define SDIO_SEND_USE_INT_WINDOW	__BIT(21)
#define SDIO_SEND_REPEAT_PACKAGE	__BITS(31,24)

#define SDIO_CONF_COMMAND_CLK_DIV	__BITS(9,0)
#define SDIO_CONF_COMMAND_DISABLE_CRC	__BIT(10)
#define SDIO_CONF_COMMAND_OUT_AT_POSEDGE __BIT(11)
#define SDIO_CONF_COMMAND_ARG_BITS	__BITS(17,12)
#define SDIO_CONF_NO_DELAY_DATA		__BIT(18)
#define SDIO_CONF_DATA_LATCH_AT_NEGEDGE	__BIT(19)
#define SDIO_CONF_BUS_WIDTH		__BIT(20)
#define SDIO_CONF_M_ENDIAN		__BITS(22,21)
#define SDIO_CONF_WRITE_NWR		__BITS(28,23)
#define SDIO_CONF_WRITE_CRC_OK_STATUS	__BITS(31,29)

#define SDIO_IRQS_STATUS		__BITS(3,0)
#define SDIO_IRQS_CMD_BUSY		__BIT(4)
#define SDIO_IRQS_RESPONSE_CRC7_OK	__BIT(5)
#define SDIO_IRQS_DATA_READ_CRC16_OK	__BIT(6)
#define SDIO_IRQS_DATA_WRITE_CRC16_OK	__BIT(7)
#define SDIO_IRQS_IF_INT		__BIT(8)
#define SDIO_IRQS_CMD_INT		__BIT(9)
#define SDIO_IRQS_SOFT_INT		__BIT(10)
#define SDIO_IRQS_SET_SOFT_INT		__BIT(11)
#define SDIO_IRQS_STATUS_INFO		__BIT(15,12)
#define SDIO_IRQS_TIMING_OUT_INT	__BIT(16)
#define SDIO_IRQS_AMRISC_TIMING_OUT_INTEN __BIT(17)
#define SDIO_IRQS_ARC_TIMING_OUT_INTEN	__BIT(18)
#define SDIO_IRQS_TIMING_OUT_COUNT	__BITS(31,19)
#define SDIO_IRQS_CLEAR			\
	(SDIO_IRQS_IF_INT|SDIO_IRQS_SOFT_INT|SDIO_IRQS_SET_SOFT_INT|\
	 SDIO_IRQS_TIMING_OUT_INT)

#define SDIO_IRQC_AMRISC_IF_INTEN	__BIT(0)
#define SDIO_IRQC_AMRISC_CMD_INTEN	__BIT(1)
#define SDIO_IRQC_AMRISC_SOFT_INTEN	__BIT(2)
#define SDIO_IRQC_ARC_IF_INTEN		__BIT(3)
#define SDIO_IRQC_ARC_CMD_INTEN		__BIT(4)
#define SDIO_IRQC_ARC_SOFT_INTEN	__BIT(5)
#define SDIO_IRQC_IF_INT_CONFIG		__BITS(7,6)
#define SDIO_IRQC_FORCE_DATA		__BITS(13,8)
#define SDIO_IRQC_FORCE_ENABLE		__BIT(14)
#define SDIO_IRQC_SOFT_RESET		__BIT(15)
#define SDIO_IRQC_FORCE_OUTEN		__BITS(21,16)
#define SDIO_IRQC_DISABLE_MEM_HALT	__BITS(23,22)
#define SDIO_IRQC_FORCE_DATA_READ	__BITS(29,24)
#define SDIO_IRQC_FORCE_HALT		__BIT(30)
#define SDIO_IRQC_HALT_HOLE		__BIT(31)

#define SDIO_MULT_PORT_SEL		__BITS(1,0)
#define SDIO_MULT_MS_ENABLE		__BIT(2)
#define SDIO_MULT_MS_SCLK_ALWAYS	__BIT(3)
#define SDIO_MULT_STREAM_ENABLE		__BIT(4)
#define SDIO_MULT_STREAM_8BIT_MODE	__BIT(5)
#define SDIO_MULT_DATA_CATCH_LEVEL	__BITS(7,6)
#define SDIO_MULT_WRITE_READ_OUT_INDEX	__BIT(8)
#define SDIO_MULT_DATA_CATCH_READOUT_EN	__BIT(9)
#define SDIO_MULT_DAT0_DATA_ON_DAT1	__BIT(10)
#define SDIO_MULT_DAT1_DATA_SWAPPED	__BIT(11)
#define SDIO_MULT_RESPONSE_READ_INDEX	__BITS(15,12)
#define SDIO_MULT_DATA_CATCH_FINISH_PT	__BITS(27,16)

#define SDIO_EXT_CMD_ARG_EXT		__BITS(15,0)
#define SDIO_EXT_DATA_RW_NUMBER		__BITS(29,16)
#define SDIO_EXT_DATA_RW_NO_CRC16	__BIT(30)
#define SDIO_EXT_CRC_STATUS_4LINE	__BIT(31)

#endif /* _MESON_SDIOREG_H */
