/*	$NetBSD: omapfbreg.h,v 1.3 2013/02/12 21:17:17 macallan Exp $ */

/*-
 * Copyright (c) 2010 Michael Lorenz
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: omapfbreg.h,v 1.3 2013/02/12 21:17:17 macallan Exp $");

#ifndef OMAPFB_REG_H
#define OMAPFB_REG_H

#define OMAPFB_DSS_REVISION		0x0000
#define OMAPFB_DSS_SYSCONFIG		0x0010
#define OMAPFB_DSS_SYSSTATUS		0x0014
#define OMAPFB_DSS_IRQSTATUS		0x0018
#define OMAPFB_DSS_CONTROL		0x0040
#define OMAPFB_DSS_SDI_CONTROL		0x0044
#define OMAPFB_DSS_PLL_CONTROL		0x0048
#define OMAPFB_DSS_SDI_STATUS		0x005c

/* display controller */
#define OMAPFB_DISPC_REVISION		0x0400
#define OMAPFB_DISPC_SYSCONFIG		0x0410
#define OMAPFB_DISPC_SYSSTATUS		0x0414
#define OMAPFB_DISPC_IRQSTATUS		0x0418
#define OMAPFB_DISPC_IRQENABLE		0x041c
#define OMAPFB_DISPC_CONTROL		0x0440
#define OMAPFB_DISPC_CONFIG		0x0444
#define OMAPFB_DISPC_DEFAULT_COLOR_0	0x044c
#define OMAPFB_DISPC_DEFAULT_COLOR_1	0x0450
#define OMAPFB_DISPC_TRANS_COLOR_0	0x0454
#define OMAPFB_DISPC_TRANS_COLOR_1	0x0458
#define OMAPFB_DISPC_LINE_STATUS	0x045c
#define OMAPFB_DISPC_LINE_NUMBER	0x0460
#define OMAPFB_DISPC_TIMING_H		0x0464
#define OMAPFB_DISPC_TIMING_V		0x0468
#define OMAPFB_DISPC_POL_FREQ		0x046c
#define OMAPFB_DISPC_DIVISOR		0x0470
#define OMAPFB_DISPC_GLOBAL_ALPHA	0x0474
#define OMAPFB_DISPC_SIZE_DIG		0x0478
#define OMAPFB_DISPC_SIZE_LCD		0x047c
#define OMAPFB_DISPC_GFX_BASE_0		0x0480
#define OMAPFB_DISPC_GFX_BASE_1		0x0484
#define OMAPFB_DISPC_GFX_POSITION	0x0488
#define OMAPFB_DISPC_GFX_SIZE		0x048c
#define OMAPFB_DISPC_GFX_ATTRIBUTES	0x04a0
#define OMAPFB_DISPC_GFX_FIFO_THRESH	0x04a4
#define OMAPFB_DISPC_GFX_FIFO_SZ_STATUS	0x04a8
#define OMAPFB_DISPC_GFX_ROW_INC	0x04ac
#define OMAPFB_DISPC_GFX_PIXEL_INC	0x04b0
#define OMAPFB_DISPC_GFX_WINDOW_SKIP	0x04b4
#define OMAPFB_DISPC_GFX_TABLE_BASE	0x04b8
#define OMAPFB_DISPC_DATA_CYCLE_0	0x05d4
#define OMAPFB_DISPC_DATA_CYCLE_1	0x05d8
#define OMAPFB_DISPC_DATA_CYCLE_2	0x05dc
#define OMAPFB_DISPC_CPR_COEFF_R	0x0620
#define OMAPFB_DISPC_CPR_COEFF_G	0x0624
#define OMAPFB_DISPC_CPR_COEFF_B	0x0628
#define OMAPFB_DISPC_GFX_PRELOAD	0x062c

/* VID1 */
#define OMAPFB_DISPC_VID1_BASE_0	0x04bc
#define OMAPFB_DISPC_VID1_BASE_1	0x04c0
#define OMAPFB_DISPC_VID1_POSITION	0x04c4
#define OMAPFB_DISPC_VID1_SIZE		0x04c8	/* displayed size */
#define OMAPFB_DISPC_VID1_ATTRIBUTES	0x04cc
#define OMAPFB_DISPC_VID1_FIFO_THRESH	0x04d0
#define OMAPFB_DISPC_VID1_FIFO_SZ_STAT	0x04d4
#define OMAPFB_DISPC_VID1_ROW_INC	0x04d8
#define OMAPFB_DISPC_VID1_PIXEL_INC	0x04dc
#define OMAPFB_DISPC_VID1_FIR		0x04e0
#define OMAPFB_DISPC_VID1_PICTURE_SIZE	0x04e4	/* original size */
#define OMAPFB_DISPC_VID1_ACCU_0	0x04e8
#define OMAPFB_DISPC_VID1_ACCU_1	0x04ec
#define OMAPFB_DISPC_VID1_COEFF_H_0	0x04d0
#define OMAPFB_DISPC_VID1_COEFF_HV_0	0x04d4
#define OMAPFB_DISPC_VID1_COEFF_H_1	0x04d8
#define OMAPFB_DISPC_VID1_COEFF_HV_1	0x04dc
#define OMAPFB_DISPC_VID1_COEFF_H_2	0x04e0
#define OMAPFB_DISPC_VID1_COEFF_HV_2	0x04e4
#define OMAPFB_DISPC_VID1_COEFF_H_3	0x04e8
#define OMAPFB_DISPC_VID1_COEFF_HV_3	0x04ec
#define OMAPFB_DISPC_VID1_COEFF_H_4	0x04f0
#define OMAPFB_DISPC_VID1_COEFF_HV_4	0x04f4
#define OMAPFB_DISPC_VID1_COEFF_H_5	0x04f8
#define OMAPFB_DISPC_VID1_COEFF_HV_5	0x04fc
#define OMAPFB_DISPC_VID1_COEFF_H_6	0x0500
#define OMAPFB_DISPC_VID1_COEFF_HV_6	0x0504
#define OMAPFB_DISPC_VID1_COEFF_H_7	0x0508
#define OMAPFB_DISPC_VID1_COEFF_HV_7	0x050c
#define OMAPFB_DISPC_VID1_CONV_COEFF_0	0x0530
#define OMAPFB_DISPC_VID1_CONV_COEFF_1	0x0534
#define OMAPFB_DISPC_VID1_CONV_COEFF_2	0x0538
#define OMAPFB_DISPC_VID1_CONV_COEFF_3	0x053c
#define OMAPFB_DISPC_VID1_CONV_COEFF_4	0x0540
#define OMAPFB_DISPC_VID1_FIR_COEFF_V0	0x05e0
#define OMAPFB_DISPC_VID1_FIR_COEFF_V1	0x05e4
#define OMAPFB_DISPC_VID1_FIR_COEFF_V2	0x05e8
#define OMAPFB_DISPC_VID1_FIR_COEFF_V3	0x05ec
#define OMAPFB_DISPC_VID1_FIR_COEFF_V4	0x05f0
#define OMAPFB_DISPC_VID1_FIR_COEFF_V5	0x05f4
#define OMAPFB_DISPC_VID1_FIR_COEFF_V6	0x05f8
#define OMAPFB_DISPC_VID1_FIR_COEFF_V7	0x05fc
#define OMAPFB_DISPC_VID1_PRELOAD	0x0630

/* VID2 */
#define OMAPFB_DISPC_VID2_BASE_0	0x054c
#define OMAPFB_DISPC_VID2_BASE_1	0x0550
#define OMAPFB_DISPC_VID2_POSITION	0x0554
#define OMAPFB_DISPC_VID2_SIZE		0x0558
#define OMAPFB_DISPC_VID2_ATTRIBUTES	0x055c
#define OMAPFB_DISPC_VID2_FIFO_THRESH	0x0560
#define OMAPFB_DISPC_VID2_FIFO_SZ_STAT	0x0564
#define OMAPFB_DISPC_VID2_ROW_INC	0x0568
#define OMAPFB_DISPC_VID2_PIXEL_INC	0x056c
#define OMAPFB_DISPC_VID2_FIR		0x0570
#define OMAPFB_DISPC_VID2_PICTURE_SIZE	0x0574
#define OMAPFB_DISPC_VID2_ACCU_0	0x0578
#define OMAPFB_DISPC_VID2_ACCU_1	0x057c
#define OMAPFB_DISPC_VID2_COEFF_H_0	0x0580
#define OMAPFB_DISPC_VID2_COEFF_HV_0	0x0584
#define OMAPFB_DISPC_VID2_COEFF_H_1	0x0588
#define OMAPFB_DISPC_VID2_COEFF_HV_1	0x058c
#define OMAPFB_DISPC_VID2_COEFF_H_2	0x0590
#define OMAPFB_DISPC_VID2_COEFF_HV_2	0x0594
#define OMAPFB_DISPC_VID2_COEFF_H_3	0x0598
#define OMAPFB_DISPC_VID2_COEFF_HV_3	0x059c
#define OMAPFB_DISPC_VID2_COEFF_H_4	0x05a0
#define OMAPFB_DISPC_VID2_COEFF_HV_4	0x05a4
#define OMAPFB_DISPC_VID2_COEFF_H_5	0x05a8
#define OMAPFB_DISPC_VID2_COEFF_HV_5	0x05ac
#define OMAPFB_DISPC_VID2_COEFF_H_6	0x05b0
#define OMAPFB_DISPC_VID2_COEFF_HV_6	0x05b4
#define OMAPFB_DISPC_VID2_COEFF_H_7	0x05b8
#define OMAPFB_DISPC_VID2_COEFF_HV_7	0x05bc
#define OMAPFB_DISPC_VID2_CONV_COEFF_0	0x05c0
#define OMAPFB_DISPC_VID2_CONV_COEFF_1	0x05c4
#define OMAPFB_DISPC_VID2_CONV_COEFF_2	0x05c8
#define OMAPFB_DISPC_VID2_CONV_COEFF_3	0x05cc
#define OMAPFB_DISPC_VID2_CONV_COEFF_4	0x05d0
#define OMAPFB_DISPC_VID2_FIR_COEFF_V0	0x0670
#define OMAPFB_DISPC_VID2_FIR_COEFF_V1	0x0674
#define OMAPFB_DISPC_VID2_FIR_COEFF_V2	0x0678
#define OMAPFB_DISPC_VID2_FIR_COEFF_V3	0x067c
#define OMAPFB_DISPC_VID2_FIR_COEFF_V4	0x0680
#define OMAPFB_DISPC_VID2_FIR_COEFF_V5	0x0684
#define OMAPFB_DISPC_VID2_FIR_COEFF_V6	0x0688
#define OMAPFB_DISPC_VID2_FIR_COEFF_V7	0x068c
#define OMAPFB_DISPC_VID2_PRELOAD	0x0634

/* video encoder */
#define OMAPFB_VENC_REV_ID		0x0c00
#define OMAPFB_VENC_STATUS		0x0c04
#define OMAPFB_VENC_F_CONTROL		0x0c08
#define OMAPFB_VENC_VIDOUT_CTRL		0x0c10
#define OMAPFB_VENC_SYNC_CTRL		0x0c14
#define OMAPFB_VENC_LLEN		0x0c1c
#define OMAPFB_VENC_FLENS		0x0c20
#define OMAPFB_VENC_HFLTR_CTRL		0x0c24
#define OMAPFB_VENC_CC_CARR_WSS_CARR	0x0c28
#define OMAPFB_VENC_C_PHASE		0x0c2c
#define OMAPFB_VENC_GAIN_U		0x0c30
#define OMAPFB_VENC_GAIN_V		0x0c34
#define OMAPFB_VENC_GAIN_Y		0x0c38
#define OMAPFB_VENC_BLACK_LEVEL		0x0c3c
#define OMAPFB_VENC_BLANK_LEVEL		0x0c40
#define OMAPFB_VENC_X_COLOR		0x0c44
#define OMAPFB_VENC_M_CONTROL		0x0c48
#define OMAPFB_VENC_BSTAMP_WSS_DATA	0x0c4c
#define OMAPFB_VENC_S_CARR		0x0c50
#define OMAPFB_VENC_LINE21		0x0c54
#define OMAPFB_VENC_LN_SEL		0x0c58
#define OMAPFB_VENC_L21_WC_CTL		0x0c5c
#define OMAPFB_VENC_HTRIGGER_VTRIGGER	0x0c60
#define OMAPFB_VENC_SAVID_EAVID		0x0c64
#define OMAPFB_VENC_FLEN_FAL		0x0c68
#define OMAPFB_VENC_LAL_PHASE_RESET	0x0c6c
#define OMAPFB_VENC_HS_INT_START_STOP_X	0x0c70
#define OMAPFB_VENC_HS_EXT_START_STOP_X	0x0c74
#define OMAPFB_VENC_VS_INT_START	0x0c78
#define OMAPFB_VENC_VS_INT_STOP_X_VS_INT_START_Y	0x0c7c
#define OMAPFB_VENC_VS_INT_STOP_Y_VS_EXT_START_X	0x0c80
#define OMAPFB_VENC_VS_EXT_STOP_X_VS_EXT_START_Y	0x0c84
#define OMAPFB_VENC_VS_EXT_STOP_Y	0x0c88
#define OMAPFB_VENC_AVID_START_STOP_X	0x0c90
#define OMAPFB_VENC_AVID_START_STOP_Y	0x0c94
#define OMAPFB_VENC_FID_START_X_FID_START_Y		0x0ca0
#define OMAPFB_VENC_FID_INT_OFFSET_Y_FID_EXT_START_X	0x0ca4
#define OMAPFB_VENC_FID_EXT_START_Y_FID_EXT_OFFSET_Y	0x0ca8
#define OMAPFB_VENC_TVDETGP_INT_START_STOP_X		0x0cb0
#define OMAPFB_VENC_TVDETGP_INT_START_STOP_Y		0x0cb4
#define OMAPFB_VENC_GEN_CTRL		0x0cb8
#define OMAPFB_VENC_OUTPUT_CONTROL	0x0cc4
#define OMAPFB_VENC_OUTPUT_TEST		0x0cc8

/* revision registers */
#define OMAP_REVISION_MINOR_MASK	0x0000000f
#define OMAP_REVISION_MAJOR_MASK	0x000000f0

/* sysconfig registers */
#define OMAP_SYSCONF_AUTOIDLE		0x00000001
#define OMAP_SYSCONF_SOFTRESET		0x00000002

/* sysstatus registers */
#define OMAP_SYSSTAT_RESET_DONE		0x00000001

/* OMAPFB_DSS_IRQSTATUS */
#define OMAP_DSSIRQ_DISPC		0x00000001
#define OMAP_DSSIRQ_DSI			0x00000002

/* OMAPFB_DSS_CONTROL */
#define OMAP_DSSCTRL_VENC_SVIDEO	0x00000040 /* composite otherwise */
#define OMAP_DSSCTRL_POWERDN_BGZ	0x00000020 /* power-down band gap up */
#define OMAP_DSSCTRL_DAC_DEMEN		0x00000010 /* dynamic element match */
#define OMAP_DSSCTRL_VENC_CLOCK_4X	0x00000008
#define OMAP_DSSCTRL_CLOCK_MODE		0x00000004
#define OMAP_DSSCTRL_DSI_CLK_SWITCH	0x00000002 /* use DSI PLL */
#define OMAP_DSSCTRL_DISPC_CLK_SWITCH	0x00000001 /* use DSI PLL */

/* additional bits in OMAPFB_DISPC_SYSCONFIG */
#define OMAP_DISPC_SYSC_FORCE_STANDBY	0x00000000
#define OMAP_DISPC_SYSC_NO_STANDBY	0x00001000
#define OMAP_DISPC_SYSC_SMART_STANDBY	0x00002000
#define OMAP_DISPC_SYSC_STANDBY_MASK	0x00003000
#define OMAP_DISPC_SYSC_CLOCKS_OFF	0x00000000
#define OMAP_DISPC_SYSC_FCLOCK_OFF	0x00000100
#define OMAP_DISPC_SYSC_ICLOCK_OFF	0x00000200
#define OMAP_DISPC_SYSC_CLOCK_ON	0x00000300
#define OMAP_DISPC_SYSC_CLOCK_MASK	0x00000300
#define OMAP_DISPC_SYSC_FORCE_IDLE	0x00000000
#define OMAP_DISPC_SYSC_NO_IDLE		0x00000008
#define OMAP_DISPC_SYSC_SMART_IDLE	0x00000010
#define OMAP_DISPC_SYSC_IDLE_MASK	0x00000018
#define OMAP_DISPC_SYSC_WAKEUP_ENABLE	0x00000004

/* OMAPFB_DISPC_GFX_ATTRIBUTES */
#define OMAP_DISPC_ATTR_REFRESH_FIFO	0x00008000 /* refresh from FIFO only */
#define OMAP_DISPC_ATTR_PRIORITY_HIGH	0x00004000
#define OMAP_DISPC_ATTR_ROT_NONE	0x00000000
#define OMAP_DISPC_ATTR_ROT_90		0x00001000 /* for 24bit packed only */
#define OMAP_DISPC_ATTR_ROT_180		0x00002000
#define OMAP_DISPC_ATTR_ROT_270		0x00003000
#define OMAP_DISPC_ATTR_FIFO_PRELOAD	0x00000800 /* use threshold for FIFO */
#define OMAP_DISPC_ATTR_BIG_ENDIAN	0x00000400 /* little endian otherwise */
#define OMAP_DISPC_ATTR_NIBBLE		0x00000200 /* for < 8 bit only */
#define OMAP_DISPC_ATTR_24BIT_OUT	0x00000100 /* LCD otherwise */
#define OMAP_DISPC_ATTR_BURST_4x32	0x00000000
#define OMAP_DISPC_ATTR_BURST_8x32	0x00000040
#define OMAP_DISPC_ATTR_BURST_16x32	0x00000080
#define OMAP_DISPC_ATTR_REPLICATION	0x00000020
#define OMAP_DISPC_ATTR_8BIT		0x00000006
#define OMAP_DISPC_ATTR_RGB12		0x00000008
#define OMAP_DISPC_ATTR_ARGB16		0x0000000a
#define OMAP_DISPC_ATTR_RGB16		0x0000000c
#define OMAP_DISPC_ATTR_RGB24		0x00000010 /* 32bit pixels */
#define OMAP_DISPC_ATTR_RGB24P		0x00000012 /* 24bit packed */
#define OMAP_DISPC_ATTR_ARGB32		0x00000018
#define OMAP_DISPC_ATTR_RGBA32		0x0000001a
#define OMAP_DISPC_ATTR_RGBX		0x0000001c
#define OMAP_DISPC_ATTR_ENABLE		0x00000001

/* OMAPFB_DISPC_CONTROL */
#define OMAP_DISPC_CTRL_LCD_ACTIVE_HIGH	0x20000000
#define OMAP_DISPC_CTRL_LCD_SIGNAL	0x10000000
#define OMAP_DISPC_CTRL_PIXEL_CLOCK	0x08000000
#define OMAP_DISPC_CTRL_GO_DIGITAL	0x00000040
#define OMAP_DISPC_CTRL_GO_LCD		0x00000020
#define OMAP_DISPC_CTRL_MONO_8_BYTE	0x00000010	/* 4 otherwise */
#define OMAP_DISPC_CTRL_ACTIVE_MTRX	0x00000008	/* disable STN dither */
#define OMAP_DISPC_CTRL_MONO		0x00000004
#define OMAP_DISPC_CTRL_DIGITAL_ENABLE	0x00000002
#define OMAP_DISPC_CTRL_LCD_ENABLE	0x00000001

/* OMAPFB_VENC_F_CONTROL */
#define OMAP_VENCFCTL_RESET		0x00000100
#define OMAP_VENCFCTL_VID_EXTERNAL	0x00000000
#define OMAP_VENCFCTL_VID_COLOR_BAR	0x00000040
#define OMAP_VENCFCTL_VID_BACKGROUND	0x00000080
#define OMAP_VENCFCTL_RGBF		0x00000020
#define OMAP_VENCFCTL_BG_COLOR_MASK	0x0000001c
#define OMAP_VENCFCTL_FMT_444RGB	0x00000000
#define OMAP_VENCFCTL_FMT_444		0x00000001
#define OMAP_VENCFCTL_FMT_422		0x00000002
#define OMAP_VENCFCTL_FMT_ITU_422	0x00000003

/* OMAPFB_DISPC_CONFIG */
#define OMAP_DISPC_CFG_TV_ALPHA_EN	0x00080000
#define OMAP_DISPC_CFG_LCD_ALPHA_EN	0x00040000
#define OMAP_DISPC_CFG_FIFO_FILL_ALL	0x00020000	/* fill all FIFOs if at least one is low */
#define OMAP_DISPC_CFG_FIFOHANDCHECK	0x00010000
#define OMAP_DISPC_CFG_CPR		0x00008000	/* color phase rotation */
#define OMAP_DISPC_CFG_FIFOMERGE	0x00004000
#define OMAP_DISPC_CFG_TCKDIGSELECTION	0x00002000	/* transp. color key */
#define OMAP_DISPC_CFG_TCKDIGENABLE	0x00001000
#define OMAP_DISPC_CFG_TCKLCDSELECTION	0x00000800	/* transp. color key */
#define OMAP_DISPC_CFG_TCKLCDENABLE	0x00000400
#define OMAP_DISPC_CFG_FUNCGATED	0x00000200	/* functional clocks */
#define OMAP_DISPC_CFG_ACBIAS_GATED	0x00000100
#define OMAP_DISPC_CFG_VSYNC_GATED	0x00000080
#define OMAP_DISPC_CFG_HSYNC_GATED	0x00000040
#define OMAP_DISPC_CFG_PIXELCLK_GATED	0x00000020
#define OMAP_DISPC_CFG_PIXELDATA_GATED	0x00000010
#define OMAP_DISPC_CFG_PALGAMMATABLE	0x00000008	/* use LUT as gamma in >8bit */
#define OMAP_DISPC_CFG_LUT_LOAD_ALWAYS	0x00000000
#define OMAP_DISPC_CFG_LUT_LOAD		0x00000002
#define OMAP_DISPC_CFG_LUT_LOAD_F_ONLY	0x00000004	/* only frame data */
#define OMAP_DISPC_CFG_LUT_LOAD_ONCE	0x00000006	/* load once, then 4 */
#define OMAP_DISPC_CFG_PIXEL_GATED	0x00000001	/* active matrix only */

/* OMAPFB_DISPC_VIDn_ATTRIBUTES */
#define OMAP_VID_ATTR_SELFREFRESH	0x01000000	/* no DMA, display from FIFO only */
#define OMAP_VID_ATTR_HIGH_PRIORITY	0x00800000
#define OMAP_VID_ATTR_BUFFER_SPLIT	0x00400000
#define OMAP_VID_ATTR_TAP_5		0x00200000	/* resize, 3 taps otherwise */
#define OMAP_VID_ATTR_DMA_OPT		0x00100000	/* for rotation */
#define OMAP_VID_ATTR_FIFO_PRELOAD	0x00080000	/* use high threshold reg */
#define OMAP_VID_ATTR_ROWREPEAT		0x00040000	/* for YUV */
#define OMAP_VID_ATTR_BIG_ENDIAN	0x00020000
#define OMAP_VID_ATTR_CHANNEL_24BIT	0x00010000	/* LCD otherwise */
#define OMAP_VID_ATTR_BURST_4x32	0x00000000
#define OMAP_VID_ATTR_BURST_8x32	0x00004000
#define OMAP_VID_ATTR_BURST_16x32	0x00008000
#define OMAP_VID_ATTR_BURST_MASK	0x0000c000
#define OMAP_VID_ATTR_ROT_NONE		0x00000000
#define OMAP_VID_ATTR_ROT_90		0x00001000
#define OMAP_VID_ATTR_ROT_180		0x00002000
#define OMAP_VID_ATTR_ROT_270		0x00003000
#define OMAP_VID_ATTR_ROT_MASK		0x00003000
#define OMAP_VID_ATTR_FULLRANGE		0x00000800	/* YUV */
#define OMAP_VID_ATTR_REPLICATION	0x00000400	/* 16bit -> 24bit */
#define OMAP_VID_ATTR_COLORSPACE_CONV	0x00000200	/* CbYCr -> RGB */
#define OMAP_VID_ATTR_VRESIZE_UP	0x00000100	/* down otherwise */
#define OMAP_VID_ATTR_HRESIZE_UP	0x00000080
#define OMAP_VID_ATTR_VRESIZE_ENABLE	0x00000040
#define OMAP_VID_ATTR_HRESIZE_ENABLE	0x00000020
/* VID1 doesn't support any alpha formats */
#define OMAP_VID_ATTR_RGB12		0x00000008
#define OMAP_VID_ATTR_ARGB16		0x0000000a
#define OMAP_VID_ATTR_RGB16		0x0000000c
#define OMAP_VID_ATTR_RGB24		0x00000010 /* 32bit pixels */
#define OMAP_VID_ATTR_RGB24P		0x00000012 /* 24bit packed */
#define OMAP_VID_ATTR_YUV2		0x00000014
#define OMAP_VID_ATTR_UYVY		0x00000016
#define OMAP_VID_ATTR_ARGB32		0x00000018
#define OMAP_VID_ATTR_RGBA32		0x0000001a
#define OMAP_VID_ATTR_RGBX		0x0000001c

#define OMAP_VID_ATTR_ENABLE		0x00000001

#endif /* OMAPFB_REG_H */
