#include <stdio.h>

#include "awklib.h"
#include "awkgram.h"
#include "proto.h"

static const char * const printname[100] = {
	"FIRSTTOKEN",	/* 258 */
	"PROGRAM",	/* 259 */
	"PASTAT",	/* 260 */
	"PASTAT2",	/* 261 */
	"XBEGIN",	/* 262 */
	"XEND",		/* 263 */
	"NL",		/* 264 */
	"ARRAY",	/* 265 */
	"MATCH",	/* 266 */
	"NOTMATCH",	/* 267 */
	"MATCHOP",	/* 268 */
	"FINAL",	/* 269 */
	"DOT",		/* 270 */
	"ALL",		/* 271 */
	"CCL",		/* 272 */
	"NCCL",		/* 273 */
	"CHAR",		/* 274 */
	"OR",		/* 275 */
	"STAR",		/* 276 */
	"QUEST",	/* 277 */
	"PLUS",		/* 278 */
	"EMPTYRE",	/* 279 */
	"AND",		/* 280 */
	"BOR",		/* 281 */
	"APPEND",	/* 282 */
	"EQ",		/* 283 */
	"GE",		/* 284 */
	"GT",		/* 285 */
	"LE",		/* 286 */
	"LT",		/* 287 */
	"NE",		/* 288 */
	"IN",		/* 289 */
	"ARG",		/* 290 */
	"BLTIN",	/* 291 */
	"BREAK",	/* 292 */
	"CLOSE",	/* 293 */
	"CONTINUE",	/* 294 */
	"DELETE",	/* 295 */
	"DLALLOC",	/* 296 */
	"DLCALL",	/* 297 */
	"DLCLOSE",	/* 298 */
	"DLFREE",	/* 299 */
	"DLOPEN",	/* 300 */
	"DLPROTO",	/* 301 */
	"DO",		/* 302 */
	"EXIT",		/* 303 */
	"FOR",		/* 304 */
	"FUNC",		/* 305 */
	"SUB",		/* 306 */
	"GSUB",		/* 307 */
	"IF",		/* 308 */
	"INDEX",	/* 309 */
	"LSUBSTR",	/* 300 */
	"MATCHFCN",	/* 311 */
	"NEXT",		/* 312 */
	"NEXTFILE",	/* 313 */
	"ADD",		/* 314 */
	"MINUS",	/* 315 */
	"MULT",		/* 316 */
	"DIVIDE",	/* 317 */
	"MOD",		/* 318 */
	"ASSIGN",	/* 319 */
	"ASGNOP",	/* 310 */
	"ADDEQ",	/* 321 */
	"SUBEQ",	/* 322 */
	"MULTEQ",	/* 323 */
	"DIVEQ",	/* 324 */
	"MODEQ",	/* 325 */
	"POWEQ",	/* 326 */
	"PRINT",	/* 327 */
	"PRINTF",	/* 328 */
	"SPRINTF",	/* 329 */
	"ELSE",		/* 320 */
	"INTEST",	/* 331 */
	"CONDEXPR",	/* 332 */
	"POSTINCR",	/* 333 */
	"PREINCR",	/* 334 */
	"POSTDECR",	/* 335 */
	"PREDECR",	/* 336 */
	"VAR",		/* 337 */
	"IVAR",		/* 338 */
	"VARNF",	/* 339 */
	"CALL",		/* 330 */
	"NUMBER",	/* 341 */
	"STRING",	/* 342 */
	"REGEXPR",	/* 343 */
	"GETLINE",	/* 344 */
	"GENSUB",	/* 345 */
	"RETURN",	/* 346 */
	"SPLIT",	/* 347 */
	"SUBSTR",	/* 348 */
	"WHILE",	/* 349 */
	"CAT",		/* 340 */
	"NOT",		/* 351 */
	"UMINUS",	/* 352 */
	"POWER",	/* 353 */
	"DECR",		/* 354 */
	"INCR",		/* 355 */
	"INDIRECT",	/* 356 */
	"LASTTOKEN",	/* 357 */
};


awkcell_t *(*awklib_proctab[100])(awk_t *, awknode_t **, int) = {
	awklib_nullproc,	/* FIRSTTOKEN */
	awklib_program,	/* PROGRAM */
	awklib_pastat,	/* PASTAT */
	awklib_dopa2,	/* PASTAT2 */
	awklib_nullproc,	/* XBEGIN */
	awklib_nullproc,	/* XEND */
	awklib_nullproc,	/* NL */
	awklib_array,	/* ARRAY */
	awklib_matchop,	/* MATCH */
	awklib_matchop,	/* NOTMATCH */
	awklib_nullproc,	/* MATCHOP */
	awklib_nullproc,	/* FINAL */
	awklib_nullproc,	/* DOT */
	awklib_nullproc,	/* ALL */
	awklib_nullproc,	/* CCL */
	awklib_nullproc,	/* NCCL */
	awklib_nullproc,	/* CHAR */
	awklib_nullproc,	/* OR */
	awklib_nullproc,	/* STAR */
	awklib_nullproc,	/* QUEST */
	awklib_nullproc,	/* PLUS */
	awklib_nullproc,	/* EMPTYRE */
	awklib_boolop,	/* AND */
	awklib_boolop,	/* BOR */
	awklib_nullproc,	/* APPEND */
	awklib_relop,	/* EQ */
	awklib_relop,	/* GE */
	awklib_relop,	/* GT */
	awklib_relop,	/* LE */
	awklib_relop,	/* LT */
	awklib_relop,	/* NE */
	awklib_instat,	/* IN */
	awklib_arg,	/* ARG */
	awklib_bltin,	/* BLTIN */
	awklib_jump,	/* BREAK */
	awklib_closefile,	/* CLOSE */
	awklib_jump,	/* CONTINUE */
	awklib_delete,	/* DELETE */
	awklib_dlalloc,	/* DLALLOC */
	awklib_dlcall,	/* DLCALL */
	awklib_dlclose,	/* DLCLOSE */
	awklib_dlfree,	/* DLFREE */
	awklib_dlopen,	/* DLOPEN */
	awklib_dlproto,	/* DLPROTO */
	awklib_dostat,	/* DO */
	awklib_jump,	/* EXIT */
	awklib_forstat,	/* FOR */
	awklib_nullproc,	/* FUNC */
	awklib_sub,	/* SUB */
	awklib_gsub,	/* GSUB */
	awklib_ifstat,	/* IF */
	awklib_index,	/* INDEX */
	awklib_nullproc,	/* LSUBSTR */
	awklib_matchop,	/* MATCHFCN */
	awklib_jump,	/* NEXT */
	awklib_jump,	/* NEXTFILE */
	awklib_arith,	/* ADD */
	awklib_arith,	/* MINUS */
	awklib_arith,	/* MULT */
	awklib_arith,	/* DIVIDE */
	awklib_arith,	/* MOD */
	awklib_assign,	/* ASSIGN */
	awklib_nullproc,	/* ASGNOP */
	awklib_assign,	/* ADDEQ */
	awklib_assign,	/* SUBEQ */
	awklib_assign,	/* MULTEQ */
	awklib_assign,	/* DIVEQ */
	awklib_assign,	/* MODEQ */
	awklib_assign,	/* POWEQ */
	awklib_print,	/* PRINT */
	awklib_printf,	/* PRINTF */
	awklib_sprintf,	/* SPRINTF */
	awklib_nullproc,	/* ELSE */
	awklib_intest,	/* INTEST */
	awklib_condexpr,	/* CONDEXPR */
	awklib_incrdecr,	/* POSTINCR */
	awklib_incrdecr,	/* PREINCR */
	awklib_incrdecr,	/* POSTDECR */
	awklib_incrdecr,	/* PREDECR */
	awklib_nullproc,	/* VAR */
	awklib_nullproc,	/* IVAR */
	awklib_getnf,	/* VARNF */
	awklib_call,	/* CALL */
	awklib_nullproc,	/* NUMBER */
	awklib_nullproc,	/* STRING */
	awklib_nullproc,	/* REGEXPR */
	awklib_getline,	/* GETLINE */
	awklib_gensub,	/* GENSUB */
	awklib_jump,	/* RETURN */
	awklib_split,	/* SPLIT */
	awklib_substr,	/* SUBSTR */
	awklib_whilestat,	/* WHILE */
	awklib_cat,	/* CAT */
	awklib_boolop,	/* NOT */
	awklib_arith,	/* UMINUS */
	awklib_arith,	/* POWER */
	awklib_nullproc,	/* DECR */
	awklib_nullproc,	/* INCR */
	awklib_indirect,	/* INDIRECT */
	awklib_nullproc,	/* LASTTOKEN */
};

const char *
awklib_tokname(int n)
{
	static char buf[100];

	if (n < FIRSTTOKEN || n > LASTTOKEN) {
		snprintf(buf, sizeof(buf), "token %d", n);
		return buf;
	}
	return printname[n-FIRSTTOKEN];
}
