/*	$NetBSD$	*/

static inline __unused void
hexdump(const uint8_t *buf, size_t len)
{
	size_t pos;

	for (pos = 0; pos < len; pos++) {
		if ((pos & 15) == 0)
			printf("%08zx ", pos);
		printf("%02x%c", buf[pos], (pos & 15) == 15 ? '\n' : ' ');
	}
	if ((len & 15) != 0)
		printf("\n");
}
