/* $NetBSD$ */

/*-
 * Copyright (c) 2010 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SYS_DEV_KMIXER_KMIXERVAR_H
#define _SYS_DEV_KMIXER_KMIXERVAR_H

struct kmixer_softc;

#define KMIXER_BUFSIZE	44100

struct kmixer_buffer {
	int8_t			kb_buffer[KMIXER_BUFSIZE];
	volatile int		kb_resid;
	volatile int		kb_wpos, kb_rpos;
};

struct kmixer_chan {
	struct kmixer_softc	*ch_softc;

	struct kmixer_buffer	ch_buffer;
	kcondvar_t		ch_condvar;
	kmutex_t		ch_mutex;

	bool			ch_reading;

	struct audio_params	ch_play, ch_rec;
	stream_filter_list_t	ch_pfil, ch_rfil;

	TAILQ_ENTRY(kmixer_chan) ch_entry;
};

TAILQ_HEAD(kmixer_chan_list, kmixer_chan);

struct kmixer_softc {
	device_t	sc_dev;

	kcondvar_t	sc_condvar;
	kmutex_t	sc_mutex;
	lwp_t		*sc_lwp;

	dev_t		sc_audiodev;
	int		sc_paramsidx;

	bool		sc_running;
	bool		sc_stopped;
	bool		sc_dead;

	bool		sc_reading;

	struct kmixer_chan_list	sc_chans;

	struct audio_encoding_set *sc_encodings;
	struct audio_format sc_formats[1];
};

#endif /* !_SYS_DEV_KMIXER_KMIXERVAR_H */
