/* $NetBSD: syscallargs.h,v 1.228 2011/08/17 07:26:16 manu Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.252 2011/08/17 07:22:34 manu Exp
 */

#ifndef _SYS_SYSCALLARGS_H_
#define	_SYS_SYSCALLARGS_H_

#include <sys/mount.h>
#include <sys/sched.h>
#include <sys/socket.h>

#define	SYS_MAXSYSARGS	8

#undef	syscallarg
#define	syscallarg(x)							\
	union {								\
		register_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register_t) < sizeof (x))	\
				? 0					\
				: sizeof (register_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

#undef check_syscall_args
#define check_syscall_args(call) /*LINTED*/ \
	typedef char call##_check_args[sizeof (struct call##_args) \
		<= SYS_MAXSYSARGS * sizeof (register_t) ? 1 : -1];

struct sys_syscall_args {
	syscallarg(int) code;
	syscallarg(register_t) args[SYS_MAXSYSARGS];
};

struct sys_exit_args {
	syscallarg(int) rval;
};
check_syscall_args(sys_exit)

struct sys_read_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
};
check_syscall_args(sys_read)

struct sys_write_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
};
check_syscall_args(sys_write)

struct sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_open)

struct sys_close_args {
	syscallarg(int) fd;
};
check_syscall_args(sys_close)

struct compat_50_sys_wait4_args {
	syscallarg(pid_t) pid;
	syscallarg(int *) status;
	syscallarg(int) options;
	syscallarg(struct rusage50 *) rusage;
};
check_syscall_args(compat_50_sys_wait4)

struct compat_43_sys_creat_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(compat_43_sys_creat)

struct sys_link_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};
check_syscall_args(sys_link)

struct sys_unlink_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_unlink)

struct sys_chdir_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_chdir)

struct sys_fchdir_args {
	syscallarg(int) fd;
};
check_syscall_args(sys_fchdir)

struct compat_50_sys_mknod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
	syscallarg(uint32_t) dev;
};
check_syscall_args(compat_50_sys_mknod)

struct sys_chmod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_chmod)

struct sys_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(sys_chown)

struct sys_obreak_args {
	syscallarg(char *) nsize;
};
check_syscall_args(sys_obreak)

struct compat_20_sys_getfsstat_args {
	syscallarg(struct statfs12 *) buf;
	syscallarg(long) bufsize;
	syscallarg(int) flags;
};
check_syscall_args(compat_20_sys_getfsstat)

struct compat_43_sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(long) offset;
	syscallarg(int) whence;
};
check_syscall_args(compat_43_sys_lseek)

struct compat_40_sys_mount_args {
	syscallarg(const char *) type;
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(void *) data;
};
check_syscall_args(compat_40_sys_mount)

struct sys_unmount_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};
check_syscall_args(sys_unmount)

struct sys_setuid_args {
	syscallarg(uid_t) uid;
};
check_syscall_args(sys_setuid)

struct sys_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(void *) addr;
	syscallarg(int) data;
};
check_syscall_args(sys_ptrace)

struct sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct msghdr *) msg;
	syscallarg(int) flags;
};
check_syscall_args(sys_recvmsg)

struct sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(const struct msghdr *) msg;
	syscallarg(int) flags;
};
check_syscall_args(sys_sendmsg)

struct sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(struct sockaddr *) from;
	syscallarg(socklen_t *) fromlenaddr;
};
check_syscall_args(sys_recvfrom)

struct sys_accept_args {
	syscallarg(int) s;
	syscallarg(struct sockaddr *) name;
	syscallarg(socklen_t *) anamelen;
};
check_syscall_args(sys_accept)

struct sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(socklen_t *) alen;
};
check_syscall_args(sys_getpeername)

struct sys_getsockname_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(socklen_t *) alen;
};
check_syscall_args(sys_getsockname)

struct sys_access_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};
check_syscall_args(sys_access)

struct sys_chflags_args {
	syscallarg(const char *) path;
	syscallarg(u_long) flags;
};
check_syscall_args(sys_chflags)

struct sys_fchflags_args {
	syscallarg(int) fd;
	syscallarg(u_long) flags;
};
check_syscall_args(sys_fchflags)

struct sys_kill_args {
	syscallarg(pid_t) pid;
	syscallarg(int) signum;
};
check_syscall_args(sys_kill)

struct compat_43_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};
check_syscall_args(compat_43_sys_stat)

struct compat_43_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};
check_syscall_args(compat_43_sys_lstat)

struct sys_dup_args {
	syscallarg(int) fd;
};
check_syscall_args(sys_dup)

struct sys_profil_args {
	syscallarg(char *) samples;
	syscallarg(size_t) size;
	syscallarg(u_long) offset;
	syscallarg(u_int) scale;
};
check_syscall_args(sys_profil)

struct sys_ktrace_args {
	syscallarg(const char *) fname;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(pid_t) pid;
};
check_syscall_args(sys_ktrace)

struct compat_13_sys_sigaction_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction13 *) nsa;
	syscallarg(struct sigaction13 *) osa;
};
check_syscall_args(compat_13_sys_sigaction)

struct compat_13_sys_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(int) mask;
};
check_syscall_args(compat_13_sys_sigprocmask)

struct sys___getlogin_args {
	syscallarg(char *) namebuf;
	syscallarg(size_t) namelen;
};
check_syscall_args(sys___getlogin)

struct sys___setlogin_args {
	syscallarg(const char *) namebuf;
};
check_syscall_args(sys___setlogin)

struct sys_acct_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_acct)

struct compat_13_sys_sigaltstack_args {
	syscallarg(const struct sigaltstack13 *) nss;
	syscallarg(struct sigaltstack13 *) oss;
};
check_syscall_args(compat_13_sys_sigaltstack)

struct sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(u_long) com;
	syscallarg(void *) data;
};
check_syscall_args(sys_ioctl)

struct compat_12_sys_reboot_args {
	syscallarg(int) opt;
};
check_syscall_args(compat_12_sys_reboot)

struct sys_revoke_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_revoke)

struct sys_symlink_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};
check_syscall_args(sys_symlink)

struct sys_readlink_args {
	syscallarg(const char *) path;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};
check_syscall_args(sys_readlink)

struct sys_execve_args {
	syscallarg(const char *) path;
	syscallarg(char *const *) argp;
	syscallarg(char *const *) envp;
};
check_syscall_args(sys_execve)

struct sys_umask_args {
	syscallarg(mode_t) newmask;
};
check_syscall_args(sys_umask)

struct sys_chroot_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_chroot)

struct compat_43_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat43 *) sb;
};
check_syscall_args(compat_43_sys_fstat)

struct compat_43_sys_getkerninfo_args {
	syscallarg(int) op;
	syscallarg(char *) where;
	syscallarg(int *) size;
	syscallarg(int) arg;
};
check_syscall_args(compat_43_sys_getkerninfo)

struct compat_12_sys_msync_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};
check_syscall_args(compat_12_sys_msync)

struct sys_sbrk_args {
	syscallarg(intptr_t) incr;
};
check_syscall_args(sys_sbrk)

struct sys_sstk_args {
	syscallarg(int) incr;
};
check_syscall_args(sys_sstk)

struct compat_43_sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pos;
};
check_syscall_args(compat_43_sys_mmap)

struct sys_ovadvise_args {
	syscallarg(int) anom;
};
check_syscall_args(sys_ovadvise)

struct sys_munmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};
check_syscall_args(sys_munmap)

struct sys_mprotect_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
};
check_syscall_args(sys_mprotect)

struct sys_madvise_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) behav;
};
check_syscall_args(sys_madvise)

struct sys_mincore_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(char *) vec;
};
check_syscall_args(sys_mincore)

struct sys_getgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(gid_t *) gidset;
};
check_syscall_args(sys_getgroups)

struct sys_setgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(const gid_t *) gidset;
};
check_syscall_args(sys_setgroups)

struct sys_setpgid_args {
	syscallarg(pid_t) pid;
	syscallarg(pid_t) pgid;
};
check_syscall_args(sys_setpgid)

struct compat_50_sys_setitimer_args {
	syscallarg(int) which;
	syscallarg(const struct itimerval50 *) itv;
	syscallarg(struct itimerval50 *) oitv;
};
check_syscall_args(compat_50_sys_setitimer)

struct compat_12_sys_swapon_args {
	syscallarg(const char *) name;
};
check_syscall_args(compat_12_sys_swapon)

struct compat_50_sys_getitimer_args {
	syscallarg(int) which;
	syscallarg(struct itimerval50 *) itv;
};
check_syscall_args(compat_50_sys_getitimer)

struct compat_43_sys_gethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};
check_syscall_args(compat_43_sys_gethostname)

struct compat_43_sys_sethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};
check_syscall_args(compat_43_sys_sethostname)

struct sys_dup2_args {
	syscallarg(int) from;
	syscallarg(int) to;
};
check_syscall_args(sys_dup2)

struct sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};
check_syscall_args(sys_fcntl)

struct compat_50_sys_select_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(struct timeval50 *) tv;
};
check_syscall_args(compat_50_sys_select)

struct sys_fsync_args {
	syscallarg(int) fd;
};
check_syscall_args(sys_fsync)

struct sys_setpriority_args {
	syscallarg(int) which;
	syscallarg(id_t) who;
	syscallarg(int) prio;
};
check_syscall_args(sys_setpriority)

struct compat_30_sys_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};
check_syscall_args(compat_30_sys_socket)

struct sys_connect_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(socklen_t) namelen;
};
check_syscall_args(sys_connect)

struct compat_43_sys_accept_args {
	syscallarg(int) s;
	syscallarg(void *) name;
	syscallarg(socklen_t *) anamelen;
};
check_syscall_args(compat_43_sys_accept)

struct sys_getpriority_args {
	syscallarg(int) which;
	syscallarg(id_t) who;
};
check_syscall_args(sys_getpriority)

struct compat_43_sys_send_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_sys_send)

struct compat_43_sys_recv_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_sys_recv)

struct compat_13_sys_sigreturn_args {
	syscallarg(struct sigcontext13 *) sigcntxp;
};
check_syscall_args(compat_13_sys_sigreturn)

struct sys_bind_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(socklen_t) namelen;
};
check_syscall_args(sys_bind)

struct sys_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(const void *) val;
	syscallarg(socklen_t) valsize;
};
check_syscall_args(sys_setsockopt)

struct sys_listen_args {
	syscallarg(int) s;
	syscallarg(int) backlog;
};
check_syscall_args(sys_listen)

struct compat_43_sys_sigvec_args {
	syscallarg(int) signum;
	syscallarg(struct sigvec *) nsv;
	syscallarg(struct sigvec *) osv;
};
check_syscall_args(compat_43_sys_sigvec)

struct compat_43_sys_sigblock_args {
	syscallarg(int) mask;
};
check_syscall_args(compat_43_sys_sigblock)

struct compat_43_sys_sigsetmask_args {
	syscallarg(int) mask;
};
check_syscall_args(compat_43_sys_sigsetmask)

struct compat_13_sys_sigsuspend_args {
	syscallarg(int) mask;
};
check_syscall_args(compat_13_sys_sigsuspend)

struct compat_43_sys_sigstack_args {
	syscallarg(struct sigstack *) nss;
	syscallarg(struct sigstack *) oss;
};
check_syscall_args(compat_43_sys_sigstack)

struct compat_43_sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct omsghdr *) msg;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_sys_recvmsg)

struct compat_43_sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(void *) msg;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_sys_sendmsg)

struct compat_50_sys_gettimeofday_args {
	syscallarg(struct timeval50 *) tp;
	syscallarg(void *) tzp;
};
check_syscall_args(compat_50_sys_gettimeofday)

struct compat_50_sys_getrusage_args {
	syscallarg(int) who;
	syscallarg(struct rusage50 *) rusage;
};
check_syscall_args(compat_50_sys_getrusage)

struct sys_getsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(void *) val;
	syscallarg(socklen_t *) avalsize;
};
check_syscall_args(sys_getsockopt)

struct sys_readv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};
check_syscall_args(sys_readv)

struct sys_writev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};
check_syscall_args(sys_writev)

struct compat_50_sys_settimeofday_args {
	syscallarg(const struct timeval50 *) tv;
	syscallarg(const void *) tzp;
};
check_syscall_args(compat_50_sys_settimeofday)

struct sys_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(sys_fchown)

struct sys_fchmod_args {
	syscallarg(int) fd;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_fchmod)

struct compat_43_sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(void *) from;
	syscallarg(socklen_t *) fromlenaddr;
};
check_syscall_args(compat_43_sys_recvfrom)

struct sys_setreuid_args {
	syscallarg(uid_t) ruid;
	syscallarg(uid_t) euid;
};
check_syscall_args(sys_setreuid)

struct sys_setregid_args {
	syscallarg(gid_t) rgid;
	syscallarg(gid_t) egid;
};
check_syscall_args(sys_setregid)

struct sys_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};
check_syscall_args(sys_rename)

struct compat_43_sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(long) length;
};
check_syscall_args(compat_43_sys_truncate)

struct compat_43_sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(long) length;
};
check_syscall_args(compat_43_sys_ftruncate)

struct sys_flock_args {
	syscallarg(int) fd;
	syscallarg(int) how;
};
check_syscall_args(sys_flock)

struct sys_mkfifo_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_mkfifo)

struct sys_sendto_args {
	syscallarg(int) s;
	syscallarg(const void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(const struct sockaddr *) to;
	syscallarg(socklen_t) tolen;
};
check_syscall_args(sys_sendto)

struct sys_shutdown_args {
	syscallarg(int) s;
	syscallarg(int) how;
};
check_syscall_args(sys_shutdown)

struct sys_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(int *) rsv;
};
check_syscall_args(sys_socketpair)

struct sys_mkdir_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_mkdir)

struct sys_rmdir_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_rmdir)

struct compat_50_sys_utimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval50 *) tptr;
};
check_syscall_args(compat_50_sys_utimes)

struct compat_50_sys_adjtime_args {
	syscallarg(const struct timeval50 *) delta;
	syscallarg(struct timeval50 *) olddelta;
};
check_syscall_args(compat_50_sys_adjtime)

struct compat_43_sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(void *) asa;
	syscallarg(socklen_t *) alen;
};
check_syscall_args(compat_43_sys_getpeername)

struct compat_43_sys_sethostid_args {
	syscallarg(int32_t) hostid;
};
check_syscall_args(compat_43_sys_sethostid)

struct compat_43_sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct orlimit *) rlp;
};
check_syscall_args(compat_43_sys_getrlimit)

struct compat_43_sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct orlimit *) rlp;
};
check_syscall_args(compat_43_sys_setrlimit)

struct compat_43_sys_killpg_args {
	syscallarg(int) pgid;
	syscallarg(int) signum;
};
check_syscall_args(compat_43_sys_killpg)

struct compat_50_sys_quotactl_args {
	syscallarg(const char *) path;
	syscallarg(int) cmd;
	syscallarg(int) uid;
	syscallarg(void *) arg;
};
check_syscall_args(compat_50_sys_quotactl)

struct compat_43_sys_getsockname_args {
	syscallarg(int) fdec;
	syscallarg(void *) asa;
	syscallarg(socklen_t *) alen;
};
check_syscall_args(compat_43_sys_getsockname)

struct sys_nfssvc_args {
	syscallarg(int) flag;
	syscallarg(void *) argp;
};
check_syscall_args(sys_nfssvc)

struct compat_43_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(u_int) count;
	syscallarg(long *) basep;
};
check_syscall_args(compat_43_sys_getdirentries)

struct compat_20_sys_statfs_args {
	syscallarg(const char *) path;
	syscallarg(struct statfs12 *) buf;
};
check_syscall_args(compat_20_sys_statfs)

struct compat_20_sys_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(struct statfs12 *) buf;
};
check_syscall_args(compat_20_sys_fstatfs)

struct compat_30_sys_getfh_args {
	syscallarg(const char *) fname;
	syscallarg(struct compat_30_fhandle *) fhp;
};
check_syscall_args(compat_30_sys_getfh)

struct compat_09_sys_getdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};
check_syscall_args(compat_09_sys_getdomainname)

struct compat_09_sys_setdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};
check_syscall_args(compat_09_sys_setdomainname)

struct compat_09_sys_uname_args {
	syscallarg(struct outsname *) name;
};
check_syscall_args(compat_09_sys_uname)

struct sys_sysarch_args {
	syscallarg(int) op;
	syscallarg(void *) parms;
};
check_syscall_args(sys_sysarch)
#if (defined(SYSVSEM) || !defined(_KERNEL_OPT)) && !defined(_LP64)

struct compat_10_sys_semsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
check_syscall_args(compat_10_sys_semsys)
#else
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL_OPT)) && !defined(_LP64)

struct compat_10_sys_msgsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
	syscallarg(int) a6;
};
check_syscall_args(compat_10_sys_msgsys)
#else
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL_OPT)) && !defined(_LP64)

struct compat_10_sys_shmsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};
check_syscall_args(compat_10_sys_shmsys)
#else
#endif

struct sys_pread_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
	syscallarg(int) PAD;
	syscallarg(off_t) offset;
};
check_syscall_args(sys_pread)

struct sys_pwrite_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
	syscallarg(int) PAD;
	syscallarg(off_t) offset;
};
check_syscall_args(sys_pwrite)

struct compat_30_sys_ntp_gettime_args {
	syscallarg(struct ntptimeval30 *) ntvp;
};
check_syscall_args(compat_30_sys_ntp_gettime)
#if defined(NTP) || !defined(_KERNEL_OPT)

struct sys_ntp_adjtime_args {
	syscallarg(struct timex *) tp;
};
check_syscall_args(sys_ntp_adjtime)
#else
#endif

struct sys_setgid_args {
	syscallarg(gid_t) gid;
};
check_syscall_args(sys_setgid)

struct sys_setegid_args {
	syscallarg(gid_t) egid;
};
check_syscall_args(sys_setegid)

struct sys_seteuid_args {
	syscallarg(uid_t) euid;
};
check_syscall_args(sys_seteuid)

struct sys_lfs_bmapv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};
check_syscall_args(sys_lfs_bmapv)

struct sys_lfs_markv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};
check_syscall_args(sys_lfs_markv)

struct sys_lfs_segclean_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(u_long) segment;
};
check_syscall_args(sys_lfs_segclean)

struct compat_50_sys_lfs_segwait_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct timeval50 *) tv;
};
check_syscall_args(compat_50_sys_lfs_segwait)

struct compat_12_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat12 *) ub;
};
check_syscall_args(compat_12_sys_stat)

struct compat_12_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat12 *) sb;
};
check_syscall_args(compat_12_sys_fstat)

struct compat_12_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat12 *) ub;
};
check_syscall_args(compat_12_sys_lstat)

struct sys_pathconf_args {
	syscallarg(const char *) path;
	syscallarg(int) name;
};
check_syscall_args(sys_pathconf)

struct sys_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};
check_syscall_args(sys_fpathconf)

struct sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct rlimit *) rlp;
};
check_syscall_args(sys_getrlimit)

struct sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct rlimit *) rlp;
};
check_syscall_args(sys_setrlimit)

struct compat_12_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(u_int) count;
	syscallarg(long *) basep;
};
check_syscall_args(compat_12_sys_getdirentries)

struct sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) PAD;
	syscallarg(off_t) pos;
};
check_syscall_args(sys_mmap)

struct sys___syscall_args {
	syscallarg(quad_t) code;
	syscallarg(register_t) args[SYS_MAXSYSARGS];
};

struct sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(off_t) offset;
	syscallarg(int) whence;
};
check_syscall_args(sys_lseek)

struct sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(int) PAD;
	syscallarg(off_t) length;
};
check_syscall_args(sys_truncate)

struct sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(off_t) length;
};
check_syscall_args(sys_ftruncate)

struct sys___sysctl_args {
	syscallarg(const int *) name;
	syscallarg(u_int) namelen;
	syscallarg(void *) old;
	syscallarg(size_t *) oldlenp;
	syscallarg(const void *) new;
	syscallarg(size_t) newlen;
};
check_syscall_args(sys___sysctl)

struct sys_mlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};
check_syscall_args(sys_mlock)

struct sys_munlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};
check_syscall_args(sys_munlock)

struct sys_undelete_args {
	syscallarg(const char *) path;
};
check_syscall_args(sys_undelete)

struct compat_50_sys_futimes_args {
	syscallarg(int) fd;
	syscallarg(const struct timeval50 *) tptr;
};
check_syscall_args(compat_50_sys_futimes)

struct sys_getpgid_args {
	syscallarg(pid_t) pid;
};
check_syscall_args(sys_getpgid)

struct sys_reboot_args {
	syscallarg(int) opt;
	syscallarg(char *) bootstr;
};
check_syscall_args(sys_reboot)

struct sys_poll_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(u_int) nfds;
	syscallarg(int) timeout;
};
check_syscall_args(sys_poll)
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)

struct compat_14_sys___semctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union __semun *) arg;
};
check_syscall_args(compat_14_sys___semctl)

struct sys_semget_args {
	syscallarg(key_t) key;
	syscallarg(int) nsems;
	syscallarg(int) semflg;
};
check_syscall_args(sys_semget)

struct sys_semop_args {
	syscallarg(int) semid;
	syscallarg(struct sembuf *) sops;
	syscallarg(size_t) nsops;
};
check_syscall_args(sys_semop)

struct sys_semconfig_args {
	syscallarg(int) flag;
};
check_syscall_args(sys_semconfig)
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)

struct compat_14_sys_msgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds14 *) buf;
};
check_syscall_args(compat_14_sys_msgctl)

struct sys_msgget_args {
	syscallarg(key_t) key;
	syscallarg(int) msgflg;
};
check_syscall_args(sys_msgget)

struct sys_msgsnd_args {
	syscallarg(int) msqid;
	syscallarg(const void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(int) msgflg;
};
check_syscall_args(sys_msgsnd)

struct sys_msgrcv_args {
	syscallarg(int) msqid;
	syscallarg(void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(long) msgtyp;
	syscallarg(int) msgflg;
};
check_syscall_args(sys_msgrcv)
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)

struct sys_shmat_args {
	syscallarg(int) shmid;
	syscallarg(const void *) shmaddr;
	syscallarg(int) shmflg;
};
check_syscall_args(sys_shmat)

struct compat_14_sys_shmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds14 *) buf;
};
check_syscall_args(compat_14_sys_shmctl)

struct sys_shmdt_args {
	syscallarg(const void *) shmaddr;
};
check_syscall_args(sys_shmdt)

struct sys_shmget_args {
	syscallarg(key_t) key;
	syscallarg(size_t) size;
	syscallarg(int) shmflg;
};
check_syscall_args(sys_shmget)
#else
#endif

struct compat_50_sys_clock_gettime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec50 *) tp;
};
check_syscall_args(compat_50_sys_clock_gettime)

struct compat_50_sys_clock_settime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(const struct timespec50 *) tp;
};
check_syscall_args(compat_50_sys_clock_settime)

struct compat_50_sys_clock_getres_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec50 *) tp;
};
check_syscall_args(compat_50_sys_clock_getres)

struct sys_timer_create_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct sigevent *) evp;
	syscallarg(timer_t *) timerid;
};
check_syscall_args(sys_timer_create)

struct sys_timer_delete_args {
	syscallarg(timer_t) timerid;
};
check_syscall_args(sys_timer_delete)

struct compat_50_sys_timer_settime_args {
	syscallarg(timer_t) timerid;
	syscallarg(int) flags;
	syscallarg(const struct itimerspec50 *) value;
	syscallarg(struct itimerspec50 *) ovalue;
};
check_syscall_args(compat_50_sys_timer_settime)

struct compat_50_sys_timer_gettime_args {
	syscallarg(timer_t) timerid;
	syscallarg(struct itimerspec50 *) value;
};
check_syscall_args(compat_50_sys_timer_gettime)

struct sys_timer_getoverrun_args {
	syscallarg(timer_t) timerid;
};
check_syscall_args(sys_timer_getoverrun)

struct compat_50_sys_nanosleep_args {
	syscallarg(const struct timespec50 *) rqtp;
	syscallarg(struct timespec50 *) rmtp;
};
check_syscall_args(compat_50_sys_nanosleep)

struct sys_fdatasync_args {
	syscallarg(int) fd;
};
check_syscall_args(sys_fdatasync)

struct sys_mlockall_args {
	syscallarg(int) flags;
};
check_syscall_args(sys_mlockall)

struct compat_50_sys___sigtimedwait_args {
	syscallarg(const sigset_t *) set;
	syscallarg(siginfo_t *) info;
	syscallarg(struct timespec50 *) timeout;
};
check_syscall_args(compat_50_sys___sigtimedwait)

struct sys_sigqueueinfo_args {
	syscallarg(pid_t) pid;
	syscallarg(const siginfo_t *) info;
};
check_syscall_args(sys_sigqueueinfo)

struct sys_modctl_args {
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};
check_syscall_args(sys_modctl)

struct sys__ksem_init_args {
	syscallarg(unsigned int) value;
	syscallarg(intptr_t *) idp;
};
check_syscall_args(sys__ksem_init)

struct sys__ksem_open_args {
	syscallarg(const char *) name;
	syscallarg(int) oflag;
	syscallarg(mode_t) mode;
	syscallarg(unsigned int) value;
	syscallarg(intptr_t *) idp;
};
check_syscall_args(sys__ksem_open)

struct sys__ksem_unlink_args {
	syscallarg(const char *) name;
};
check_syscall_args(sys__ksem_unlink)

struct sys__ksem_close_args {
	syscallarg(intptr_t) id;
};
check_syscall_args(sys__ksem_close)

struct sys__ksem_post_args {
	syscallarg(intptr_t) id;
};
check_syscall_args(sys__ksem_post)

struct sys__ksem_wait_args {
	syscallarg(intptr_t) id;
};
check_syscall_args(sys__ksem_wait)

struct sys__ksem_trywait_args {
	syscallarg(intptr_t) id;
};
check_syscall_args(sys__ksem_trywait)

struct sys__ksem_getvalue_args {
	syscallarg(intptr_t) id;
	syscallarg(unsigned int *) value;
};
check_syscall_args(sys__ksem_getvalue)

struct sys__ksem_destroy_args {
	syscallarg(intptr_t) id;
};
check_syscall_args(sys__ksem_destroy)

struct sys_mq_open_args {
	syscallarg(const char *) name;
	syscallarg(int) oflag;
	syscallarg(mode_t) mode;
	syscallarg(struct mq_attr *) attr;
};
check_syscall_args(sys_mq_open)

struct sys_mq_close_args {
	syscallarg(mqd_t) mqdes;
};
check_syscall_args(sys_mq_close)

struct sys_mq_unlink_args {
	syscallarg(const char *) name;
};
check_syscall_args(sys_mq_unlink)

struct sys_mq_getattr_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(struct mq_attr *) mqstat;
};
check_syscall_args(sys_mq_getattr)

struct sys_mq_setattr_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const struct mq_attr *) mqstat;
	syscallarg(struct mq_attr *) omqstat;
};
check_syscall_args(sys_mq_setattr)

struct sys_mq_notify_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const struct sigevent *) notification;
};
check_syscall_args(sys_mq_notify)

struct sys_mq_send_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned) msg_prio;
};
check_syscall_args(sys_mq_send)

struct sys_mq_receive_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned *) msg_prio;
};
check_syscall_args(sys_mq_receive)

struct compat_50_sys_mq_timedsend_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned) msg_prio;
	syscallarg(const struct timespec50 *) abs_timeout;
};
check_syscall_args(compat_50_sys_mq_timedsend)

struct compat_50_sys_mq_timedreceive_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned *) msg_prio;
	syscallarg(const struct timespec50 *) abs_timeout;
};
check_syscall_args(compat_50_sys_mq_timedreceive)

struct sys___posix_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};
check_syscall_args(sys___posix_rename)

struct sys_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(void *) arg;
	syscallarg(int) misc;
};
check_syscall_args(sys_swapctl)

struct compat_30_sys_getdents_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};
check_syscall_args(compat_30_sys_getdents)

struct sys_minherit_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) inherit;
};
check_syscall_args(sys_minherit)

struct sys_lchmod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_lchmod)

struct sys_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(sys_lchown)

struct compat_50_sys_lutimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval50 *) tptr;
};
check_syscall_args(compat_50_sys_lutimes)

struct sys___msync13_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) flags;
};
check_syscall_args(sys___msync13)

struct compat_30_sys___stat13_args {
	syscallarg(const char *) path;
	syscallarg(struct stat13 *) ub;
};
check_syscall_args(compat_30_sys___stat13)

struct compat_30_sys___fstat13_args {
	syscallarg(int) fd;
	syscallarg(struct stat13 *) sb;
};
check_syscall_args(compat_30_sys___fstat13)

struct compat_30_sys___lstat13_args {
	syscallarg(const char *) path;
	syscallarg(struct stat13 *) ub;
};
check_syscall_args(compat_30_sys___lstat13)

struct sys___sigaltstack14_args {
	syscallarg(const struct sigaltstack *) nss;
	syscallarg(struct sigaltstack *) oss;
};
check_syscall_args(sys___sigaltstack14)

struct sys___posix_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(sys___posix_chown)

struct sys___posix_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(sys___posix_fchown)

struct sys___posix_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(sys___posix_lchown)

struct sys_getsid_args {
	syscallarg(pid_t) pid;
};
check_syscall_args(sys_getsid)

struct sys___clone_args {
	syscallarg(int) flags;
	syscallarg(void *) stack;
};
check_syscall_args(sys___clone)

struct sys_fktrace_args {
	syscallarg(int) fd;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(pid_t) pid;
};
check_syscall_args(sys_fktrace)

struct sys_preadv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) PAD;
	syscallarg(off_t) offset;
};
check_syscall_args(sys_preadv)

struct sys_pwritev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) PAD;
	syscallarg(off_t) offset;
};
check_syscall_args(sys_pwritev)

struct compat_16_sys___sigaction14_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction *) nsa;
	syscallarg(struct sigaction *) osa;
};
check_syscall_args(compat_16_sys___sigaction14)

struct sys___sigpending14_args {
	syscallarg(sigset_t *) set;
};
check_syscall_args(sys___sigpending14)

struct sys___sigprocmask14_args {
	syscallarg(int) how;
	syscallarg(const sigset_t *) set;
	syscallarg(sigset_t *) oset;
};
check_syscall_args(sys___sigprocmask14)

struct sys___sigsuspend14_args {
	syscallarg(const sigset_t *) set;
};
check_syscall_args(sys___sigsuspend14)

struct compat_16_sys___sigreturn14_args {
	syscallarg(struct sigcontext *) sigcntxp;
};
check_syscall_args(compat_16_sys___sigreturn14)

struct sys___getcwd_args {
	syscallarg(char *) bufp;
	syscallarg(size_t) length;
};
check_syscall_args(sys___getcwd)

struct sys_fchroot_args {
	syscallarg(int) fd;
};
check_syscall_args(sys_fchroot)

struct compat_30_sys_fhopen_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(int) flags;
};
check_syscall_args(compat_30_sys_fhopen)

struct compat_30_sys_fhstat_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct stat13 *) sb;
};
check_syscall_args(compat_30_sys_fhstat)

struct compat_20_sys_fhstatfs_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct statfs12 *) buf;
};
check_syscall_args(compat_20_sys_fhstatfs)
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)

struct compat_50_sys_____semctl13_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union __semun *) arg;
};
check_syscall_args(compat_50_sys_____semctl13)
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)

struct compat_50_sys___msgctl13_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds *) buf;
};
check_syscall_args(compat_50_sys___msgctl13)
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)

struct compat_50_sys___shmctl13_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds13 *) buf;
};
check_syscall_args(compat_50_sys___shmctl13)
#else
#endif

struct sys_lchflags_args {
	syscallarg(const char *) path;
	syscallarg(u_long) flags;
};
check_syscall_args(sys_lchflags)

struct sys_utrace_args {
	syscallarg(const char *) label;
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};
check_syscall_args(sys_utrace)

struct sys_getcontext_args {
	syscallarg(struct __ucontext *) ucp;
};
check_syscall_args(sys_getcontext)

struct sys_setcontext_args {
	syscallarg(const struct __ucontext *) ucp;
};
check_syscall_args(sys_setcontext)

struct sys__lwp_create_args {
	syscallarg(const struct __ucontext *) ucp;
	syscallarg(u_long) flags;
	syscallarg(lwpid_t *) new_lwp;
};
check_syscall_args(sys__lwp_create)

struct sys__lwp_wait_args {
	syscallarg(lwpid_t) wait_for;
	syscallarg(lwpid_t *) departed;
};
check_syscall_args(sys__lwp_wait)

struct sys__lwp_suspend_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(sys__lwp_suspend)

struct sys__lwp_continue_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(sys__lwp_continue)

struct sys__lwp_wakeup_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(sys__lwp_wakeup)

struct sys__lwp_setprivate_args {
	syscallarg(void *) ptr;
};
check_syscall_args(sys__lwp_setprivate)

struct sys__lwp_kill_args {
	syscallarg(lwpid_t) target;
	syscallarg(int) signo;
};
check_syscall_args(sys__lwp_kill)

struct sys__lwp_detach_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(sys__lwp_detach)

struct compat_50_sys__lwp_park_args {
	syscallarg(const struct timespec50 *) ts;
	syscallarg(lwpid_t) unpark;
	syscallarg(const void *) hint;
	syscallarg(const void *) unparkhint;
};
check_syscall_args(compat_50_sys__lwp_park)

struct sys__lwp_unpark_args {
	syscallarg(lwpid_t) target;
	syscallarg(const void *) hint;
};
check_syscall_args(sys__lwp_unpark)

struct sys__lwp_unpark_all_args {
	syscallarg(const lwpid_t *) targets;
	syscallarg(size_t) ntargets;
	syscallarg(const void *) hint;
};
check_syscall_args(sys__lwp_unpark_all)

struct sys__lwp_setname_args {
	syscallarg(lwpid_t) target;
	syscallarg(const char *) name;
};
check_syscall_args(sys__lwp_setname)

struct sys__lwp_getname_args {
	syscallarg(lwpid_t) target;
	syscallarg(char *) name;
	syscallarg(size_t) len;
};
check_syscall_args(sys__lwp_getname)

struct sys__lwp_ctl_args {
	syscallarg(int) features;
	syscallarg(struct lwpctl **) address;
};
check_syscall_args(sys__lwp_ctl)

struct sys_sa_register_args {
	syscallarg(sa_upcall_t) new;
	syscallarg(sa_upcall_t *) old;
	syscallarg(int) flags;
	syscallarg(ssize_t) stackinfo_offset;
};
check_syscall_args(sys_sa_register)

struct sys_sa_stacks_args {
	syscallarg(int) num;
	syscallarg(stack_t *) stacks;
};
check_syscall_args(sys_sa_stacks)

struct sys_sa_setconcurrency_args {
	syscallarg(int) concurrency;
};
check_syscall_args(sys_sa_setconcurrency)

struct sys_sa_preempt_args {
	syscallarg(int) sa_id;
};
check_syscall_args(sys_sa_preempt)

struct sys___sigaction_sigtramp_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction *) nsa;
	syscallarg(struct sigaction *) osa;
	syscallarg(const void *) tramp;
	syscallarg(int) vers;
};
check_syscall_args(sys___sigaction_sigtramp)

struct sys_pmc_get_info_args {
	syscallarg(int) ctr;
	syscallarg(int) op;
	syscallarg(void *) args;
};
check_syscall_args(sys_pmc_get_info)

struct sys_pmc_control_args {
	syscallarg(int) ctr;
	syscallarg(int) op;
	syscallarg(void *) args;
};
check_syscall_args(sys_pmc_control)

struct sys_rasctl_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) op;
};
check_syscall_args(sys_rasctl)

struct compat_50_sys_kevent_args {
	syscallarg(int) fd;
	syscallarg(const struct kevent *) changelist;
	syscallarg(size_t) nchanges;
	syscallarg(struct kevent *) eventlist;
	syscallarg(size_t) nevents;
	syscallarg(const struct timespec50 *) timeout;
};
check_syscall_args(compat_50_sys_kevent)

struct sys__sched_setparam_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(int) policy;
	syscallarg(const struct sched_param *) params;
};
check_syscall_args(sys__sched_setparam)

struct sys__sched_getparam_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(int *) policy;
	syscallarg(struct sched_param *) params;
};
check_syscall_args(sys__sched_getparam)

struct sys__sched_setaffinity_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(size_t) size;
	syscallarg(const cpuset_t *) cpuset;
};
check_syscall_args(sys__sched_setaffinity)

struct sys__sched_getaffinity_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(size_t) size;
	syscallarg(cpuset_t *) cpuset;
};
check_syscall_args(sys__sched_getaffinity)

struct sys_fsync_range_args {
	syscallarg(int) fd;
	syscallarg(int) flags;
	syscallarg(off_t) start;
	syscallarg(off_t) length;
};
check_syscall_args(sys_fsync_range)

struct sys_uuidgen_args {
	syscallarg(struct uuid *) store;
	syscallarg(int) count;
};
check_syscall_args(sys_uuidgen)

struct sys_getvfsstat_args {
	syscallarg(struct statvfs *) buf;
	syscallarg(size_t) bufsize;
	syscallarg(int) flags;
};
check_syscall_args(sys_getvfsstat)

struct sys_statvfs1_args {
	syscallarg(const char *) path;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};
check_syscall_args(sys_statvfs1)

struct sys_fstatvfs1_args {
	syscallarg(int) fd;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};
check_syscall_args(sys_fstatvfs1)

struct compat_30_sys_fhstatvfs1_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};
check_syscall_args(compat_30_sys_fhstatvfs1)

struct sys_extattrctl_args {
	syscallarg(const char *) path;
	syscallarg(int) cmd;
	syscallarg(const char *) filename;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};
check_syscall_args(sys_extattrctl)

struct sys_extattr_set_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(const void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_set_file)

struct sys_extattr_get_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_get_file)

struct sys_extattr_delete_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};
check_syscall_args(sys_extattr_delete_file)

struct sys_extattr_set_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(const void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_set_fd)

struct sys_extattr_get_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_get_fd)

struct sys_extattr_delete_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};
check_syscall_args(sys_extattr_delete_fd)

struct sys_extattr_set_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(const void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_set_link)

struct sys_extattr_get_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_get_link)

struct sys_extattr_delete_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};
check_syscall_args(sys_extattr_delete_link)

struct sys_extattr_list_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_list_fd)

struct sys_extattr_list_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_list_file)

struct sys_extattr_list_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};
check_syscall_args(sys_extattr_list_link)

struct compat_50_sys_pselect_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(const struct timespec50 *) ts;
	syscallarg(const sigset_t *) mask;
};
check_syscall_args(compat_50_sys_pselect)

struct compat_50_sys_pollts_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(u_int) nfds;
	syscallarg(const struct timespec50 *) ts;
	syscallarg(const sigset_t *) mask;
};
check_syscall_args(compat_50_sys_pollts)

struct sys_setxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(const void *) value;
	syscallarg(size_t) size;
	syscallarg(int) flags;
};
check_syscall_args(sys_setxattr)

struct sys_lsetxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(const void *) value;
	syscallarg(size_t) size;
	syscallarg(int) flags;
};
check_syscall_args(sys_lsetxattr)

struct sys_fsetxattr_args {
	syscallarg(int) fd;
	syscallarg(const char *) name;
	syscallarg(const void *) value;
	syscallarg(size_t) size;
	syscallarg(int) flags;
};
check_syscall_args(sys_fsetxattr)

struct sys_getxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
};
check_syscall_args(sys_getxattr)

struct sys_lgetxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
};
check_syscall_args(sys_lgetxattr)

struct sys_fgetxattr_args {
	syscallarg(int) fd;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
};
check_syscall_args(sys_fgetxattr)

struct sys_listxattr_args {
	syscallarg(const char *) path;
	syscallarg(char *) list;
	syscallarg(size_t) size;
};
check_syscall_args(sys_listxattr)

struct sys_llistxattr_args {
	syscallarg(const char *) path;
	syscallarg(char *) list;
	syscallarg(size_t) size;
};
check_syscall_args(sys_llistxattr)

struct sys_flistxattr_args {
	syscallarg(int) fd;
	syscallarg(char *) list;
	syscallarg(size_t) size;
};
check_syscall_args(sys_flistxattr)

struct sys_removexattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
};
check_syscall_args(sys_removexattr)

struct sys_lremovexattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
};
check_syscall_args(sys_lremovexattr)

struct sys_fremovexattr_args {
	syscallarg(int) fd;
	syscallarg(const char *) name;
};
check_syscall_args(sys_fremovexattr)

struct compat_50_sys___stat30_args {
	syscallarg(const char *) path;
	syscallarg(struct stat30 *) ub;
};
check_syscall_args(compat_50_sys___stat30)

struct compat_50_sys___fstat30_args {
	syscallarg(int) fd;
	syscallarg(struct stat30 *) sb;
};
check_syscall_args(compat_50_sys___fstat30)

struct compat_50_sys___lstat30_args {
	syscallarg(const char *) path;
	syscallarg(struct stat30 *) ub;
};
check_syscall_args(compat_50_sys___lstat30)

struct sys___getdents30_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};
check_syscall_args(sys___getdents30)

struct compat_30_sys___fhstat30_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct stat30 *) sb;
};
check_syscall_args(compat_30_sys___fhstat30)

struct compat_50_sys___ntp_gettime30_args {
	syscallarg(struct ntptimeval50 *) ntvp;
};
check_syscall_args(compat_50_sys___ntp_gettime30)

struct sys___socket30_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};
check_syscall_args(sys___socket30)

struct sys___getfh30_args {
	syscallarg(const char *) fname;
	syscallarg(void *) fhp;
	syscallarg(size_t *) fh_size;
};
check_syscall_args(sys___getfh30)

struct sys___fhopen40_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(int) flags;
};
check_syscall_args(sys___fhopen40)

struct sys___fhstatvfs140_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};
check_syscall_args(sys___fhstatvfs140)

struct compat_50_sys___fhstat40_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(struct stat30 *) sb;
};
check_syscall_args(compat_50_sys___fhstat40)

struct sys_aio_cancel_args {
	syscallarg(int) fildes;
	syscallarg(struct aiocb *) aiocbp;
};
check_syscall_args(sys_aio_cancel)

struct sys_aio_error_args {
	syscallarg(const struct aiocb *) aiocbp;
};
check_syscall_args(sys_aio_error)

struct sys_aio_fsync_args {
	syscallarg(int) op;
	syscallarg(struct aiocb *) aiocbp;
};
check_syscall_args(sys_aio_fsync)

struct sys_aio_read_args {
	syscallarg(struct aiocb *) aiocbp;
};
check_syscall_args(sys_aio_read)

struct sys_aio_return_args {
	syscallarg(struct aiocb *) aiocbp;
};
check_syscall_args(sys_aio_return)

struct compat_50_sys_aio_suspend_args {
	syscallarg(const struct aiocb *const *) list;
	syscallarg(int) nent;
	syscallarg(const struct timespec50 *) timeout;
};
check_syscall_args(compat_50_sys_aio_suspend)

struct sys_aio_write_args {
	syscallarg(struct aiocb *) aiocbp;
};
check_syscall_args(sys_aio_write)

struct sys_lio_listio_args {
	syscallarg(int) mode;
	syscallarg(struct aiocb *const *) list;
	syscallarg(int) nent;
	syscallarg(struct sigevent *) sig;
};
check_syscall_args(sys_lio_listio)

struct sys___mount50_args {
	syscallarg(const char *) type;
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(void *) data;
	syscallarg(size_t) data_len;
};
check_syscall_args(sys___mount50)

struct sys_mremap_args {
	syscallarg(void *) old_address;
	syscallarg(size_t) old_size;
	syscallarg(void *) new_address;
	syscallarg(size_t) new_size;
	syscallarg(int) flags;
};
check_syscall_args(sys_mremap)

struct sys_pset_create_args {
	syscallarg(psetid_t *) psid;
};
check_syscall_args(sys_pset_create)

struct sys_pset_destroy_args {
	syscallarg(psetid_t) psid;
};
check_syscall_args(sys_pset_destroy)

struct sys_pset_assign_args {
	syscallarg(psetid_t) psid;
	syscallarg(cpuid_t) cpuid;
	syscallarg(psetid_t *) opsid;
};
check_syscall_args(sys_pset_assign)

struct sys__pset_bind_args {
	syscallarg(idtype_t) idtype;
	syscallarg(id_t) first_id;
	syscallarg(id_t) second_id;
	syscallarg(psetid_t) psid;
	syscallarg(psetid_t *) opsid;
};
check_syscall_args(sys__pset_bind)

struct sys___posix_fadvise50_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(off_t) offset;
	syscallarg(off_t) len;
	syscallarg(int) advice;
};
check_syscall_args(sys___posix_fadvise50)

struct sys___select50_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(struct timeval *) tv;
};
check_syscall_args(sys___select50)

struct sys___gettimeofday50_args {
	syscallarg(struct timeval *) tp;
	syscallarg(void *) tzp;
};
check_syscall_args(sys___gettimeofday50)

struct sys___settimeofday50_args {
	syscallarg(const struct timeval *) tv;
	syscallarg(const void *) tzp;
};
check_syscall_args(sys___settimeofday50)

struct sys___utimes50_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};
check_syscall_args(sys___utimes50)

struct sys___adjtime50_args {
	syscallarg(const struct timeval *) delta;
	syscallarg(struct timeval *) olddelta;
};
check_syscall_args(sys___adjtime50)

struct sys___lfs_segwait50_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct timeval *) tv;
};
check_syscall_args(sys___lfs_segwait50)

struct sys___futimes50_args {
	syscallarg(int) fd;
	syscallarg(const struct timeval *) tptr;
};
check_syscall_args(sys___futimes50)

struct sys___lutimes50_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};
check_syscall_args(sys___lutimes50)

struct sys___setitimer50_args {
	syscallarg(int) which;
	syscallarg(const struct itimerval *) itv;
	syscallarg(struct itimerval *) oitv;
};
check_syscall_args(sys___setitimer50)

struct sys___getitimer50_args {
	syscallarg(int) which;
	syscallarg(struct itimerval *) itv;
};
check_syscall_args(sys___getitimer50)

struct sys___clock_gettime50_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};
check_syscall_args(sys___clock_gettime50)

struct sys___clock_settime50_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(const struct timespec *) tp;
};
check_syscall_args(sys___clock_settime50)

struct sys___clock_getres50_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};
check_syscall_args(sys___clock_getres50)

struct sys___nanosleep50_args {
	syscallarg(const struct timespec *) rqtp;
	syscallarg(struct timespec *) rmtp;
};
check_syscall_args(sys___nanosleep50)

struct sys_____sigtimedwait50_args {
	syscallarg(const sigset_t *) set;
	syscallarg(siginfo_t *) info;
	syscallarg(struct timespec *) timeout;
};
check_syscall_args(sys_____sigtimedwait50)

struct sys___mq_timedsend50_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned) msg_prio;
	syscallarg(const struct timespec *) abs_timeout;
};
check_syscall_args(sys___mq_timedsend50)

struct sys___mq_timedreceive50_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned *) msg_prio;
	syscallarg(const struct timespec *) abs_timeout;
};
check_syscall_args(sys___mq_timedreceive50)

struct sys____lwp_park50_args {
	syscallarg(const struct timespec *) ts;
	syscallarg(lwpid_t) unpark;
	syscallarg(const void *) hint;
	syscallarg(const void *) unparkhint;
};
check_syscall_args(sys____lwp_park50)

struct sys___kevent50_args {
	syscallarg(int) fd;
	syscallarg(const struct kevent *) changelist;
	syscallarg(size_t) nchanges;
	syscallarg(struct kevent *) eventlist;
	syscallarg(size_t) nevents;
	syscallarg(const struct timespec *) timeout;
};
check_syscall_args(sys___kevent50)

struct sys___pselect50_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(const struct timespec *) ts;
	syscallarg(const sigset_t *) mask;
};
check_syscall_args(sys___pselect50)

struct sys___pollts50_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(u_int) nfds;
	syscallarg(const struct timespec *) ts;
	syscallarg(const sigset_t *) mask;
};
check_syscall_args(sys___pollts50)

struct sys___aio_suspend50_args {
	syscallarg(const struct aiocb *const *) list;
	syscallarg(int) nent;
	syscallarg(const struct timespec *) timeout;
};
check_syscall_args(sys___aio_suspend50)

struct sys___stat50_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};
check_syscall_args(sys___stat50)

struct sys___fstat50_args {
	syscallarg(int) fd;
	syscallarg(struct stat *) sb;
};
check_syscall_args(sys___fstat50)

struct sys___lstat50_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};
check_syscall_args(sys___lstat50)
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)

struct sys_____semctl50_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union __semun *) arg;
};
check_syscall_args(sys_____semctl50)
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)

struct sys___shmctl50_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds *) buf;
};
check_syscall_args(sys___shmctl50)
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)

struct sys___msgctl50_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds *) buf;
};
check_syscall_args(sys___msgctl50)
#else
#endif

struct sys___getrusage50_args {
	syscallarg(int) who;
	syscallarg(struct rusage *) rusage;
};
check_syscall_args(sys___getrusage50)

struct sys___timer_settime50_args {
	syscallarg(timer_t) timerid;
	syscallarg(int) flags;
	syscallarg(const struct itimerspec *) value;
	syscallarg(struct itimerspec *) ovalue;
};
check_syscall_args(sys___timer_settime50)

struct sys___timer_gettime50_args {
	syscallarg(timer_t) timerid;
	syscallarg(struct itimerspec *) value;
};
check_syscall_args(sys___timer_gettime50)
#if defined(NTP) || !defined(_KERNEL_OPT)

struct sys___ntp_gettime50_args {
	syscallarg(struct ntptimeval *) ntvp;
};
check_syscall_args(sys___ntp_gettime50)
#else
#endif

struct sys___wait450_args {
	syscallarg(pid_t) pid;
	syscallarg(int *) status;
	syscallarg(int) options;
	syscallarg(struct rusage *) rusage;
};
check_syscall_args(sys___wait450)

struct sys___mknod50_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
	syscallarg(dev_t) dev;
};
check_syscall_args(sys___mknod50)

struct sys___fhstat50_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(struct stat *) sb;
};
check_syscall_args(sys___fhstat50)

struct sys___quotactl50_args {
	syscallarg(const char *) path;
	syscallarg(struct plistref *) pref;
};
check_syscall_args(sys___quotactl50)

struct sys_pipe2_args {
	syscallarg(int *) fildes;
	syscallarg(int) flags;
};
check_syscall_args(sys_pipe2)

struct sys_dup3_args {
	syscallarg(int) from;
	syscallarg(int) to;
	syscallarg(int) flags;
};
check_syscall_args(sys_dup3)

struct sys_kqueue1_args {
	syscallarg(int) flags;
};
check_syscall_args(sys_kqueue1)

struct sys_paccept_args {
	syscallarg(int) s;
	syscallarg(struct sockaddr *) name;
	syscallarg(socklen_t *) anamelen;
	syscallarg(const sigset_t *) mask;
	syscallarg(int) flags;
};
check_syscall_args(sys_paccept)

struct sys_linkat_args {
	syscallarg(int) fd1;
	syscallarg(const char *) name1;
	syscallarg(int) fd2;
	syscallarg(const char *) name2;
	syscallarg(int) flags;
};
check_syscall_args(sys_linkat)

struct sys_renameat_args {
	syscallarg(int) fromfd;
	syscallarg(const char *) from;
	syscallarg(int) tofd;
	syscallarg(const char *) to;
};
check_syscall_args(sys_renameat)

struct sys_mkfifoat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_mkfifoat)

struct sys_mknodat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
	syscallarg(uint32_t) dev;
};
check_syscall_args(sys_mknodat)

struct sys_mkdirat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_mkdirat)

struct sys_faccessat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(int) amode;
	syscallarg(int) flag;
};
check_syscall_args(sys_faccessat)

struct sys_fchmodat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
	syscallarg(int) flag;
};
check_syscall_args(sys_fchmodat)

struct sys_fchownat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(uid_t) owner;
	syscallarg(gid_t) group;
	syscallarg(int) flag;
};
check_syscall_args(sys_fchownat)

struct sys_fexecve_args {
	syscallarg(int) fd;
	syscallarg(char *const *) argp;
	syscallarg(char *const *) envp;
};
check_syscall_args(sys_fexecve)

struct sys_fstatat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(struct stat *) buf;
	syscallarg(int) flag;
};
check_syscall_args(sys_fstatat)

struct sys_utimensat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(const struct timespec *) tptr;
	syscallarg(int) flag;
};
check_syscall_args(sys_utimensat)

struct sys_openat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(int) oflags;
	syscallarg(mode_t) mode;
};
check_syscall_args(sys_openat)

struct sys_readlinkat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(char *) buf;
	syscallarg(size_t) bufsize;
};
check_syscall_args(sys_readlinkat)

struct sys_symlinkat_args {
	syscallarg(const char *) path1;
	syscallarg(int) fd;
	syscallarg(const char *) path2;
};
check_syscall_args(sys_symlinkat)

struct sys_unlinkat_args {
	syscallarg(int) fd;
	syscallarg(const char *) path;
	syscallarg(int) flag;
};
check_syscall_args(sys_unlinkat)

struct sys_futimens_args {
	syscallarg(int) fd;
	syscallarg(const struct timespec *) tptr;
};
check_syscall_args(sys_futimens)

/*
 * System call prototypes.
 */

int	sys_syscall(struct lwp *, const struct sys_syscall_args *, register_t *);

int	sys_exit(struct lwp *, const struct sys_exit_args *, register_t *);

int	sys_fork(struct lwp *, const void *, register_t *);

int	sys_read(struct lwp *, const struct sys_read_args *, register_t *);

int	sys_write(struct lwp *, const struct sys_write_args *, register_t *);

int	sys_open(struct lwp *, const struct sys_open_args *, register_t *);

int	sys_close(struct lwp *, const struct sys_close_args *, register_t *);

int	compat_50_sys_wait4(struct lwp *, const struct compat_50_sys_wait4_args *, register_t *);

int	compat_43_sys_creat(struct lwp *, const struct compat_43_sys_creat_args *, register_t *);

int	sys_link(struct lwp *, const struct sys_link_args *, register_t *);

int	sys_unlink(struct lwp *, const struct sys_unlink_args *, register_t *);

int	sys_chdir(struct lwp *, const struct sys_chdir_args *, register_t *);

int	sys_fchdir(struct lwp *, const struct sys_fchdir_args *, register_t *);

int	compat_50_sys_mknod(struct lwp *, const struct compat_50_sys_mknod_args *, register_t *);

int	sys_chmod(struct lwp *, const struct sys_chmod_args *, register_t *);

int	sys_chown(struct lwp *, const struct sys_chown_args *, register_t *);

int	sys_obreak(struct lwp *, const struct sys_obreak_args *, register_t *);

int	compat_20_sys_getfsstat(struct lwp *, const struct compat_20_sys_getfsstat_args *, register_t *);

int	compat_43_sys_lseek(struct lwp *, const struct compat_43_sys_lseek_args *, register_t *);

int	sys_getpid_with_ppid(struct lwp *, const void *, register_t *);

int	compat_40_sys_mount(struct lwp *, const struct compat_40_sys_mount_args *, register_t *);

int	sys_unmount(struct lwp *, const struct sys_unmount_args *, register_t *);

int	sys_setuid(struct lwp *, const struct sys_setuid_args *, register_t *);

int	sys_getuid_with_euid(struct lwp *, const void *, register_t *);

int	sys_geteuid(struct lwp *, const void *, register_t *);

int	sys_ptrace(struct lwp *, const struct sys_ptrace_args *, register_t *);

int	sys_recvmsg(struct lwp *, const struct sys_recvmsg_args *, register_t *);

int	sys_sendmsg(struct lwp *, const struct sys_sendmsg_args *, register_t *);

int	sys_recvfrom(struct lwp *, const struct sys_recvfrom_args *, register_t *);

int	sys_accept(struct lwp *, const struct sys_accept_args *, register_t *);

int	sys_getpeername(struct lwp *, const struct sys_getpeername_args *, register_t *);

int	sys_getsockname(struct lwp *, const struct sys_getsockname_args *, register_t *);

int	sys_access(struct lwp *, const struct sys_access_args *, register_t *);

int	sys_chflags(struct lwp *, const struct sys_chflags_args *, register_t *);

int	sys_fchflags(struct lwp *, const struct sys_fchflags_args *, register_t *);

int	sys_sync(struct lwp *, const void *, register_t *);

int	sys_kill(struct lwp *, const struct sys_kill_args *, register_t *);

int	compat_43_sys_stat(struct lwp *, const struct compat_43_sys_stat_args *, register_t *);

int	sys_getppid(struct lwp *, const void *, register_t *);

int	compat_43_sys_lstat(struct lwp *, const struct compat_43_sys_lstat_args *, register_t *);

int	sys_dup(struct lwp *, const struct sys_dup_args *, register_t *);

int	sys_pipe(struct lwp *, const void *, register_t *);

int	sys_getegid(struct lwp *, const void *, register_t *);

int	sys_profil(struct lwp *, const struct sys_profil_args *, register_t *);

int	sys_ktrace(struct lwp *, const struct sys_ktrace_args *, register_t *);

int	compat_13_sys_sigaction(struct lwp *, const struct compat_13_sys_sigaction_args *, register_t *);

int	sys_getgid_with_egid(struct lwp *, const void *, register_t *);

int	compat_13_sys_sigprocmask(struct lwp *, const struct compat_13_sys_sigprocmask_args *, register_t *);

int	sys___getlogin(struct lwp *, const struct sys___getlogin_args *, register_t *);

int	sys___setlogin(struct lwp *, const struct sys___setlogin_args *, register_t *);

int	sys_acct(struct lwp *, const struct sys_acct_args *, register_t *);

int	compat_13_sys_sigpending(struct lwp *, const void *, register_t *);

int	compat_13_sys_sigaltstack(struct lwp *, const struct compat_13_sys_sigaltstack_args *, register_t *);

int	sys_ioctl(struct lwp *, const struct sys_ioctl_args *, register_t *);

int	compat_12_sys_reboot(struct lwp *, const struct compat_12_sys_reboot_args *, register_t *);

int	sys_revoke(struct lwp *, const struct sys_revoke_args *, register_t *);

int	sys_symlink(struct lwp *, const struct sys_symlink_args *, register_t *);

int	sys_readlink(struct lwp *, const struct sys_readlink_args *, register_t *);

int	sys_execve(struct lwp *, const struct sys_execve_args *, register_t *);

int	sys_umask(struct lwp *, const struct sys_umask_args *, register_t *);

int	sys_chroot(struct lwp *, const struct sys_chroot_args *, register_t *);

int	compat_43_sys_fstat(struct lwp *, const struct compat_43_sys_fstat_args *, register_t *);

int	compat_43_sys_getkerninfo(struct lwp *, const struct compat_43_sys_getkerninfo_args *, register_t *);

int	compat_43_sys_getpagesize(struct lwp *, const void *, register_t *);

int	compat_12_sys_msync(struct lwp *, const struct compat_12_sys_msync_args *, register_t *);

int	sys_vfork(struct lwp *, const void *, register_t *);

int	sys_sbrk(struct lwp *, const struct sys_sbrk_args *, register_t *);

int	sys_sstk(struct lwp *, const struct sys_sstk_args *, register_t *);

int	compat_43_sys_mmap(struct lwp *, const struct compat_43_sys_mmap_args *, register_t *);

int	sys_ovadvise(struct lwp *, const struct sys_ovadvise_args *, register_t *);

int	sys_munmap(struct lwp *, const struct sys_munmap_args *, register_t *);

int	sys_mprotect(struct lwp *, const struct sys_mprotect_args *, register_t *);

int	sys_madvise(struct lwp *, const struct sys_madvise_args *, register_t *);

int	sys_mincore(struct lwp *, const struct sys_mincore_args *, register_t *);

int	sys_getgroups(struct lwp *, const struct sys_getgroups_args *, register_t *);

int	sys_setgroups(struct lwp *, const struct sys_setgroups_args *, register_t *);

int	sys_getpgrp(struct lwp *, const void *, register_t *);

int	sys_setpgid(struct lwp *, const struct sys_setpgid_args *, register_t *);

int	compat_50_sys_setitimer(struct lwp *, const struct compat_50_sys_setitimer_args *, register_t *);

int	compat_43_sys_wait(struct lwp *, const void *, register_t *);

int	compat_12_sys_swapon(struct lwp *, const struct compat_12_sys_swapon_args *, register_t *);

int	compat_50_sys_getitimer(struct lwp *, const struct compat_50_sys_getitimer_args *, register_t *);

int	compat_43_sys_gethostname(struct lwp *, const struct compat_43_sys_gethostname_args *, register_t *);

int	compat_43_sys_sethostname(struct lwp *, const struct compat_43_sys_sethostname_args *, register_t *);

int	compat_43_sys_getdtablesize(struct lwp *, const void *, register_t *);

int	sys_dup2(struct lwp *, const struct sys_dup2_args *, register_t *);

int	sys_fcntl(struct lwp *, const struct sys_fcntl_args *, register_t *);

int	compat_50_sys_select(struct lwp *, const struct compat_50_sys_select_args *, register_t *);

int	sys_fsync(struct lwp *, const struct sys_fsync_args *, register_t *);

int	sys_setpriority(struct lwp *, const struct sys_setpriority_args *, register_t *);

int	compat_30_sys_socket(struct lwp *, const struct compat_30_sys_socket_args *, register_t *);

int	sys_connect(struct lwp *, const struct sys_connect_args *, register_t *);

int	compat_43_sys_accept(struct lwp *, const struct compat_43_sys_accept_args *, register_t *);

int	sys_getpriority(struct lwp *, const struct sys_getpriority_args *, register_t *);

int	compat_43_sys_send(struct lwp *, const struct compat_43_sys_send_args *, register_t *);

int	compat_43_sys_recv(struct lwp *, const struct compat_43_sys_recv_args *, register_t *);

int	compat_13_sys_sigreturn(struct lwp *, const struct compat_13_sys_sigreturn_args *, register_t *);

int	sys_bind(struct lwp *, const struct sys_bind_args *, register_t *);

int	sys_setsockopt(struct lwp *, const struct sys_setsockopt_args *, register_t *);

int	sys_listen(struct lwp *, const struct sys_listen_args *, register_t *);

int	compat_43_sys_sigvec(struct lwp *, const struct compat_43_sys_sigvec_args *, register_t *);

int	compat_43_sys_sigblock(struct lwp *, const struct compat_43_sys_sigblock_args *, register_t *);

int	compat_43_sys_sigsetmask(struct lwp *, const struct compat_43_sys_sigsetmask_args *, register_t *);

int	compat_13_sys_sigsuspend(struct lwp *, const struct compat_13_sys_sigsuspend_args *, register_t *);

int	compat_43_sys_sigstack(struct lwp *, const struct compat_43_sys_sigstack_args *, register_t *);

int	compat_43_sys_recvmsg(struct lwp *, const struct compat_43_sys_recvmsg_args *, register_t *);

int	compat_43_sys_sendmsg(struct lwp *, const struct compat_43_sys_sendmsg_args *, register_t *);

int	compat_50_sys_gettimeofday(struct lwp *, const struct compat_50_sys_gettimeofday_args *, register_t *);

int	compat_50_sys_getrusage(struct lwp *, const struct compat_50_sys_getrusage_args *, register_t *);

int	sys_getsockopt(struct lwp *, const struct sys_getsockopt_args *, register_t *);

int	sys_readv(struct lwp *, const struct sys_readv_args *, register_t *);

int	sys_writev(struct lwp *, const struct sys_writev_args *, register_t *);

int	compat_50_sys_settimeofday(struct lwp *, const struct compat_50_sys_settimeofday_args *, register_t *);

int	sys_fchown(struct lwp *, const struct sys_fchown_args *, register_t *);

int	sys_fchmod(struct lwp *, const struct sys_fchmod_args *, register_t *);

int	compat_43_sys_recvfrom(struct lwp *, const struct compat_43_sys_recvfrom_args *, register_t *);

int	sys_setreuid(struct lwp *, const struct sys_setreuid_args *, register_t *);

int	sys_setregid(struct lwp *, const struct sys_setregid_args *, register_t *);

int	sys_rename(struct lwp *, const struct sys_rename_args *, register_t *);

int	compat_43_sys_truncate(struct lwp *, const struct compat_43_sys_truncate_args *, register_t *);

int	compat_43_sys_ftruncate(struct lwp *, const struct compat_43_sys_ftruncate_args *, register_t *);

int	sys_flock(struct lwp *, const struct sys_flock_args *, register_t *);

int	sys_mkfifo(struct lwp *, const struct sys_mkfifo_args *, register_t *);

int	sys_sendto(struct lwp *, const struct sys_sendto_args *, register_t *);

int	sys_shutdown(struct lwp *, const struct sys_shutdown_args *, register_t *);

int	sys_socketpair(struct lwp *, const struct sys_socketpair_args *, register_t *);

int	sys_mkdir(struct lwp *, const struct sys_mkdir_args *, register_t *);

int	sys_rmdir(struct lwp *, const struct sys_rmdir_args *, register_t *);

int	compat_50_sys_utimes(struct lwp *, const struct compat_50_sys_utimes_args *, register_t *);

int	compat_50_sys_adjtime(struct lwp *, const struct compat_50_sys_adjtime_args *, register_t *);

int	compat_43_sys_getpeername(struct lwp *, const struct compat_43_sys_getpeername_args *, register_t *);

int	compat_43_sys_gethostid(struct lwp *, const void *, register_t *);

int	compat_43_sys_sethostid(struct lwp *, const struct compat_43_sys_sethostid_args *, register_t *);

int	compat_43_sys_getrlimit(struct lwp *, const struct compat_43_sys_getrlimit_args *, register_t *);

int	compat_43_sys_setrlimit(struct lwp *, const struct compat_43_sys_setrlimit_args *, register_t *);

int	compat_43_sys_killpg(struct lwp *, const struct compat_43_sys_killpg_args *, register_t *);

int	sys_setsid(struct lwp *, const void *, register_t *);

int	compat_50_sys_quotactl(struct lwp *, const struct compat_50_sys_quotactl_args *, register_t *);

int	compat_43_sys_quota(struct lwp *, const void *, register_t *);

int	compat_43_sys_getsockname(struct lwp *, const struct compat_43_sys_getsockname_args *, register_t *);

int	sys_nfssvc(struct lwp *, const struct sys_nfssvc_args *, register_t *);

int	compat_43_sys_getdirentries(struct lwp *, const struct compat_43_sys_getdirentries_args *, register_t *);

int	compat_20_sys_statfs(struct lwp *, const struct compat_20_sys_statfs_args *, register_t *);

int	compat_20_sys_fstatfs(struct lwp *, const struct compat_20_sys_fstatfs_args *, register_t *);

int	compat_30_sys_getfh(struct lwp *, const struct compat_30_sys_getfh_args *, register_t *);

int	compat_09_sys_getdomainname(struct lwp *, const struct compat_09_sys_getdomainname_args *, register_t *);

int	compat_09_sys_setdomainname(struct lwp *, const struct compat_09_sys_setdomainname_args *, register_t *);

int	compat_09_sys_uname(struct lwp *, const struct compat_09_sys_uname_args *, register_t *);

int	sys_sysarch(struct lwp *, const struct sys_sysarch_args *, register_t *);

#if (defined(SYSVSEM) || !defined(_KERNEL_OPT)) && !defined(_LP64)
int	compat_10_sys_semsys(struct lwp *, const struct compat_10_sys_semsys_args *, register_t *);

#else
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL_OPT)) && !defined(_LP64)
int	compat_10_sys_msgsys(struct lwp *, const struct compat_10_sys_msgsys_args *, register_t *);

#else
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL_OPT)) && !defined(_LP64)
int	compat_10_sys_shmsys(struct lwp *, const struct compat_10_sys_shmsys_args *, register_t *);

#else
#endif
int	sys_pread(struct lwp *, const struct sys_pread_args *, register_t *);

int	sys_pwrite(struct lwp *, const struct sys_pwrite_args *, register_t *);

int	compat_30_sys_ntp_gettime(struct lwp *, const struct compat_30_sys_ntp_gettime_args *, register_t *);

#if defined(NTP) || !defined(_KERNEL_OPT)
int	sys_ntp_adjtime(struct lwp *, const struct sys_ntp_adjtime_args *, register_t *);

#else
#endif
int	sys_setgid(struct lwp *, const struct sys_setgid_args *, register_t *);

int	sys_setegid(struct lwp *, const struct sys_setegid_args *, register_t *);

int	sys_seteuid(struct lwp *, const struct sys_seteuid_args *, register_t *);

int	sys_lfs_bmapv(struct lwp *, const struct sys_lfs_bmapv_args *, register_t *);

int	sys_lfs_markv(struct lwp *, const struct sys_lfs_markv_args *, register_t *);

int	sys_lfs_segclean(struct lwp *, const struct sys_lfs_segclean_args *, register_t *);

int	compat_50_sys_lfs_segwait(struct lwp *, const struct compat_50_sys_lfs_segwait_args *, register_t *);

int	compat_12_sys_stat(struct lwp *, const struct compat_12_sys_stat_args *, register_t *);

int	compat_12_sys_fstat(struct lwp *, const struct compat_12_sys_fstat_args *, register_t *);

int	compat_12_sys_lstat(struct lwp *, const struct compat_12_sys_lstat_args *, register_t *);

int	sys_pathconf(struct lwp *, const struct sys_pathconf_args *, register_t *);

int	sys_fpathconf(struct lwp *, const struct sys_fpathconf_args *, register_t *);

int	sys_getrlimit(struct lwp *, const struct sys_getrlimit_args *, register_t *);

int	sys_setrlimit(struct lwp *, const struct sys_setrlimit_args *, register_t *);

int	compat_12_sys_getdirentries(struct lwp *, const struct compat_12_sys_getdirentries_args *, register_t *);

int	sys_mmap(struct lwp *, const struct sys_mmap_args *, register_t *);

int	sys___syscall(struct lwp *, const struct sys___syscall_args *, register_t *);

int	sys_lseek(struct lwp *, const struct sys_lseek_args *, register_t *);

int	sys_truncate(struct lwp *, const struct sys_truncate_args *, register_t *);

int	sys_ftruncate(struct lwp *, const struct sys_ftruncate_args *, register_t *);

int	sys___sysctl(struct lwp *, const struct sys___sysctl_args *, register_t *);

int	sys_mlock(struct lwp *, const struct sys_mlock_args *, register_t *);

int	sys_munlock(struct lwp *, const struct sys_munlock_args *, register_t *);

int	sys_undelete(struct lwp *, const struct sys_undelete_args *, register_t *);

int	compat_50_sys_futimes(struct lwp *, const struct compat_50_sys_futimes_args *, register_t *);

int	sys_getpgid(struct lwp *, const struct sys_getpgid_args *, register_t *);

int	sys_reboot(struct lwp *, const struct sys_reboot_args *, register_t *);

int	sys_poll(struct lwp *, const struct sys_poll_args *, register_t *);

#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
int	compat_14_sys___semctl(struct lwp *, const struct compat_14_sys___semctl_args *, register_t *);

int	sys_semget(struct lwp *, const struct sys_semget_args *, register_t *);

int	sys_semop(struct lwp *, const struct sys_semop_args *, register_t *);

int	sys_semconfig(struct lwp *, const struct sys_semconfig_args *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
int	compat_14_sys_msgctl(struct lwp *, const struct compat_14_sys_msgctl_args *, register_t *);

int	sys_msgget(struct lwp *, const struct sys_msgget_args *, register_t *);

int	sys_msgsnd(struct lwp *, const struct sys_msgsnd_args *, register_t *);

int	sys_msgrcv(struct lwp *, const struct sys_msgrcv_args *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
int	sys_shmat(struct lwp *, const struct sys_shmat_args *, register_t *);

int	compat_14_sys_shmctl(struct lwp *, const struct compat_14_sys_shmctl_args *, register_t *);

int	sys_shmdt(struct lwp *, const struct sys_shmdt_args *, register_t *);

int	sys_shmget(struct lwp *, const struct sys_shmget_args *, register_t *);

#else
#endif
int	compat_50_sys_clock_gettime(struct lwp *, const struct compat_50_sys_clock_gettime_args *, register_t *);

int	compat_50_sys_clock_settime(struct lwp *, const struct compat_50_sys_clock_settime_args *, register_t *);

int	compat_50_sys_clock_getres(struct lwp *, const struct compat_50_sys_clock_getres_args *, register_t *);

int	sys_timer_create(struct lwp *, const struct sys_timer_create_args *, register_t *);

int	sys_timer_delete(struct lwp *, const struct sys_timer_delete_args *, register_t *);

int	compat_50_sys_timer_settime(struct lwp *, const struct compat_50_sys_timer_settime_args *, register_t *);

int	compat_50_sys_timer_gettime(struct lwp *, const struct compat_50_sys_timer_gettime_args *, register_t *);

int	sys_timer_getoverrun(struct lwp *, const struct sys_timer_getoverrun_args *, register_t *);

int	compat_50_sys_nanosleep(struct lwp *, const struct compat_50_sys_nanosleep_args *, register_t *);

int	sys_fdatasync(struct lwp *, const struct sys_fdatasync_args *, register_t *);

int	sys_mlockall(struct lwp *, const struct sys_mlockall_args *, register_t *);

int	sys_munlockall(struct lwp *, const void *, register_t *);

int	compat_50_sys___sigtimedwait(struct lwp *, const struct compat_50_sys___sigtimedwait_args *, register_t *);

int	sys_sigqueueinfo(struct lwp *, const struct sys_sigqueueinfo_args *, register_t *);

int	sys_modctl(struct lwp *, const struct sys_modctl_args *, register_t *);

int	sys__ksem_init(struct lwp *, const struct sys__ksem_init_args *, register_t *);

int	sys__ksem_open(struct lwp *, const struct sys__ksem_open_args *, register_t *);

int	sys__ksem_unlink(struct lwp *, const struct sys__ksem_unlink_args *, register_t *);

int	sys__ksem_close(struct lwp *, const struct sys__ksem_close_args *, register_t *);

int	sys__ksem_post(struct lwp *, const struct sys__ksem_post_args *, register_t *);

int	sys__ksem_wait(struct lwp *, const struct sys__ksem_wait_args *, register_t *);

int	sys__ksem_trywait(struct lwp *, const struct sys__ksem_trywait_args *, register_t *);

int	sys__ksem_getvalue(struct lwp *, const struct sys__ksem_getvalue_args *, register_t *);

int	sys__ksem_destroy(struct lwp *, const struct sys__ksem_destroy_args *, register_t *);

int	sys_mq_open(struct lwp *, const struct sys_mq_open_args *, register_t *);

int	sys_mq_close(struct lwp *, const struct sys_mq_close_args *, register_t *);

int	sys_mq_unlink(struct lwp *, const struct sys_mq_unlink_args *, register_t *);

int	sys_mq_getattr(struct lwp *, const struct sys_mq_getattr_args *, register_t *);

int	sys_mq_setattr(struct lwp *, const struct sys_mq_setattr_args *, register_t *);

int	sys_mq_notify(struct lwp *, const struct sys_mq_notify_args *, register_t *);

int	sys_mq_send(struct lwp *, const struct sys_mq_send_args *, register_t *);

int	sys_mq_receive(struct lwp *, const struct sys_mq_receive_args *, register_t *);

int	compat_50_sys_mq_timedsend(struct lwp *, const struct compat_50_sys_mq_timedsend_args *, register_t *);

int	compat_50_sys_mq_timedreceive(struct lwp *, const struct compat_50_sys_mq_timedreceive_args *, register_t *);

int	sys___posix_rename(struct lwp *, const struct sys___posix_rename_args *, register_t *);

int	sys_swapctl(struct lwp *, const struct sys_swapctl_args *, register_t *);

int	compat_30_sys_getdents(struct lwp *, const struct compat_30_sys_getdents_args *, register_t *);

int	sys_minherit(struct lwp *, const struct sys_minherit_args *, register_t *);

int	sys_lchmod(struct lwp *, const struct sys_lchmod_args *, register_t *);

int	sys_lchown(struct lwp *, const struct sys_lchown_args *, register_t *);

int	compat_50_sys_lutimes(struct lwp *, const struct compat_50_sys_lutimes_args *, register_t *);

int	sys___msync13(struct lwp *, const struct sys___msync13_args *, register_t *);

int	compat_30_sys___stat13(struct lwp *, const struct compat_30_sys___stat13_args *, register_t *);

int	compat_30_sys___fstat13(struct lwp *, const struct compat_30_sys___fstat13_args *, register_t *);

int	compat_30_sys___lstat13(struct lwp *, const struct compat_30_sys___lstat13_args *, register_t *);

int	sys___sigaltstack14(struct lwp *, const struct sys___sigaltstack14_args *, register_t *);

int	sys___vfork14(struct lwp *, const void *, register_t *);

int	sys___posix_chown(struct lwp *, const struct sys___posix_chown_args *, register_t *);

int	sys___posix_fchown(struct lwp *, const struct sys___posix_fchown_args *, register_t *);

int	sys___posix_lchown(struct lwp *, const struct sys___posix_lchown_args *, register_t *);

int	sys_getsid(struct lwp *, const struct sys_getsid_args *, register_t *);

int	sys___clone(struct lwp *, const struct sys___clone_args *, register_t *);

int	sys_fktrace(struct lwp *, const struct sys_fktrace_args *, register_t *);

int	sys_preadv(struct lwp *, const struct sys_preadv_args *, register_t *);

int	sys_pwritev(struct lwp *, const struct sys_pwritev_args *, register_t *);

int	compat_16_sys___sigaction14(struct lwp *, const struct compat_16_sys___sigaction14_args *, register_t *);

int	sys___sigpending14(struct lwp *, const struct sys___sigpending14_args *, register_t *);

int	sys___sigprocmask14(struct lwp *, const struct sys___sigprocmask14_args *, register_t *);

int	sys___sigsuspend14(struct lwp *, const struct sys___sigsuspend14_args *, register_t *);

int	compat_16_sys___sigreturn14(struct lwp *, const struct compat_16_sys___sigreturn14_args *, register_t *);

int	sys___getcwd(struct lwp *, const struct sys___getcwd_args *, register_t *);

int	sys_fchroot(struct lwp *, const struct sys_fchroot_args *, register_t *);

int	compat_30_sys_fhopen(struct lwp *, const struct compat_30_sys_fhopen_args *, register_t *);

int	compat_30_sys_fhstat(struct lwp *, const struct compat_30_sys_fhstat_args *, register_t *);

int	compat_20_sys_fhstatfs(struct lwp *, const struct compat_20_sys_fhstatfs_args *, register_t *);

#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
int	compat_50_sys_____semctl13(struct lwp *, const struct compat_50_sys_____semctl13_args *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
int	compat_50_sys___msgctl13(struct lwp *, const struct compat_50_sys___msgctl13_args *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
int	compat_50_sys___shmctl13(struct lwp *, const struct compat_50_sys___shmctl13_args *, register_t *);

#else
#endif
int	sys_lchflags(struct lwp *, const struct sys_lchflags_args *, register_t *);

int	sys_issetugid(struct lwp *, const void *, register_t *);

int	sys_utrace(struct lwp *, const struct sys_utrace_args *, register_t *);

int	sys_getcontext(struct lwp *, const struct sys_getcontext_args *, register_t *);

int	sys_setcontext(struct lwp *, const struct sys_setcontext_args *, register_t *);

int	sys__lwp_create(struct lwp *, const struct sys__lwp_create_args *, register_t *);

int	sys__lwp_exit(struct lwp *, const void *, register_t *);

int	sys__lwp_self(struct lwp *, const void *, register_t *);

int	sys__lwp_wait(struct lwp *, const struct sys__lwp_wait_args *, register_t *);

int	sys__lwp_suspend(struct lwp *, const struct sys__lwp_suspend_args *, register_t *);

int	sys__lwp_continue(struct lwp *, const struct sys__lwp_continue_args *, register_t *);

int	sys__lwp_wakeup(struct lwp *, const struct sys__lwp_wakeup_args *, register_t *);

int	sys__lwp_getprivate(struct lwp *, const void *, register_t *);

int	sys__lwp_setprivate(struct lwp *, const struct sys__lwp_setprivate_args *, register_t *);

int	sys__lwp_kill(struct lwp *, const struct sys__lwp_kill_args *, register_t *);

int	sys__lwp_detach(struct lwp *, const struct sys__lwp_detach_args *, register_t *);

int	compat_50_sys__lwp_park(struct lwp *, const struct compat_50_sys__lwp_park_args *, register_t *);

int	sys__lwp_unpark(struct lwp *, const struct sys__lwp_unpark_args *, register_t *);

int	sys__lwp_unpark_all(struct lwp *, const struct sys__lwp_unpark_all_args *, register_t *);

int	sys__lwp_setname(struct lwp *, const struct sys__lwp_setname_args *, register_t *);

int	sys__lwp_getname(struct lwp *, const struct sys__lwp_getname_args *, register_t *);

int	sys__lwp_ctl(struct lwp *, const struct sys__lwp_ctl_args *, register_t *);

int	sys_sa_register(struct lwp *, const struct sys_sa_register_args *, register_t *);

int	sys_sa_stacks(struct lwp *, const struct sys_sa_stacks_args *, register_t *);

int	sys_sa_enable(struct lwp *, const void *, register_t *);

int	sys_sa_setconcurrency(struct lwp *, const struct sys_sa_setconcurrency_args *, register_t *);

int	sys_sa_yield(struct lwp *, const void *, register_t *);

int	sys_sa_preempt(struct lwp *, const struct sys_sa_preempt_args *, register_t *);

int	sys___sigaction_sigtramp(struct lwp *, const struct sys___sigaction_sigtramp_args *, register_t *);

int	sys_pmc_get_info(struct lwp *, const struct sys_pmc_get_info_args *, register_t *);

int	sys_pmc_control(struct lwp *, const struct sys_pmc_control_args *, register_t *);

int	sys_rasctl(struct lwp *, const struct sys_rasctl_args *, register_t *);

int	sys_kqueue(struct lwp *, const void *, register_t *);

int	compat_50_sys_kevent(struct lwp *, const struct compat_50_sys_kevent_args *, register_t *);

int	sys__sched_setparam(struct lwp *, const struct sys__sched_setparam_args *, register_t *);

int	sys__sched_getparam(struct lwp *, const struct sys__sched_getparam_args *, register_t *);

int	sys__sched_setaffinity(struct lwp *, const struct sys__sched_setaffinity_args *, register_t *);

int	sys__sched_getaffinity(struct lwp *, const struct sys__sched_getaffinity_args *, register_t *);

int	sys_sched_yield(struct lwp *, const void *, register_t *);

int	sys_fsync_range(struct lwp *, const struct sys_fsync_range_args *, register_t *);

int	sys_uuidgen(struct lwp *, const struct sys_uuidgen_args *, register_t *);

int	sys_getvfsstat(struct lwp *, const struct sys_getvfsstat_args *, register_t *);

int	sys_statvfs1(struct lwp *, const struct sys_statvfs1_args *, register_t *);

int	sys_fstatvfs1(struct lwp *, const struct sys_fstatvfs1_args *, register_t *);

int	compat_30_sys_fhstatvfs1(struct lwp *, const struct compat_30_sys_fhstatvfs1_args *, register_t *);

int	sys_extattrctl(struct lwp *, const struct sys_extattrctl_args *, register_t *);

int	sys_extattr_set_file(struct lwp *, const struct sys_extattr_set_file_args *, register_t *);

int	sys_extattr_get_file(struct lwp *, const struct sys_extattr_get_file_args *, register_t *);

int	sys_extattr_delete_file(struct lwp *, const struct sys_extattr_delete_file_args *, register_t *);

int	sys_extattr_set_fd(struct lwp *, const struct sys_extattr_set_fd_args *, register_t *);

int	sys_extattr_get_fd(struct lwp *, const struct sys_extattr_get_fd_args *, register_t *);

int	sys_extattr_delete_fd(struct lwp *, const struct sys_extattr_delete_fd_args *, register_t *);

int	sys_extattr_set_link(struct lwp *, const struct sys_extattr_set_link_args *, register_t *);

int	sys_extattr_get_link(struct lwp *, const struct sys_extattr_get_link_args *, register_t *);

int	sys_extattr_delete_link(struct lwp *, const struct sys_extattr_delete_link_args *, register_t *);

int	sys_extattr_list_fd(struct lwp *, const struct sys_extattr_list_fd_args *, register_t *);

int	sys_extattr_list_file(struct lwp *, const struct sys_extattr_list_file_args *, register_t *);

int	sys_extattr_list_link(struct lwp *, const struct sys_extattr_list_link_args *, register_t *);

int	compat_50_sys_pselect(struct lwp *, const struct compat_50_sys_pselect_args *, register_t *);

int	compat_50_sys_pollts(struct lwp *, const struct compat_50_sys_pollts_args *, register_t *);

int	sys_setxattr(struct lwp *, const struct sys_setxattr_args *, register_t *);

int	sys_lsetxattr(struct lwp *, const struct sys_lsetxattr_args *, register_t *);

int	sys_fsetxattr(struct lwp *, const struct sys_fsetxattr_args *, register_t *);

int	sys_getxattr(struct lwp *, const struct sys_getxattr_args *, register_t *);

int	sys_lgetxattr(struct lwp *, const struct sys_lgetxattr_args *, register_t *);

int	sys_fgetxattr(struct lwp *, const struct sys_fgetxattr_args *, register_t *);

int	sys_listxattr(struct lwp *, const struct sys_listxattr_args *, register_t *);

int	sys_llistxattr(struct lwp *, const struct sys_llistxattr_args *, register_t *);

int	sys_flistxattr(struct lwp *, const struct sys_flistxattr_args *, register_t *);

int	sys_removexattr(struct lwp *, const struct sys_removexattr_args *, register_t *);

int	sys_lremovexattr(struct lwp *, const struct sys_lremovexattr_args *, register_t *);

int	sys_fremovexattr(struct lwp *, const struct sys_fremovexattr_args *, register_t *);

int	compat_50_sys___stat30(struct lwp *, const struct compat_50_sys___stat30_args *, register_t *);

int	compat_50_sys___fstat30(struct lwp *, const struct compat_50_sys___fstat30_args *, register_t *);

int	compat_50_sys___lstat30(struct lwp *, const struct compat_50_sys___lstat30_args *, register_t *);

int	sys___getdents30(struct lwp *, const struct sys___getdents30_args *, register_t *);

int	compat_30_sys___fhstat30(struct lwp *, const struct compat_30_sys___fhstat30_args *, register_t *);

int	compat_50_sys___ntp_gettime30(struct lwp *, const struct compat_50_sys___ntp_gettime30_args *, register_t *);

int	sys___socket30(struct lwp *, const struct sys___socket30_args *, register_t *);

int	sys___getfh30(struct lwp *, const struct sys___getfh30_args *, register_t *);

int	sys___fhopen40(struct lwp *, const struct sys___fhopen40_args *, register_t *);

int	sys___fhstatvfs140(struct lwp *, const struct sys___fhstatvfs140_args *, register_t *);

int	compat_50_sys___fhstat40(struct lwp *, const struct compat_50_sys___fhstat40_args *, register_t *);

int	sys_aio_cancel(struct lwp *, const struct sys_aio_cancel_args *, register_t *);

int	sys_aio_error(struct lwp *, const struct sys_aio_error_args *, register_t *);

int	sys_aio_fsync(struct lwp *, const struct sys_aio_fsync_args *, register_t *);

int	sys_aio_read(struct lwp *, const struct sys_aio_read_args *, register_t *);

int	sys_aio_return(struct lwp *, const struct sys_aio_return_args *, register_t *);

int	compat_50_sys_aio_suspend(struct lwp *, const struct compat_50_sys_aio_suspend_args *, register_t *);

int	sys_aio_write(struct lwp *, const struct sys_aio_write_args *, register_t *);

int	sys_lio_listio(struct lwp *, const struct sys_lio_listio_args *, register_t *);

int	sys___mount50(struct lwp *, const struct sys___mount50_args *, register_t *);

int	sys_mremap(struct lwp *, const struct sys_mremap_args *, register_t *);

int	sys_pset_create(struct lwp *, const struct sys_pset_create_args *, register_t *);

int	sys_pset_destroy(struct lwp *, const struct sys_pset_destroy_args *, register_t *);

int	sys_pset_assign(struct lwp *, const struct sys_pset_assign_args *, register_t *);

int	sys__pset_bind(struct lwp *, const struct sys__pset_bind_args *, register_t *);

int	sys___posix_fadvise50(struct lwp *, const struct sys___posix_fadvise50_args *, register_t *);

int	sys___select50(struct lwp *, const struct sys___select50_args *, register_t *);

int	sys___gettimeofday50(struct lwp *, const struct sys___gettimeofday50_args *, register_t *);

int	sys___settimeofday50(struct lwp *, const struct sys___settimeofday50_args *, register_t *);

int	sys___utimes50(struct lwp *, const struct sys___utimes50_args *, register_t *);

int	sys___adjtime50(struct lwp *, const struct sys___adjtime50_args *, register_t *);

int	sys___lfs_segwait50(struct lwp *, const struct sys___lfs_segwait50_args *, register_t *);

int	sys___futimes50(struct lwp *, const struct sys___futimes50_args *, register_t *);

int	sys___lutimes50(struct lwp *, const struct sys___lutimes50_args *, register_t *);

int	sys___setitimer50(struct lwp *, const struct sys___setitimer50_args *, register_t *);

int	sys___getitimer50(struct lwp *, const struct sys___getitimer50_args *, register_t *);

int	sys___clock_gettime50(struct lwp *, const struct sys___clock_gettime50_args *, register_t *);

int	sys___clock_settime50(struct lwp *, const struct sys___clock_settime50_args *, register_t *);

int	sys___clock_getres50(struct lwp *, const struct sys___clock_getres50_args *, register_t *);

int	sys___nanosleep50(struct lwp *, const struct sys___nanosleep50_args *, register_t *);

int	sys_____sigtimedwait50(struct lwp *, const struct sys_____sigtimedwait50_args *, register_t *);

int	sys___mq_timedsend50(struct lwp *, const struct sys___mq_timedsend50_args *, register_t *);

int	sys___mq_timedreceive50(struct lwp *, const struct sys___mq_timedreceive50_args *, register_t *);

int	sys____lwp_park50(struct lwp *, const struct sys____lwp_park50_args *, register_t *);

int	sys___kevent50(struct lwp *, const struct sys___kevent50_args *, register_t *);

int	sys___pselect50(struct lwp *, const struct sys___pselect50_args *, register_t *);

int	sys___pollts50(struct lwp *, const struct sys___pollts50_args *, register_t *);

int	sys___aio_suspend50(struct lwp *, const struct sys___aio_suspend50_args *, register_t *);

int	sys___stat50(struct lwp *, const struct sys___stat50_args *, register_t *);

int	sys___fstat50(struct lwp *, const struct sys___fstat50_args *, register_t *);

int	sys___lstat50(struct lwp *, const struct sys___lstat50_args *, register_t *);

#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
int	sys_____semctl50(struct lwp *, const struct sys_____semctl50_args *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
int	sys___shmctl50(struct lwp *, const struct sys___shmctl50_args *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
int	sys___msgctl50(struct lwp *, const struct sys___msgctl50_args *, register_t *);

#else
#endif
int	sys___getrusage50(struct lwp *, const struct sys___getrusage50_args *, register_t *);

int	sys___timer_settime50(struct lwp *, const struct sys___timer_settime50_args *, register_t *);

int	sys___timer_gettime50(struct lwp *, const struct sys___timer_gettime50_args *, register_t *);

#if defined(NTP) || !defined(_KERNEL_OPT)
int	sys___ntp_gettime50(struct lwp *, const struct sys___ntp_gettime50_args *, register_t *);

#else
#endif
int	sys___wait450(struct lwp *, const struct sys___wait450_args *, register_t *);

int	sys___mknod50(struct lwp *, const struct sys___mknod50_args *, register_t *);

int	sys___fhstat50(struct lwp *, const struct sys___fhstat50_args *, register_t *);

int	sys___quotactl50(struct lwp *, const struct sys___quotactl50_args *, register_t *);

int	sys_pipe2(struct lwp *, const struct sys_pipe2_args *, register_t *);

int	sys_dup3(struct lwp *, const struct sys_dup3_args *, register_t *);

int	sys_kqueue1(struct lwp *, const struct sys_kqueue1_args *, register_t *);

int	sys_paccept(struct lwp *, const struct sys_paccept_args *, register_t *);

int	sys_linkat(struct lwp *, const struct sys_linkat_args *, register_t *);

int	sys_renameat(struct lwp *, const struct sys_renameat_args *, register_t *);

int	sys_mkfifoat(struct lwp *, const struct sys_mkfifoat_args *, register_t *);

int	sys_mknodat(struct lwp *, const struct sys_mknodat_args *, register_t *);

int	sys_mkdirat(struct lwp *, const struct sys_mkdirat_args *, register_t *);

int	sys_faccessat(struct lwp *, const struct sys_faccessat_args *, register_t *);

int	sys_fchmodat(struct lwp *, const struct sys_fchmodat_args *, register_t *);

int	sys_fchownat(struct lwp *, const struct sys_fchownat_args *, register_t *);

int	sys_fexecve(struct lwp *, const struct sys_fexecve_args *, register_t *);

int	sys_fstatat(struct lwp *, const struct sys_fstatat_args *, register_t *);

int	sys_utimensat(struct lwp *, const struct sys_utimensat_args *, register_t *);

int	sys_openat(struct lwp *, const struct sys_openat_args *, register_t *);

int	sys_readlinkat(struct lwp *, const struct sys_readlinkat_args *, register_t *);

int	sys_symlinkat(struct lwp *, const struct sys_symlinkat_args *, register_t *);

int	sys_unlinkat(struct lwp *, const struct sys_unlinkat_args *, register_t *);

int	sys_futimens(struct lwp *, const struct sys_futimens_args *, register_t *);

#endif /* _SYS_SYSCALLARGS_H_ */
