/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.spi.SubsystemFactory;
import org.sonatype.nexus.client.core.spi.SubsystemProvider;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

@Named
@Singleton
public class SubsystemFactoriesSubsystemProvider
implements SubsystemProvider {
    private Set<SubsystemFactory<?, JerseyNexusClient>> subsystemFactories;

    @Inject
    public SubsystemFactoriesSubsystemProvider(Set<SubsystemFactory<?, JerseyNexusClient>> subsystemFactories) {
        this.subsystemFactories = (Set)Preconditions.checkNotNull(subsystemFactories, (Object)"subsystemFactories cannot be null");
    }

    @Override
    public Object get(Class type, Map<Object, Object> context) {
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        Preconditions.checkNotNull(context, (Object)"context cannot be null");
        JerseyNexusClient jerseyNexusClient = (JerseyNexusClient)context.get(NexusClient.class);
        if (jerseyNexusClient != null) {
            for (SubsystemFactory<?, JerseyNexusClient> subsystemFactory : this.subsystemFactories) {
                Object subsystem;
                if (!SubsystemFactoriesSubsystemProvider.canCreate(subsystemFactory, type, jerseyNexusClient) || (subsystem = subsystemFactory.create(jerseyNexusClient)) == null) continue;
                return subsystem;
            }
        }
        return null;
    }

    public static SubsystemProvider adapt(final SubsystemFactory<?, JerseyNexusClient> subsystemFactory) {
        Preconditions.checkNotNull(subsystemFactory, (Object)"subsystemFactory cannot be null");
        return new SubsystemProvider(){

            @Override
            public Object get(Class type, Map<Object, Object> context) {
                Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
                Preconditions.checkNotNull(context, (Object)"context cannot be null");
                JerseyNexusClient jerseyNexusClient = (JerseyNexusClient)context.get(NexusClient.class);
                if (jerseyNexusClient != null && SubsystemFactoriesSubsystemProvider.canCreate(subsystemFactory, type, jerseyNexusClient)) {
                    return subsystemFactory.create(jerseyNexusClient);
                }
                return null;
            }
        };
    }

    private static boolean canCreate(SubsystemFactory<?, JerseyNexusClient> subsystemFactory, Class type, JerseyNexusClient jerseyNexusClient) {
        if (!type.isAssignableFrom(subsystemFactory.getType())) {
            return false;
        }
        Condition condition = subsystemFactory.availableWhen();
        return condition == null || condition.isSatisfiedBy(jerseyNexusClient.getStatus());
    }
}

