/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.hash;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.hash.HashAlgorithm;
import org.sonatype.spice.zapper.hash.HashingInputStream;
import org.sonatype.spice.zapper.internal.Arrays;
import org.sonatype.spice.zapper.internal.Check;

public class HashUtils {
    public static final String CHARSET_UTF8_STRING = "UTF-8";
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(PrintStream ps, InputStream content) throws IOException {
        try {
            int numRead;
            byte[] buffer = new byte[16];
            int line = 0;
            do {
                if ((numRead = content.read(buffer)) <= 0) continue;
                ps.print(line + ": ");
                ps.print(HashUtils.encodeHex(Arrays.copyOf(buffer, numRead)));
                ps.println(" :" + line);
                ++line;
            } while (numRead != -1);
        }
        finally {
            HashUtils.close(content);
        }
    }

    public static String encodeHexString(byte[] buffer) {
        Check.notNull(buffer, "The buffer is null!");
        return new String(HashUtils.encodeHex(buffer));
    }

    public static byte[] decodeHexString(String string) {
        Check.notNull(string, "The string is null!");
        Check.argument(string.length() % 2 == 0, "Encoded string must have even length!");
        int len = string.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hash getDigest(HashAlgorithm alg, InputStream is) throws IOException {
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            HashingInputStream his = alg.hashInput(is);
            while ((numRead = his.read(buffer)) != -1) {
            }
            Hash hash = his.getHash();
            return hash;
        }
        finally {
            HashUtils.close(is);
        }
    }

    public static Hash getDigest(HashAlgorithm alg, File file) throws IOException {
        return HashUtils.getDigest(alg, new FileInputStream(file));
    }

    public static Hash getDigest(HashAlgorithm alg, byte[] buffer) {
        try {
            return HashUtils.getDigest(alg, new ByteArrayInputStream(buffer));
        }
        catch (IOException e) {
            throw new IllegalStateException("Huh?", e);
        }
    }

    public static Hash getDigest(HashAlgorithm alg, String content) {
        try {
            return HashUtils.getDigest(alg, content.getBytes(CHARSET_UTF8_STRING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 not supported?", e);
        }
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

