/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Scm;
import org.sonatype.nexus.rest.model.AliasingListConverter;
import org.sonatype.nexus.rest.model.ArtifactResolveResourceResponse;
import org.sonatype.nexus.rest.model.ConfigurationsListResource;
import org.sonatype.nexus.rest.model.ConfigurationsListResourceResponse;
import org.sonatype.nexus.rest.model.ContentListDescribeRequestResource;
import org.sonatype.nexus.rest.model.ContentListDescribeResourceResponse;
import org.sonatype.nexus.rest.model.ContentListDescribeResponseResource;
import org.sonatype.nexus.rest.model.ContentListResource;
import org.sonatype.nexus.rest.model.ContentListResourceResponse;
import org.sonatype.nexus.rest.model.FeedListResource;
import org.sonatype.nexus.rest.model.FeedListResourceResponse;
import org.sonatype.nexus.rest.model.FormFieldResource;
import org.sonatype.nexus.rest.model.GlobalConfigurationListResource;
import org.sonatype.nexus.rest.model.GlobalConfigurationListResourceResponse;
import org.sonatype.nexus.rest.model.GlobalConfigurationResource;
import org.sonatype.nexus.rest.model.GlobalConfigurationResourceResponse;
import org.sonatype.nexus.rest.model.HtmlEscapeStringConverter;
import org.sonatype.nexus.rest.model.Maven2ArtifactInfoResourceRespose;
import org.sonatype.nexus.rest.model.MirrorResource;
import org.sonatype.nexus.rest.model.MirrorResourceListRequest;
import org.sonatype.nexus.rest.model.MirrorResourceListResponse;
import org.sonatype.nexus.rest.model.MirrorStatusResource;
import org.sonatype.nexus.rest.model.MirrorStatusResourceListResponse;
import org.sonatype.nexus.rest.model.NFCRepositoryResource;
import org.sonatype.nexus.rest.model.NFCResource;
import org.sonatype.nexus.rest.model.NFCResourceResponse;
import org.sonatype.nexus.rest.model.NexusRepositoryTypeListResource;
import org.sonatype.nexus.rest.model.NexusRepositoryTypeListResourceResponse;
import org.sonatype.nexus.rest.model.PlexusComponentListResource;
import org.sonatype.nexus.rest.model.PlexusComponentListResourceResponse;
import org.sonatype.nexus.rest.model.PrivilegeResource;
import org.sonatype.nexus.rest.model.PrivilegeResourceRequest;
import org.sonatype.nexus.rest.model.RepositoryContentClassListResource;
import org.sonatype.nexus.rest.model.RepositoryContentClassListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryDependentStatusResource;
import org.sonatype.nexus.rest.model.RepositoryGroupListResource;
import org.sonatype.nexus.rest.model.RepositoryGroupListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryGroupMemberRepository;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryListResource;
import org.sonatype.nexus.rest.model.RepositoryListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryMetaResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryRouteListResource;
import org.sonatype.nexus.rest.model.RepositoryRouteListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryRouteMemberRepository;
import org.sonatype.nexus.rest.model.RepositoryRouteResource;
import org.sonatype.nexus.rest.model.RepositoryRouteResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryStatusListResource;
import org.sonatype.nexus.rest.model.RepositoryStatusListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryStatusResource;
import org.sonatype.nexus.rest.model.RepositoryStatusResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryTargetListResource;
import org.sonatype.nexus.rest.model.RepositoryTargetListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryTargetResource;
import org.sonatype.nexus.rest.model.RepositoryTargetResourceResponse;
import org.sonatype.nexus.rest.model.RoutingConfigMessage;
import org.sonatype.nexus.rest.model.RoutingConfigMessageWrapper;
import org.sonatype.nexus.rest.model.RoutingDiscoveryStatusMessage;
import org.sonatype.nexus.rest.model.RoutingStatusMessage;
import org.sonatype.nexus.rest.model.RoutingStatusMessageWrapper;
import org.sonatype.nexus.rest.model.ScheduledServiceBaseResource;
import org.sonatype.nexus.rest.model.ScheduledServiceListResource;
import org.sonatype.nexus.rest.model.ScheduledServiceListResourceResponse;
import org.sonatype.nexus.rest.model.ScheduledServicePropertyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceResponse;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatusResponse;
import org.sonatype.nexus.rest.model.ScheduledServiceTypeResource;
import org.sonatype.nexus.rest.model.ScheduledServiceTypeResourceResponse;
import org.sonatype.nexus.rest.model.ScheduledServiceWeeklyResource;
import org.sonatype.nexus.rest.model.SmtpSettingsResourceRequest;
import org.sonatype.nexus.rest.model.StatusConfigurationValidationResponse;
import org.sonatype.nexus.rest.model.StatusResourceResponse;
import org.sonatype.nexus.rest.model.UserAccount;
import org.sonatype.nexus.rest.model.UserAccountRequestResponseWrapper;
import org.sonatype.nexus.rest.model.WastebasketResourceResponse;
import org.sonatype.nexus.rest.repositories.RepositoryBaseResourceConverter;
import org.sonatype.nexus.rest.repositories.RepositoryResourceResponseConverter;
import org.sonatype.nexus.rest.schedules.ScheduledServiceBaseResourceConverter;
import org.sonatype.nexus.rest.schedules.ScheduledServicePropertyResourceConverter;
import org.sonatype.nexus.rest.schedules.ScheduledServiceResourceResponseConverter;
import org.sonatype.security.rest.model.AuthenticationClientPermissions;
import org.sonatype.security.rest.model.AuthenticationLoginResourceResponse;
import org.sonatype.security.rest.model.ClientPermission;
import org.sonatype.security.rest.model.ExternalRoleMappingListResourceResponse;
import org.sonatype.security.rest.model.ExternalRoleMappingResource;
import org.sonatype.security.rest.model.ExternalRoleMappingResourceResponse;
import org.sonatype.security.rest.model.PlexusRoleListResourceResponse;
import org.sonatype.security.rest.model.PlexusRoleResource;
import org.sonatype.security.rest.model.PlexusUserListResourceResponse;
import org.sonatype.security.rest.model.PlexusUserResource;
import org.sonatype.security.rest.model.PlexusUserResourceResponse;
import org.sonatype.security.rest.model.PlexusUserSearchCriteriaResourceRequest;
import org.sonatype.security.rest.model.PrivilegeListResourceResponse;
import org.sonatype.security.rest.model.PrivilegeProperty;
import org.sonatype.security.rest.model.PrivilegeStatusResource;
import org.sonatype.security.rest.model.PrivilegeStatusResourceResponse;
import org.sonatype.security.rest.model.PrivilegeTypePropertyResource;
import org.sonatype.security.rest.model.PrivilegeTypeResource;
import org.sonatype.security.rest.model.PrivilegeTypeResourceResponse;
import org.sonatype.security.rest.model.RoleListResourceResponse;
import org.sonatype.security.rest.model.RoleResource;
import org.sonatype.security.rest.model.RoleResourceRequest;
import org.sonatype.security.rest.model.RoleResourceResponse;
import org.sonatype.security.rest.model.UserChangePasswordRequest;
import org.sonatype.security.rest.model.UserListResourceResponse;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.rest.model.UserResourceRequest;
import org.sonatype.security.rest.model.UserResourceResponse;
import org.sonatype.security.rest.model.UserToRoleResource;
import org.sonatype.security.rest.model.UserToRoleResourceRequest;

public class XStreamConfiguratorLightweight {
    public static XStream configureXStream(XStream xstream, Class<?> errorResponseClazz, Class<?> errorMessageClazz) {
        xstream.registerConverter((SingleValueConverter)new HtmlEscapeStringConverter());
        xstream.registerConverter((Converter)new RepositoryBaseResourceConverter(xstream.getMapper(), xstream.getReflectionProvider()), 10000);
        xstream.registerConverter((Converter)new RepositoryResourceResponseConverter(xstream.getMapper(), xstream.getReflectionProvider()), 10000);
        xstream.registerConverter((Converter)new ScheduledServiceBaseResourceConverter(xstream.getMapper(), xstream.getReflectionProvider()), 10000);
        xstream.registerConverter((Converter)new ScheduledServicePropertyResourceConverter(xstream.getMapper(), xstream.getReflectionProvider()), 10000);
        xstream.registerConverter((Converter)new ScheduledServiceResourceResponseConverter(xstream.getMapper(), xstream.getReflectionProvider()), 10000);
        xstream.alias("project", Model.class);
        Class[] types = new Class[]{ArtifactResolveResourceResponse.class, GlobalConfigurationListResourceResponse.class, GlobalConfigurationResourceResponse.class, RepositoryStatusListResourceResponse.class, RepositoryListResourceResponse.class, RepositoryResourceResponse.class, RepositoryStatusResourceResponse.class, RepositoryMetaResourceResponse.class, RepositoryGroupListResourceResponse.class, RepositoryGroupResourceResponse.class, RepositoryRouteListResourceResponse.class, RepositoryRouteResourceResponse.class, ScheduledServiceListResourceResponse.class, ScheduledServiceResourceStatusResponse.class, ScheduledServiceResourceResponse.class, ScheduledServiceTypeResourceResponse.class, ContentListResourceResponse.class, ContentListDescribeResourceResponse.class, ConfigurationsListResourceResponse.class, FeedListResourceResponse.class, NFCResourceResponse.class, StatusResourceResponse.class, WastebasketResourceResponse.class, RepositoryTargetListResourceResponse.class, RepositoryTargetResourceResponse.class, RepositoryContentClassListResourceResponse.class, MirrorResourceListResponse.class, MirrorResourceListRequest.class, MirrorStatusResourceListResponse.class, SmtpSettingsResourceRequest.class, PlexusComponentListResourceResponse.class, NexusRepositoryTypeListResourceResponse.class, PrivilegeResourceRequest.class, Maven2ArtifactInfoResourceRespose.class};
        xstream.allowTypes(types);
        xstream.processAnnotations(types);
        xstream.alias("nexus-error", errorResponseClazz);
        xstream.alias("error", errorMessageClazz);
        xstream.registerLocalConverter(errorResponseClazz, "errors", (Converter)new AliasingListConverter(errorMessageClazz, "error"));
        xstream.registerLocalConverter(ContentListResourceResponse.class, "data", (Converter)new AliasingListConverter(ContentListResource.class, "content-item"));
        xstream.registerLocalConverter(RepositoryListResourceResponse.class, "data", (Converter)new AliasingListConverter(RepositoryListResource.class, "repositories-item"));
        xstream.registerLocalConverter(NexusRepositoryTypeListResourceResponse.class, "data", (Converter)new AliasingListConverter(NexusRepositoryTypeListResource.class, "repositoryType"));
        xstream.registerLocalConverter(RepositoryStatusListResourceResponse.class, "data", (Converter)new AliasingListConverter(RepositoryStatusListResource.class, "repository-status-list-item"));
        xstream.registerLocalConverter(RepositoryGroupListResource.class, "repositories", (Converter)new AliasingListConverter(RepositoryGroupMemberRepository.class, "repo-group-member"));
        xstream.registerLocalConverter(RepositoryGroupResource.class, "repositories", (Converter)new AliasingListConverter(RepositoryGroupMemberRepository.class, "repo-group-member"));
        xstream.registerLocalConverter(RepositoryGroupListResourceResponse.class, "data", (Converter)new AliasingListConverter(RepositoryGroupListResource.class, "repo-group-list-item"));
        xstream.registerLocalConverter(RepositoryRouteListResourceResponse.class, "data", (Converter)new AliasingListConverter(RepositoryRouteListResource.class, "repo-routes-list-item"));
        xstream.registerLocalConverter(RepositoryRouteListResource.class, "repositories", (Converter)new AliasingListConverter(RepositoryRouteMemberRepository.class, "repo-routes-member"));
        xstream.registerLocalConverter(RepositoryRouteResource.class, "repositories", (Converter)new AliasingListConverter(RepositoryRouteMemberRepository.class, "repository"));
        xstream.registerLocalConverter(GlobalConfigurationListResourceResponse.class, "data", (Converter)new AliasingListConverter(GlobalConfigurationListResource.class, "global-settings-list-item"));
        xstream.registerLocalConverter(ConfigurationsListResourceResponse.class, "data", (Converter)new AliasingListConverter(ConfigurationsListResource.class, "configs-list-item"));
        xstream.registerLocalConverter(FeedListResourceResponse.class, "data", (Converter)new AliasingListConverter(FeedListResource.class, "feeds-list-item"));
        xstream.alias("authentication-login", AuthenticationLoginResourceResponse.class);
        xstream.registerLocalConverter(AuthenticationClientPermissions.class, "permissions", (Converter)new AliasingListConverter(ClientPermission.class, "permission"));
        xstream.registerLocalConverter(StatusConfigurationValidationResponse.class, "validationErrors", (Converter)new AliasingListConverter(String.class, "error"));
        xstream.registerLocalConverter(StatusConfigurationValidationResponse.class, "validationWarnings", (Converter)new AliasingListConverter(String.class, "warning"));
        xstream.registerLocalConverter(ScheduledServiceBaseResource.class, "properties", (Converter)new AliasingListConverter(ScheduledServicePropertyResource.class, "scheduled-task-property"));
        xstream.registerLocalConverter(ScheduledServiceWeeklyResource.class, "recurringDay", (Converter)new AliasingListConverter(String.class, "day"));
        xstream.registerLocalConverter(ScheduledServiceTypeResourceResponse.class, "data", (Converter)new AliasingListConverter(ScheduledServiceTypeResource.class, "schedule-type"));
        xstream.registerLocalConverter(ScheduledServiceTypeResource.class, "formFields", (Converter)new AliasingListConverter(FormFieldResource.class, "form-field"));
        xstream.registerLocalConverter(ScheduledServiceListResourceResponse.class, "data", (Converter)new AliasingListConverter(ScheduledServiceListResource.class, "schedules-list-item"));
        xstream.aliasField("methods", PrivilegeResource.class, "method");
        xstream.registerLocalConverter(NFCResource.class, "nfcContents", (Converter)new AliasingListConverter(NFCRepositoryResource.class, "nfc-repo-info"));
        xstream.registerLocalConverter(NFCRepositoryResource.class, "nfcPaths", (Converter)new AliasingListConverter(String.class, "path"));
        xstream.registerLocalConverter(RepositoryTargetResource.class, "patterns", (Converter)new AliasingListConverter(String.class, "pattern"));
        xstream.registerLocalConverter(RepositoryTargetListResourceResponse.class, "data", (Converter)new AliasingListConverter(RepositoryTargetListResource.class, "repo-targets-list-item"));
        xstream.registerLocalConverter(RepositoryContentClassListResourceResponse.class, "data", (Converter)new AliasingListConverter(RepositoryContentClassListResource.class, "repo-content-classes-list-item"));
        xstream.registerLocalConverter(PlexusComponentListResourceResponse.class, "data", (Converter)new AliasingListConverter(PlexusComponentListResource.class, "component"));
        xstream.registerLocalConverter(MirrorResourceListRequest.class, "data", (Converter)new AliasingListConverter(MirrorResource.class, "mirrorResource"));
        xstream.registerLocalConverter(MirrorResourceListResponse.class, "data", (Converter)new AliasingListConverter(MirrorResource.class, "mirrorResource"));
        xstream.registerLocalConverter(MirrorStatusResourceListResponse.class, "data", (Converter)new AliasingListConverter(MirrorStatusResource.class, "mirrorResource"));
        xstream.registerLocalConverter(ContentListDescribeRequestResource.class, "requestContext", (Converter)new AliasingListConverter(String.class, "requestContextItem"));
        xstream.registerLocalConverter(ContentListDescribeResponseResource.class, "appliedMappings", (Converter)new AliasingListConverter(String.class, "appliedMappingItem"));
        xstream.registerLocalConverter(ContentListDescribeResponseResource.class, "attributes", (Converter)new AliasingListConverter(String.class, "attributeItem"));
        xstream.registerLocalConverter(ContentListDescribeResponseResource.class, "processedRepositoriesList", (Converter)new AliasingListConverter(String.class, "processedRepositoriesListItem"));
        xstream.registerLocalConverter(ContentListDescribeResponseResource.class, "properties", (Converter)new AliasingListConverter(String.class, "propertyItem"));
        xstream.registerLocalConverter(ContentListDescribeResponseResource.class, "sources", (Converter)new AliasingListConverter(String.class, "sourceItem"));
        xstream.registerLocalConverter(RepositoryStatusResource.class, "dependentRepos", (Converter)new AliasingListConverter(RepositoryDependentStatusResource.class, "dependentRepoItem"));
        xstream.registerLocalConverter(GlobalConfigurationResource.class, "securityRealms", (Converter)new AliasingListConverter(String.class, "securityRealmItem"));
        xstream.omitField(Model.class, "modelEncoding");
        xstream.omitField(ModelBase.class, "modelEncoding");
        xstream.omitField(Scm.class, "modelEncoding");
        Class[] securityTypes = new Class[]{AuthenticationLoginResourceResponse.class, UserResourceResponse.class, UserListResourceResponse.class, UserResourceRequest.class, UserChangePasswordRequest.class, RoleListResourceResponse.class, RoleResource.class, RoleResourceRequest.class, RoleResourceResponse.class, PrivilegeListResourceResponse.class, PrivilegeStatusResourceResponse.class, PrivilegeTypeResourceResponse.class, UserToRoleResourceRequest.class, PlexusUserResourceResponse.class, PlexusRoleResource.class, PlexusUserListResourceResponse.class, ExternalRoleMappingListResourceResponse.class, ExternalRoleMappingResourceResponse.class, ExternalRoleMappingResource.class, PlexusRoleListResourceResponse.class, PlexusUserSearchCriteriaResourceRequest.class, org.sonatype.security.rest.model.PlexusComponentListResourceResponse.class, org.sonatype.security.rest.model.PlexusComponentListResource.class, UserAccount.class, UserAccountRequestResponseWrapper.class};
        xstream.allowTypes(securityTypes);
        xstream.processAnnotations(securityTypes);
        xstream.registerLocalConverter(UserResource.class, "roles", (Converter)new AliasingListConverter(String.class, "role"));
        xstream.registerLocalConverter(UserListResourceResponse.class, "data", (Converter)new AliasingListConverter(UserResource.class, "users-list-item"));
        xstream.registerLocalConverter(RoleListResourceResponse.class, "data", (Converter)new AliasingListConverter(RoleResource.class, "roles-list-item"));
        xstream.registerLocalConverter(RoleResource.class, "roles", (Converter)new AliasingListConverter(String.class, "role"));
        xstream.registerLocalConverter(RoleResource.class, "privileges", (Converter)new AliasingListConverter(String.class, "privilege"));
        xstream.registerLocalConverter(PrivilegeListResourceResponse.class, "data", (Converter)new AliasingListConverter(PrivilegeStatusResource.class, "privilege-item"));
        xstream.registerLocalConverter(PrivilegeResource.class, "method", (Converter)new AliasingListConverter(String.class, "method"));
        xstream.registerLocalConverter(PrivilegeStatusResource.class, "properties", (Converter)new AliasingListConverter(PrivilegeProperty.class, "privilege-property"));
        xstream.registerLocalConverter(PrivilegeTypeResourceResponse.class, "data", (Converter)new AliasingListConverter(PrivilegeTypeResource.class, "privilege-type"));
        xstream.registerLocalConverter(PrivilegeTypeResource.class, "properties", (Converter)new AliasingListConverter(PrivilegeTypePropertyResource.class, "privilege-type-property"));
        xstream.registerLocalConverter(UserToRoleResource.class, "roles", (Converter)new AliasingListConverter(String.class, "role"));
        xstream.registerLocalConverter(PlexusUserResource.class, "roles", (Converter)new AliasingListConverter(PlexusRoleResource.class, "plexus-role"));
        xstream.registerLocalConverter(PlexusUserListResourceResponse.class, "data", (Converter)new AliasingListConverter(PlexusUserResource.class, "plexus-user"));
        xstream.registerLocalConverter(ExternalRoleMappingListResourceResponse.class, "data", (Converter)new AliasingListConverter(ExternalRoleMappingResource.class, "mapping"));
        xstream.registerLocalConverter(ExternalRoleMappingResource.class, "mappedRoles", (Converter)new AliasingListConverter(PlexusRoleResource.class, "plexus-role"));
        xstream.registerLocalConverter(PlexusRoleListResourceResponse.class, "data", (Converter)new AliasingListConverter(PlexusRoleResource.class, "plexus-role"));
        xstream.registerLocalConverter(org.sonatype.security.rest.model.PlexusComponentListResourceResponse.class, "data", (Converter)new AliasingListConverter(org.sonatype.security.rest.model.PlexusComponentListResource.class, "component"));
        Class[] routingTypes = new Class[]{RoutingDiscoveryStatusMessage.class, RoutingStatusMessage.class, RoutingStatusMessageWrapper.class, RoutingConfigMessage.class, RoutingConfigMessageWrapper.class};
        xstream.allowTypes(routingTypes);
        xstream.processAnnotations(routingTypes);
        return xstream;
    }
}

