/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class PlexusIoFileResource
extends AbstractPlexusIoResourceWithAttributes
implements PlexusIoResourceWithAttributes {
    private File file;

    public PlexusIoFileResource() {
    }

    public PlexusIoFileResource(File file) {
        this(file, file.getPath().replace('\\', '/'));
    }

    public PlexusIoFileResource(File file, PlexusIoResourceAttributes attrs) {
        this(file, file.getPath().replace('\\', '/'), attrs);
    }

    public PlexusIoFileResource(File file, String name) {
        this.setFile(file);
        this.setName(name);
    }

    public PlexusIoFileResource(File file, String name, PlexusIoResourceAttributes attrs) {
        this.setName(name);
        this.setAttributes(attrs);
        this.setFile(file);
    }

    public void setFile(File file) {
        this.file = file;
        this.setLastModified(file.lastModified());
        this.setSize(file.length());
        this.setFile(file.isFile());
        this.setDirectory(file.isDirectory());
        this.setExisting(file.exists());
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getContents() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    public long getLastModified() {
        return this.getFile().lastModified();
    }

    public long getSize() {
        return this.getFile().length();
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean isExisting() {
        return this.getFile().exists();
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    public void setDirectory(boolean isDirectory) {
    }

    public void setExisting(boolean isExisting) {
    }

    public void setFile(boolean isFile) {
    }

    public void setLastModified(long lastModified) {
        this.file.setLastModified(lastModified);
    }

    public void setSize(long size) {
    }
}

