/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockSupport {
    protected final List<IMocksControl> controls = new ArrayList<IMocksControl>(5);

    public <T> T createStrictMock(Class<T> toMock) {
        return this.createStrictControl().createMock(toMock);
    }

    public <T> T createStrictMock(String name, Class<T> toMock) {
        return this.createStrictControl().createMock(name, toMock);
    }

    public <T> T createMock(Class<T> toMock) {
        return this.createControl().createMock(toMock);
    }

    public <T> T createMock(String name, Class<T> toMock) {
        return this.createControl().createMock(name, toMock);
    }

    public <T> T createNiceMock(Class<T> toMock) {
        return this.createNiceControl().createMock(toMock);
    }

    public <T> T createNiceMock(String name, Class<T> toMock) {
        return this.createNiceControl().createMock(name, toMock);
    }

    public IMocksControl createStrictControl() {
        IMocksControl ctrl = EasyMock.createStrictControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public IMocksControl createControl() {
        IMocksControl ctrl = EasyMock.createControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public IMocksControl createNiceControl() {
        IMocksControl ctrl = EasyMock.createNiceControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public void replayAll() {
        for (IMocksControl c : this.controls) {
            c.replay();
        }
    }

    public void resetAll() {
        for (IMocksControl c : this.controls) {
            c.reset();
        }
    }

    public void verifyAll() {
        for (IMocksControl c : this.controls) {
            c.verify();
        }
    }

    public void resetAllToNice() {
        for (IMocksControl c : this.controls) {
            c.resetToNice();
        }
    }

    public void resetAllToDefault() {
        for (IMocksControl c : this.controls) {
            c.resetToDefault();
        }
    }

    public void resetAllToStrict() {
        for (IMocksControl c : this.controls) {
            c.resetToStrict();
        }
    }
}

