/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.sdp.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.sdp.RTPInfo;
import io.pkts.sdp.SDP;
import io.pkts.sdp.impl.RTPInfoImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.sdp.Connection;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;

public class SDPWrapper
implements SDP {
    private final SessionDescription sdp;

    public SDPWrapper(SessionDescription sdp) {
        this.sdp = sdp;
    }

    @Override
    public Collection<RTPInfo> getRTPInfo() {
        ArrayList<RTPInfo> list = new ArrayList<RTPInfo>();
        try {
            Connection c = this.sdp.getConnection();
            Vector mds = this.sdp.getMediaDescriptions(false);
            if (mds != null) {
                for (MediaDescription md : mds) {
                    RTPInfo rtpInfo = this.processMediaDescription(c, md);
                    if (rtpInfo == null) continue;
                    list.add(rtpInfo);
                }
            }
        }
        catch (SdpException e) {
            throw new RuntimeException("TODO: throw real exception", e);
        }
        return list;
    }

    private RTPInfo processMediaDescription(Connection connection, MediaDescription md) throws SdpParseException {
        Media m = md.getMedia();
        if ("RTP/AVP".equalsIgnoreCase(m.getProtocol())) {
            Connection c = md.getConnection() != null ? null : connection;
            return new RTPInfoImpl(connection, md);
        }
        return null;
    }

    @Override
    public Buffer toBuffer() {
        return Buffers.wrap((String)this.sdp.toString());
    }

    @Override
    public String toString() {
        return this.sdp.toString();
    }
}

