/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.codehaus.plexus.util.Os;

public final class FilteringUtils {
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private static final int FILE_COPY_BUFFER_SIZE = 0x1E00000;
    private static final String WINDOWS_PATH_PATTERN = "^(.*)[a-zA-Z]:\\\\(.*)";
    private static final Pattern PATTERN = Pattern.compile("^(.*)[a-zA-Z]:\\\\(.*)");

    private FilteringUtils() {
    }

    public static String escapeWindowsPath(String val) {
        if (!FilteringUtils.isEmpty(val) && PATTERN.matcher(val).matches()) {
            StringBuilder buf = new StringBuilder(val.length());
            int start = 0;
            int end = 0;
            while ((end = val.indexOf(92, start)) != -1) {
                buf.append(val, start, end).append("\\\\");
                start = end + 1;
                if (val.indexOf(92, end + 1) != end + 1) continue;
                ++start;
            }
            buf.append(val.substring(start));
            return buf.toString();
        }
        return val;
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = filename;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator) || Os.isFamily((String)"windows") && filenm.indexOf(":") > 0) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuilder sb = new StringBuilder();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i = start; i < chars.length; ++i) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (doubleSeparator) continue;
            sb.append(chars[i]);
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static String getRelativeFilePath(String oldPath, String newPath) {
        if (FilteringUtils.isEmpty(oldPath) || FilteringUtils.isEmpty(newPath)) {
            return "";
        }
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String resultPath = FilteringUtils.buildRelativePath(toPath, fromPath, File.separatorChar);
        if (newPath.endsWith(File.separator) && !resultPath.endsWith(File.separator)) {
            return resultPath + File.separator;
        }
        return resultPath;
    }

    private static String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuilder relativePath = new StringBuilder();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        return relativePath.toString();
    }

    static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static void copyFile(File from, File to, String encoding, FilterWrapper[] wrappers, boolean overwrite) throws IOException {
        block31: {
            if (wrappers == null || wrappers.length == 0) {
                if (overwrite || to.lastModified() < from.lastModified()) {
                    Files.copy(from.toPath(), to.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Charset charset = FilteringUtils.charset(encoding);
                try (BufferedReader fileReader = Files.newBufferedReader(from.toPath(), charset);){
                    Reader wrapped = fileReader;
                    for (FilterWrapper wrapper : wrappers) {
                        wrapped = wrapper.getReader(wrapped);
                    }
                    if (overwrite || !to.exists()) {
                        try (BufferedWriter fileWriter = Files.newBufferedWriter(to.toPath(), charset, new OpenOption[0]);){
                            IOUtils.copy((Reader)wrapped, (Writer)fileWriter);
                            break block31;
                        }
                    }
                    CharsetEncoder encoder = charset.newEncoder();
                    int charBufferSize = (int)Math.floor(3.145728E7f / (2.0f + 2.0f * encoder.maxBytesPerChar()));
                    int byteBufferSize = (int)Math.ceil((float)charBufferSize * encoder.maxBytesPerChar());
                    CharBuffer newChars = CharBuffer.allocate(charBufferSize);
                    ByteBuffer newBytes = ByteBuffer.allocate(byteBufferSize);
                    ByteBuffer existingBytes = ByteBuffer.allocate(byteBufferSize);
                    boolean writing = false;
                    try (RandomAccessFile existing = new RandomAccessFile(to, "rw");){
                        int n;
                        while (-1 != (n = wrapped.read(newChars))) {
                            ((Buffer)newChars).flip();
                            CoderResult coderResult = encoder.encode(newChars, newBytes, n != 0);
                            if (coderResult.isError()) {
                                coderResult.throwException();
                            }
                            ((Buffer)newBytes).flip();
                            if (!writing) {
                                int existingRead = existing.read(existingBytes.array(), 0, newBytes.remaining());
                                if (existingRead == -1) {
                                    writing = true;
                                } else {
                                    ((Buffer)existingBytes).position(existingRead);
                                    ((Buffer)existingBytes).flip();
                                    if (newBytes.compareTo(existingBytes) != 0) {
                                        writing = true;
                                        if (existingRead > 0) {
                                            existing.seek(existing.getFilePointer() - (long)existingRead);
                                        }
                                    }
                                }
                            }
                            if (writing) {
                                existing.write(newBytes.array(), 0, newBytes.remaining());
                            }
                            ((Buffer)newChars).clear();
                            ((Buffer)newBytes).clear();
                            ((Buffer)existingBytes).clear();
                        }
                        if (existing.length() > existing.getFilePointer()) {
                            existing.setLength(existing.getFilePointer());
                        }
                    }
                }
            }
        }
        FilteringUtils.copyFilePermissions(from, to);
    }

    private static void copyFilePermissions(File source, File destination) throws IOException {
        try {
            Files.setPosixFilePermissions(destination.toPath(), Files.getPosixFilePermissions(source.toPath(), new LinkOption[0]));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (UnsupportedOperationException e) {
            destination.setExecutable(source.canExecute());
            destination.setReadable(source.canRead());
            destination.setWritable(source.canWrite());
        }
    }

    private static Charset charset(String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            return Charset.defaultCharset();
        }
        return Charset.forName(encoding);
    }
}

