/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.client.core.exception.NexusClientResponseException;

public class NexusClientErrorResponseException
extends NexusClientResponseException {
    private final List<ErrorMessage> errors;

    public NexusClientErrorResponseException(String reasonPhrase, String responseBody, List<ErrorMessage> errorMessages) {
        super(NexusClientErrorResponseException.message(errorMessages), Response.Status.BAD_REQUEST.getStatusCode(), reasonPhrase, responseBody);
        this.errors = Collections.unmodifiableList(errorMessages == null ? Collections.emptyList() : errorMessages);
    }

    private static String message(Collection<ErrorMessage> errors) {
        if (errors != null && !errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ErrorMessage error : errors) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                if (!"*".equals(error.getId())) {
                    sb.append("[").append(error.getId()).append("] ");
                }
                sb.append(error.getMessage());
            }
            if (errors.size() > 1) {
                sb.insert(0, "\n");
            }
            return sb.toString();
        }
        return "Unknown";
    }

    public List<ErrorMessage> errors() {
        return this.errors;
    }

    public static class ErrorMessage {
        private final String id;
        private final String message;

        public ErrorMessage(String id, String message) {
            this.id = id;
            this.message = message;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

