/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.ice.Component;
import org.ice4j.ice.ComponentSocket;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.NetworkUtils;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.HarvestStatistics;
import org.ice4j.socket.DelegatingServerSocket;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpServerSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;

public class HostCandidateHarvester {
    private static final Logger logger = Logger.getLogger(HostCandidateHarvester.class.getName());
    private HarvestStatistics harvestStatistics = new HarvestStatistics();

    public static List<InetAddress> getAllAllowedAddresses() {
        LinkedList<InetAddress> addresses = new LinkedList<InetAddress>();
        for (NetworkInterface iface : HostCandidateHarvester.getAllowedInterfaces()) {
            Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
            while (ifaceAddresses.hasMoreElements()) {
                InetAddress address = ifaceAddresses.nextElement();
                if (!HostCandidateHarvester.isAddressAllowed(address)) continue;
                addresses.add(address);
            }
        }
        return addresses;
    }

    public void harvest(Component component, int preferredPort, int minPort, int maxPort, Transport transport) throws IllegalArgumentException, IOException {
        this.harvestStatistics.startHarvestTiming();
        if (transport != Transport.UDP && transport != Transport.TCP) {
            throw new IllegalArgumentException("Transport protocol not supported: " + transport);
        }
        boolean boundAtLeastOneSocket = false;
        boolean foundAtLeastOneUsableInterface = false;
        boolean foundAtLeastOneUsableAddress = false;
        for (NetworkInterface iface : HostCandidateHarvester.getAllowedInterfaces()) {
            foundAtLeastOneUsableInterface = true;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                IceSocketWrapper sock;
                block7: {
                    InetAddress addr = addresses.nextElement();
                    if (!HostCandidateHarvester.isAddressAllowed(addr)) continue;
                    foundAtLeastOneUsableAddress = true;
                    sock = null;
                    try {
                        if (transport == Transport.UDP) {
                            sock = this.createDatagramSocket(addr, preferredPort, minPort, maxPort);
                            boundAtLeastOneSocket = true;
                            break block7;
                        }
                        if (transport != Transport.TCP) break block7;
                        if (addr instanceof Inet6Address) continue;
                        sock = this.createServerSocket(addr, preferredPort, minPort, maxPort, component);
                        boundAtLeastOneSocket = true;
                    }
                    catch (IOException exc) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.warning("Failed to create a socket for:\naddr:" + addr + "\npreferredPort:" + preferredPort + "\nminPort:" + minPort + "\nmaxPort:" + maxPort + "\nprotocol:" + transport + "\nContinuing with next address");
                        continue;
                    }
                }
                HostCandidate candidate = new HostCandidate(sock, component, transport);
                candidate.setVirtual(iface.isVirtual());
                component.addLocalCandidate(candidate);
                if (transport == Transport.TCP) continue;
                this.createAndRegisterStunSocket(candidate);
                ComponentSocket componentSocket = component.getComponentSocket();
                if (componentSocket == null) continue;
                componentSocket.add(sock);
            }
        }
        if (!boundAtLeastOneSocket) {
            throw new IOException("Failed to bind even a single host candidate for component:" + component + " preferredPort=" + preferredPort + " minPort=" + minPort + " maxPort=" + maxPort + " foundAtLeastOneUsableInterface=" + foundAtLeastOneUsableInterface + " foundAtLeastOneUsableAddress=" + foundAtLeastOneUsableAddress);
        }
        this.harvestStatistics.stopHarvestTiming(component.getLocalCandidateCount());
    }

    public static boolean isInterfaceAllowed(NetworkInterface iface) {
        String ifName;
        Objects.requireNonNull(iface);
        try {
            if (iface.isLoopback() || !iface.isUp()) {
                return false;
            }
        }
        catch (SocketException se) {
            logger.warning("Failed to check state of interface: " + se);
            return false;
        }
        String string = ifName = System.getProperty("os.name") == null || System.getProperty("os.name").startsWith("Windows") ? iface.getDisplayName() : iface.getName();
        if (!HarvestConfig.config.getAllowedInterfaces().isEmpty()) {
            return HarvestConfig.config.getAllowedInterfaces().contains(ifName);
        }
        return !HarvestConfig.config.getBlockedInterfaces().contains(ifName);
    }

    public static List<NetworkInterface> getAllowedInterfaces() {
        try {
            return NetworkInterface.networkInterfaces().filter(HostCandidateHarvester::isInterfaceAllowed).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            logger.warning("Failed to get network interfaces: " + ioe.getMessage());
            return Collections.emptyList();
        }
    }

    static boolean isAddressAllowed(InetAddress address) {
        if (address.isLoopbackAddress()) {
            return false;
        }
        if (!HarvestConfig.config.useLinkLocalAddresses() && address.isLinkLocalAddress()) {
            return false;
        }
        if (!HarvestConfig.config.useIpv6() && address instanceof Inet6Address) {
            return false;
        }
        if (!HarvestConfig.config.getAllowedAddresses().isEmpty()) {
            return HarvestConfig.config.getAllowedAddresses().contains(address);
        }
        return !HarvestConfig.config.getBlockedAddresses().contains(address);
    }

    private IceSocketWrapper createServerSocket(InetAddress laddr, int preferredPort, int minPort, int maxPort, Component component) throws IllegalArgumentException, IOException, BindException {
        boolean ephemeral = HostCandidateHarvester.checkPorts(preferredPort, minPort, maxPort);
        if (ephemeral) {
            ServerSocket socket = new ServerSocket();
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress(laddr, 0));
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Bound using an ephemeral port to " + socket.getLocalSocketAddress());
            }
            return new IceTcpServerSocketWrapper(new DelegatingServerSocket(socket), component);
        }
        int bindRetries = StackProperties.getInt("org.ice4j.BIND_RETRIES", 50);
        int port = preferredPort;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                ServerSocket sock = new ServerSocket();
                sock.setReuseAddress(true);
                sock.bind(new InetSocketAddress(laddr, port));
                IceTcpServerSocketWrapper socket = new IceTcpServerSocketWrapper(new DelegatingServerSocket(sock), component);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "just bound to: " + sock.getLocalSocketAddress());
                }
                return socket;
            }
            catch (SocketException se) {
                logger.log(Level.INFO, "Retrying a bind because of a failure to bind to address " + laddr + " and port " + port + " (" + se.getMessage() + ")");
                logger.log(Level.INFO, "", se);
                if (++port <= maxPort) continue;
                port = minPort;
                continue;
            }
        }
        throw new BindException("Could not bind to any port between " + minPort + " and " + (port - 1));
    }

    private IceSocketWrapper createDatagramSocket(InetAddress laddr, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException, BindException {
        boolean ephemeral = HostCandidateHarvester.checkPorts(preferredPort, minPort, maxPort);
        if (ephemeral) {
            MultiplexingDatagramSocket socket = new MultiplexingDatagramSocket(0, laddr);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Bound using ephemeral port to " + ((DatagramSocket)socket).getLocalSocketAddress());
            }
            return new IceUdpSocketWrapper(socket);
        }
        int bindRetries = StackProperties.getInt("org.ice4j.BIND_RETRIES", 50);
        int port = preferredPort;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                IceUdpSocketWrapper sock = new IceUdpSocketWrapper(new MultiplexingDatagramSocket(port, laddr));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "just bound to: " + ((IceSocketWrapper)sock).getLocalSocketAddress());
                }
                return sock;
            }
            catch (SocketException se) {
                logger.log(Level.INFO, "Retrying a bind because of a failure to bind to address " + laddr + " and port " + port + " (" + se.getMessage() + ")");
                logger.log(Level.FINEST, "", se);
                if (++port <= maxPort) continue;
                port = minPort;
                continue;
            }
        }
        throw new BindException("Could not bind to any port between " + minPort + " and " + (port - 1));
    }

    private void createAndRegisterStunSocket(HostCandidate candidate) {
        IceSocketWrapper stunSocket = candidate.getStunSocket(null);
        candidate.getStunStack().addSocket(stunSocket);
    }

    private static boolean checkPorts(int preferredPort, int minPort, int maxPort) throws IllegalArgumentException {
        if (preferredPort == 0 && minPort == 0 && maxPort == 0) {
            return true;
        }
        if (!NetworkUtils.isValidPortNumber(minPort) || !NetworkUtils.isValidPortNumber(maxPort)) {
            throw new IllegalArgumentException("minPort (" + minPort + ") and maxPort (" + maxPort + ") should be integers between 1024 and 65535.");
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException("minPort (" + minPort + ") should be less than or equal to maxPort (" + maxPort + ")");
        }
        if (minPort > preferredPort || preferredPort > maxPort) {
            throw new IllegalArgumentException("preferredPort (" + preferredPort + ") must be between minPort (" + minPort + ") and maxPort (" + maxPort + ")");
        }
        return false;
    }

    public HarvestStatistics getHarvestStatistics() {
        return this.harvestStatistics;
    }
}

