/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.sonatype.nexus.maven.staging.deploy.AbstractDeployMojo;
import org.sonatype.nexus.maven.staging.deploy.DeployableArtifact;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployPerModuleRequest;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.FinalizeDeployRequest;
import org.sonatype.nexus.maven.staging.remote.Parameters;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, requiresOnline=true, threadSafe=true)
public class DeployMojo
extends AbstractDeployMojo {
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project.artifact}", readonly=true, required=true)
    private Artifact artifact;
    @Parameter(defaultValue="${project.packaging}", readonly=true, required=true)
    private String packaging;
    @Parameter(defaultValue="${project.file}", readonly=true, required=true)
    private File pomFile;
    @Parameter(defaultValue="${project.attachedArtifacts}", readonly=true, required=true)
    private List<Artifact> attachedArtifacts;
    @Parameter(property="updateReleaseInfo")
    private boolean updateReleaseInfo;
    @Parameter(property="skipNexusStagingDeployMojo")
    private boolean skipNexusStagingDeployMojo;
    @Parameter(property="skipLocalStaging")
    private boolean skipLocalStaging;
    @Parameter(property="skipRemoteStaging")
    private boolean skipRemoteStaging;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployPerModuleRequest request;
        DeployStrategy deployStrategy;
        if (this.skipNexusStagingDeployMojo) {
            this.getLog().info((CharSequence)"Skipping Nexus Staging Deploy Mojo at user's demand.");
            return;
        }
        this.failIfOffline();
        ArrayList<DeployableArtifact> deployables = new ArrayList<DeployableArtifact>(2);
        boolean isPomArtifact = "pom".equals(this.packaging);
        if (!isPomArtifact) {
            this.artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(this.artifact, this.pomFile));
        }
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        Parameters parameters = this.buildParameters();
        try {
            if (isPomArtifact) {
                deployables.add(new DeployableArtifact(this.pomFile, this.artifact));
            } else {
                File file = this.artifact.getFile();
                if (file != null && file.isFile()) {
                    deployables.add(new DeployableArtifact(file, this.artifact));
                } else if (!this.attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to deploy, deploying attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getBaseVersion());
                    pomArtifact.setFile(this.pomFile);
                    if (this.updateReleaseInfo) {
                        pomArtifact.setRelease(true);
                    }
                    deployables.add(new DeployableArtifact(this.pomFile, pomArtifact));
                    this.artifact.setResolvedVersion(pomArtifact.getVersion());
                } else {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
            }
            for (Artifact attached : this.attachedArtifacts) {
                deployables.add(new DeployableArtifact(attached.getFile(), attached));
            }
            deployStrategy = this.skipLocalStaging ? this.getDeployStrategy("direct") : (this.isSkipStaging() || this.artifact.isSnapshot() ? this.getDeployStrategy("deferred") : this.getDeployStrategy("staging"));
            request = new DeployPerModuleRequest(this.getMavenSession(), parameters, deployables);
            deployStrategy.deployPerModule(request);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (this.isThisLastProjectWithThisMojoInExecution()) {
            if (this.skipRemoteStaging) {
                this.getLog().info((CharSequence)("Artifacts locally gathered under directory " + this.getWorkDirectoryRoot().getAbsolutePath() + ", skipping remote staging at user's demand."));
                return;
            }
            try {
                FinalizeDeployRequest finalizeRequest = new FinalizeDeployRequest(this.getMavenSession(), parameters);
                finalizeRequest.setRemoteNexus(request.getRemoteNexus());
                deployStrategy.finalizeDeploy(finalizeRequest);
            }
            catch (ArtifactDeploymentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

