/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.common.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sonatype.sisu.siesta.common.validation.ValidationErrorXO;

public class ValidationErrorsException
extends RuntimeException {
    private final List<ValidationErrorXO> errors = Lists.newArrayList();

    public ValidationErrorsException() {
    }

    public ValidationErrorsException(String message) {
        this.errors.add(new ValidationErrorXO(message));
    }

    public ValidationErrorsException(String id, String message) {
        this.errors.add(new ValidationErrorXO(id, message));
    }

    public ValidationErrorsException withError(String message) {
        this.errors.add(new ValidationErrorXO(message));
        return this;
    }

    public ValidationErrorsException withError(String id, String message) {
        this.errors.add(new ValidationErrorXO(id, message));
        return this;
    }

    public ValidationErrorsException withErrors(ValidationErrorXO ... validationErrors) {
        this.errors.addAll(Arrays.asList((Object[])Preconditions.checkNotNull((Object)validationErrors)));
        return this;
    }

    public ValidationErrorsException withErrors(List<ValidationErrorXO> validationErrors) {
        this.errors.addAll((Collection)Preconditions.checkNotNull(validationErrors));
        return this;
    }

    public List<ValidationErrorXO> getValidationErrors() {
        return this.errors;
    }

    public boolean hasValidationErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (ValidationErrorXO error : this.errors) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(error.getMessage());
        }
        return sb.length() == 0 ? "(No validation errors)" : sb.toString();
    }
}

