/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugins.assembly.io.MessageHolder;
import org.apache.maven.plugins.assembly.io.MessageLevels;
import org.apache.maven.plugins.assembly.io.MessageSink;

class DefaultMessageHolder
implements MessageHolder {
    private List<Message> messages = new ArrayList<Message>();
    private Message currentMessage;
    private int defaultMessageLevel = 1;
    private boolean[] messageLevelStates = MessageLevels.getLevelStates(1);
    private MessageSink onDemandSink;

    DefaultMessageHolder() {
    }

    @Override
    public MessageHolder addMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(this.defaultMessageLevel, messagePart, error);
    }

    MessageHolder addMessage(int level, CharSequence messagePart, Throwable error) {
        this.newMessage(level);
        this.append(messagePart.toString());
        this.append(error);
        return this;
    }

    @Override
    public MessageHolder addMessage(CharSequence messagePart) {
        return this.addMessage(this.defaultMessageLevel, messagePart);
    }

    protected MessageHolder addMessage(int level, CharSequence messagePart) {
        this.newMessage(level);
        this.append(messagePart.toString());
        return this;
    }

    @Override
    public MessageHolder addMessage(Throwable error) {
        return this.addMessage(this.defaultMessageLevel, error);
    }

    protected MessageHolder addMessage(int level, Throwable error) {
        this.newMessage(level);
        this.append(error);
        return this;
    }

    @Override
    public MessageHolder append(CharSequence messagePart) {
        if (this.currentMessage == null) {
            this.newMessage();
        }
        this.currentMessage.append(messagePart.toString());
        return this;
    }

    @Override
    public MessageHolder append(Throwable error) {
        if (this.currentMessage == null) {
            this.newMessage();
        }
        this.currentMessage.setError(error);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public MessageHolder newMessage() {
        this.newMessage(this.defaultMessageLevel);
        return this;
    }

    protected void newMessage(int messageLevel) {
        if (this.onDemandSink != null && this.currentMessage != null) {
            this.renderTo(this.currentMessage, this.onDemandSink);
        }
        this.currentMessage = new Message(messageLevel, this.onDemandSink);
        this.messages.add(this.currentMessage);
    }

    @Override
    public String render() {
        StringBuilder buffer = new StringBuilder();
        int counter = 1;
        Iterator<Message> it = this.messages.iterator();
        while (it.hasNext()) {
            Message message = it.next();
            int ml = message.getMessageLevel();
            if (ml >= this.messageLevelStates.length || ml < 0) {
                ml = 0;
            }
            if (!this.messageLevelStates[ml]) continue;
            CharSequence content = message.render();
            String label = MessageLevels.getLevelLabel(message.getMessageLevel());
            if (content.length() <= label.length() + 3) continue;
            buffer.append('[').append(counter++).append("] ");
            buffer.append(content);
            if (!it.hasNext()) continue;
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public MessageHolder addDebugMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(0, messagePart, error);
    }

    @Override
    public MessageHolder addDebugMessage(CharSequence messagePart) {
        return this.addMessage(0, messagePart);
    }

    @Override
    public MessageHolder addDebugMessage(Throwable error) {
        return this.addMessage(0, error);
    }

    @Override
    public MessageHolder addErrorMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(3, messagePart, error);
    }

    @Override
    public MessageHolder addErrorMessage(CharSequence messagePart) {
        return this.addMessage(3, messagePart);
    }

    @Override
    public MessageHolder addErrorMessage(Throwable error) {
        return this.addMessage(3, error);
    }

    @Override
    public MessageHolder addInfoMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(1, messagePart, error);
    }

    @Override
    public MessageHolder addInfoMessage(CharSequence messagePart) {
        return this.addMessage(1, messagePart);
    }

    @Override
    public MessageHolder addInfoMessage(Throwable error) {
        return this.addMessage(1, error);
    }

    @Override
    public MessageHolder addSevereMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(4, messagePart, error);
    }

    @Override
    public MessageHolder addSevereMessage(CharSequence messagePart) {
        return this.addMessage(4, messagePart);
    }

    @Override
    public MessageHolder addSevereMessage(Throwable error) {
        return this.addMessage(4, error);
    }

    @Override
    public MessageHolder addWarningMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(2, messagePart, error);
    }

    @Override
    public MessageHolder addWarningMessage(CharSequence messagePart) {
        return this.addMessage(2, messagePart);
    }

    @Override
    public MessageHolder addWarningMessage(Throwable error) {
        return this.addMessage(2, error);
    }

    @Override
    public int countDebugMessages() {
        return this.countMessagesOfType(0);
    }

    @Override
    public int countErrorMessages() {
        return this.countMessagesOfType(3);
    }

    @Override
    public int countInfoMessages() {
        return this.countMessagesOfType(1);
    }

    @Override
    public int countMessages() {
        return this.size();
    }

    @Override
    public int countSevereMessages() {
        return this.countMessagesOfType(4);
    }

    @Override
    public int countWarningMessages() {
        return this.countMessagesOfType(2);
    }

    private int countMessagesOfType(int messageLevel) {
        int count = 0;
        for (Message message : this.messages) {
            if (messageLevel != message.getMessageLevel()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.messageLevelStates[0];
    }

    @Override
    public boolean isErrorEnabled() {
        return this.messageLevelStates[3];
    }

    @Override
    public boolean isInfoEnabled() {
        return this.messageLevelStates[1];
    }

    @Override
    public boolean isSevereEnabled() {
        return this.messageLevelStates[4];
    }

    @Override
    public boolean isWarningEnabled() {
        return this.messageLevelStates[2];
    }

    @Override
    public MessageHolder newDebugMessage() {
        if (this.isDebugEnabled()) {
            this.newMessage(0);
        }
        return this;
    }

    @Override
    public MessageHolder newErrorMessage() {
        if (this.isErrorEnabled()) {
            this.newMessage(3);
        }
        return this;
    }

    @Override
    public MessageHolder newInfoMessage() {
        if (this.isInfoEnabled()) {
            this.newMessage(1);
        }
        return this;
    }

    @Override
    public MessageHolder newSevereMessage() {
        if (this.isSevereEnabled()) {
            this.newMessage(4);
        }
        return this;
    }

    @Override
    public MessageHolder newWarningMessage() {
        if (this.isWarningEnabled()) {
            this.newMessage(2);
        }
        return this;
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this.messageLevelStates[0] = enabled;
    }

    @Override
    public void setErrorEnabled(boolean enabled) {
        this.messageLevelStates[3] = enabled;
    }

    @Override
    public void setInfoEnabled(boolean enabled) {
        this.messageLevelStates[1] = enabled;
    }

    @Override
    public void setSevereEnabled(boolean enabled) {
        this.messageLevelStates[4] = enabled;
    }

    @Override
    public void setWarningEnabled(boolean enabled) {
        this.messageLevelStates[2] = enabled;
    }

    @Override
    public void flush() {
        if (this.onDemandSink != null && this.currentMessage != null) {
            this.renderTo(this.currentMessage, this.onDemandSink);
            this.currentMessage = null;
        }
    }

    @Override
    public void render(MessageSink sink) {
        for (Message message : this.messages) {
            this.renderTo(message, sink);
        }
    }

    protected void renderTo(Message message, MessageSink sink) {
        switch (message.getMessageLevel()) {
            case 4: {
                sink.severe(message.render().toString());
                break;
            }
            case 3: {
                sink.error(message.render().toString());
                break;
            }
            case 2: {
                sink.warning(message.render().toString());
                break;
            }
            case 1: {
                sink.info(message.render().toString());
                break;
            }
            default: {
                sink.debug(message.render().toString());
            }
        }
    }

    private static final class Message {
        private StringBuffer message = new StringBuffer();
        private Throwable error;
        private final int messageLevel;
        private final MessageSink onDemandSink;

        Message(int messageLevel, MessageSink onDemandSink) {
            this.messageLevel = messageLevel;
            this.onDemandSink = onDemandSink;
        }

        public Message setError(Throwable pError) {
            this.error = pError;
            return this;
        }

        public Message append(CharSequence pMessage) {
            this.message.append(pMessage.toString());
            return this;
        }

        public int getMessageLevel() {
            return this.messageLevel;
        }

        public CharSequence render() {
            StringBuffer buffer = new StringBuffer();
            if (this.onDemandSink == null) {
                buffer.append('[').append(MessageLevels.getLevelLabel(this.messageLevel)).append("] ");
            }
            if (this.message != null && this.message.length() > 0) {
                buffer.append(this.message);
                if (this.error != null) {
                    buffer.append('\n');
                }
            }
            if (this.error != null) {
                buffer.append("Error:\n");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.error.printStackTrace(pw);
                buffer.append(sw);
            }
            return buffer;
        }
    }
}

