/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.untag;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmUntagParameters;
import org.apache.maven.scm.command.untag.AbstractUntagCommand;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitUntagCommand
extends AbstractUntagCommand
implements GitCommand {
    public ScmResult executeUntagCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmUntagParameters scmUntagParameters) throws ScmException {
        Commandline clPush;
        String tag = scmUntagParameters.getTag();
        if (tag == null || StringUtils.isEmpty((String)tag.trim())) {
            throw new ScmException("tag name must be specified");
        }
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline clTag = GitUntagCommand.createCommandLine(repository, fileSet.getBasedir(), tag);
        int exitCode = GitCommandLineUtils.execute(clTag, stdout, stderr, this.getLogger());
        if (exitCode != 0) {
            return new UntagScmResult(clTag.toString(), "The git-tag command failed.", stderr.getOutput(), false);
        }
        if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(clPush = GitUntagCommand.createPushCommandLine(repository, fileSet, tag), stdout, stderr, this.getLogger())) != 0) {
            return new UntagScmResult(clPush.toString(), "The git-push command failed.", stderr.getOutput(), false);
        }
        return new UntagScmResult(clTag.toString());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, String tag) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "tag");
        cl.createArg().setValue("-d");
        cl.createArg().setValue(tag);
        return cl;
    }

    public static Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, String tag) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push");
        cl.createArg().setValue("--delete");
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue("refs/tags/" + tag);
        return cl;
    }
}

