/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.TokenSequence;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class JavaParserUtil {
    public static final TokenSet WS_COMMENTS = TokenSet.orSet(ElementType.JAVA_COMMENT_BIT_SET, TokenSet.WHITE_SPACE);
    private static final Key<LanguageLevel> LANG_LEVEL_KEY = Key.create("JavaParserUtil.LanguageLevel");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS_IN_STATEMENTS = Key.create("JavaParserUtil.ParserExtender");
    private static final TokenSet PRECEDING_COMMENT_SET = TokenSet.orSet(TokenSet.create(JavaElementType.MODULE), ElementType.FULL_MEMBER_BIT_SET);
    private static final TokenSet TRAILING_COMMENT_SET = TokenSet.orSet(TokenSet.create(JavaElementType.PACKAGE_STATEMENT), ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ElementType.FULL_MEMBER_BIT_SET, ElementType.JAVA_STATEMENT_BIT_SET);
    public static final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(false);
    public static final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(true);
    public static final WhitespacesAndCommentsBinder TRAILING_COMMENT_BINDER = new TrailingWhitespacesAndCommentsBinder();

    @NotNull
    public static TokenList obtainTokens(@NotNull PsiFile file2) {
        if (file2 == null) {
            JavaParserUtil.$$$reportNull$$$0(0);
        }
        TokenList tokenList = (TokenList)CachedValuesManager.getCachedValue(file2, () -> CachedValueProvider.Result.create(TokenSequence.performLexing(file2.getViewProvider().getContents(), JavaParserDefinition.createLexer(PsiUtil.getLanguageLevel(file2))), file2));
        if (tokenList == null) {
            JavaParserUtil.$$$reportNull$$$0(1);
        }
        return tokenList;
    }

    private JavaParserUtil() {
    }

    public static void setLanguageLevel(PsiBuilder builder, LanguageLevel level) {
        builder.putUserData(LANG_LEVEL_KEY, level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(PsiBuilder builder) {
        LanguageLevel level = builder.getUserData(LANG_LEVEL_KEY);
        assert (level != null) : builder;
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            JavaParserUtil.$$$reportNull$$$0(2);
        }
        return languageLevel;
    }

    public static boolean isParseStatementCodeBlocksDeep(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS));
    }

    @NotNull
    public static PsiBuilder createBuilder(ASTNode chameleon) {
        CharSequence text;
        PsiElement psi = chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        CharSequence indexedText = psi.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (TreeUtil.isCollapsedChameleon(chameleon)) {
            text = chameleon.getChars();
        } else {
            text = indexedText;
            if (text == null) {
                text = chameleon.getChars();
            }
        }
        LanguageLevel level = PsiUtil.getLanguageLevel(psi);
        Lexer lexer = psi instanceof PsiFile && indexedText != null ? JavaParserUtil.obtainTokens((PsiFile)psi).asLexer() : JavaParserDefinition.createLexer(level);
        Language language2 = psi.getLanguage();
        if (!language2.isKindOf(JavaLanguage.INSTANCE)) {
            language2 = JavaLanguage.INSTANCE;
        }
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, language2, text);
        JavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            JavaParserUtil.$$$reportNull$$$0(3);
        }
        return psiBuilder;
    }

    @NotNull
    public static PsiBuilder createBuilder(LighterLazyParseableNode chameleon) {
        PsiFile psi = chameleon.getContainingFile();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        LanguageLevel level = PsiUtil.getLanguageLevel(psi);
        Lexer lexer = JavaParserDefinition.createLexer(level);
        PsiBuilder builder = factory2.createBuilder(project, chameleon, lexer, chameleon.getTokenType().getLanguage(), chameleon.getText());
        JavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            JavaParserUtil.$$$reportNull$$$0(4);
        }
        return psiBuilder;
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper) {
        return JavaParserUtil.parseFragment(chameleon, wrapper, true, LanguageLevel.HIGHEST);
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, boolean eatAll, LanguageLevel level) {
        PsiElement psi;
        PsiElement psiElement = psi = chameleon.getTreeParent() != null ? chameleon.getTreeParent().getPsi() : chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        Lexer lexer = chameleon.getElementType() == JavaDocElementType.DOC_COMMENT ? JavaParserDefinition.createDocLexer(level) : JavaParserDefinition.createLexer(level);
        PsiBuilder builder = factory2.createBuilder(project, chameleon, lexer, chameleon.getElementType().getLanguage(), chameleon.getChars());
        JavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder.Marker root = builder.mark();
        wrapper.parse(builder);
        if (!builder.eof()) {
            if (!eatAll) {
                throw new AssertionError((Object)("Unexpected token: '" + builder.getTokenText() + "'"));
            }
            PsiBuilder.Marker extras = builder.mark();
            while (!builder.eof()) {
                builder.advanceLexer();
            }
            extras.error(JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        root.done(chameleon.getElementType());
        return builder.getTreeBuilt().getFirstChildNode();
    }

    public static void done(PsiBuilder.Marker marker, IElementType type2) {
        marker.done(type2);
        WhitespacesAndCommentsBinder left = PRECEDING_COMMENT_SET.contains(type2) ? PRECEDING_COMMENT_BINDER : null;
        WhitespacesAndCommentsBinder right = TRAILING_COMMENT_SET.contains(type2) ? TRAILING_COMMENT_BINDER : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    @Nullable
    public static IElementType exprType(@Nullable PsiBuilder.Marker marker) {
        return marker != null ? ((LighterASTNode)((Object)marker)).getTokenType() : null;
    }

    public static void error(PsiBuilder builder, @NotNull String message) {
        if (message == null) {
            JavaParserUtil.$$$reportNull$$$0(5);
        }
        builder.mark().error(message);
    }

    public static void error(PsiBuilder builder, @NotNull String message, @Nullable PsiBuilder.Marker before) {
        if (message == null) {
            JavaParserUtil.$$$reportNull$$$0(6);
        }
        if (before == null) {
            JavaParserUtil.error(builder, message);
        } else {
            before.precede().errorBefore(message, before);
        }
    }

    public static boolean expectOrError(PsiBuilder builder, IElementType expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect(builder, expected)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static void emptyElement(PsiBuilder builder, IElementType type2) {
        builder.mark().done(type2);
    }

    public static void emptyElement(PsiBuilder.Marker before, IElementType type2) {
        before.precede().doneBefore(type2, before);
    }

    public static void semicolon(PsiBuilder builder) {
        JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
    }

    public static PsiBuilder braceMatchingBuilder(PsiBuilder builder) {
        PsiBuilder.Marker pos = builder.mark();
        int braceCount = 1;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            if (braceCount == 0) break;
            builder.advanceLexer();
        }
        int stopAt = builder.getCurrentOffset();
        pos.rollbackTo();
        return JavaParserUtil.stoppingBuilder(builder, stopAt);
    }

    public static PsiBuilder stoppingBuilder(PsiBuilder builder, final int stopAt) {
        return new PsiBuilderAdapter(builder){

            @Override
            public IElementType getTokenType() {
                return this.getCurrentOffset() < stopAt ? super.getTokenType() : null;
            }

            @Override
            public boolean eof() {
                return this.getCurrentOffset() >= stopAt || super.eof();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/JavaParserUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/JavaParserUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainTokens";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrailingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private TrailingWhitespacesAndCommentsBinder() {
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.size() == 0) {
                return 0;
            }
            int result2 = 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (!StringUtil.containsLineBreak(getter2.get(idx))) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                result2 = idx + 1;
            }
            return result2;
        }
    }

    private static class PrecedingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAfterEmptyImport;

        PrecedingWhitespacesAndCommentsBinder(boolean afterImport) {
            this.myAfterEmptyImport = afterImport;
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.size() == 0) {
                return 0;
            }
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                if (tokens.get(idx) != JavaDocElementType.DOC_COMMENT) continue;
                return idx;
            }
            int result2 = tokens.size();
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount(getter2.get(idx)) <= 1) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                if (!atStreamEdge && (idx != 0 || !this.myAfterEmptyImport) && (idx <= 0 || !TokenSet.WHITE_SPACE.contains(tokens.get(idx - 1)) || !StringUtil.containsLineBreak(getter2.get(idx - 1)))) continue;
                result2 = idx;
            }
            return result2;
        }
    }

    @FunctionalInterface
    public static interface ParserWrapper {
        public void parse(PsiBuilder var1);
    }
}

