/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.util.MultimapKt;
import org.jetbrains.kotlin.fir.util.SetMultimap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170\u0018j\u0002`\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0015\u00a2\u0006\u0002\u0010!R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012RA\u0010\u0013\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170\u0018j\b\u0012\u0004\u0012\u00020\u0017`\u00160\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "conditionallyInitializedProperties", "receiver", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;)V", "getProperties", "()Ljava/util/Set;", "getConditionallyInitializedProperties", "getReceiver", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getGraph", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "getData", "()Ljava/util/Map;", "data$delegate", "Lkotlin/Lazy;", "getValue", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "node", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)Lkotlinx/collections/immutable/PersistentMap;", "checkers"})
public final class PropertyInitializationInfoData {
    @NotNull
    private final Set<FirPropertySymbol> properties;
    @NotNull
    private final Set<FirPropertySymbol> conditionallyInitializedProperties;
    @Nullable
    private final FirBasedSymbol<?> receiver;
    @NotNull
    private final ControlFlowGraph graph;
    @NotNull
    private final Lazy data$delegate;

    public PropertyInitializationInfoData(@NotNull Set<? extends FirPropertySymbol> properties2, @NotNull Set<? extends FirPropertySymbol> conditionallyInitializedProperties, @Nullable FirBasedSymbol<?> receiver, @NotNull ControlFlowGraph graph) {
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Intrinsics.checkNotNullParameter(conditionallyInitializedProperties, (String)"conditionallyInitializedProperties");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.properties = properties2;
        this.conditionallyInitializedProperties = conditionallyInitializedProperties;
        this.receiver = receiver;
        this.graph = graph;
        this.data$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PropertyInitializationInfoData.data_delegate$lambda$1(this));
    }

    @NotNull
    public final Set<FirPropertySymbol> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Set<FirPropertySymbol> getConditionallyInitializedProperties() {
        return this.conditionallyInitializedProperties;
    }

    @Nullable
    public final FirBasedSymbol<?> getReceiver() {
        return this.receiver;
    }

    @NotNull
    public final ControlFlowGraph getGraph() {
        return this.graph;
    }

    private final Map<CFGNode<?>, PersistentMap<EdgeLabel, PropertyInitializationInfo>> getData() {
        Lazy lazy = this.data$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final PersistentMap<EdgeLabel, PropertyInitializationInfo> getValue(@NotNull CFGNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return (PersistentMap)MapsKt.getValue(this.getData(), node);
    }

    private static final Map data_delegate$lambda$1(PropertyInitializationInfoData this$0) {
        SetMultimap<FirStatement, FirPropertySymbol> setMultimap;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SetMultimap<FirStatement, FirPropertySymbol> $this$data_delegate_u24lambda_u241_u24lambda_u240 = setMultimap = MultimapKt.setMultimapOf();
        boolean bl = false;
        FirDeclaration firDeclaration = this$0.graph.getDeclaration();
        if (firDeclaration != null) {
            firDeclaration.accept(new PropertyDeclarationCollector($this$data_delegate_u24lambda_u241_u24lambda_u240), null);
        }
        SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesInLoop = setMultimap;
        return CfgTraverserKt.collectDataForNode(this$0.graph, TraverseDirection.Forward, new PropertyInitializationInfoCollector(this$0.properties, this$0.receiver, declaredVariablesInLoop));
    }
}

