/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverDescription;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a6\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u0004H\u0002\u001a\f\u0010\u000e\u001a\u00020\r*\u00020\u0004H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\r*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\r*\u00020\u0002H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\"\u0018\u0010\u000f\u001a\u00020\r*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"prepareReceivers", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverDescription;", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "argumentExtensionReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "findClosestMatchingReceivers", "", "receiverGroups", "isSuperCall", "", "isSuperReferenceExpression", "isInvokeFromExtensionFunctionType", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;)Z", "shouldHaveLowPriorityDueToSAM", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "isJavaApplicableCandidate", "markCandidateForCompatibilityResolve", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "Lorg/jetbrains/kotlin/fir/FirElement;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/ResolutionStagesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,861:1\n1#2:862\n1557#3:863\n1628#3,3:864\n774#3:867\n865#3,2:868\n1755#3,2:870\n1757#3:884\n96#4:872\n87#4,11:873\n96#4:885\n87#4,11:886\n96#4:897\n87#4,11:898\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/ResolutionStagesKt\n*L\n304#1:863\n304#1:864,3\n305#1:867\n305#1:868,2\n561#1:870,2\n561#1:884\n565#1:872\n565#1:873,11\n571#1:885\n571#1:886,11\n580#1:897\n580#1:898,11\n*E\n"})
public final class ResolutionStagesKt {
    @NotNull
    private static final ClassId DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID = ClassId.Companion.topLevel(AnnotationsForResolveKt.getDYNAMIC_EXTENSION_FQ_NAME());

    private static final ReceiverDescription prepareReceivers(Candidate $this$prepareReceivers, FirExpression argumentExtensionReceiver, ConeKotlinType expectedType, ResolutionContext context2) {
        ConeKotlinType it = ArgumentsKt.captureFromTypeParameterUpperBoundIfNeeded(FirTypeUtilsKt.getResolvedType(argumentExtensionReceiver), expectedType, context2.getSession());
        boolean bl = false;
        ConeKotlinType argumentType = ArgumentsKt.prepareCapturedType(it, context2);
        return new ReceiverDescription(argumentExtensionReceiver, argumentType);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ReceiverDescription> findClosestMatchingReceivers(Candidate $this$findClosestMatchingReceivers, ConeKotlinType expectedType, List<? extends List<? extends FirExpression>> receiverGroups, ResolutionContext context2) {
        for (List<? extends FirExpression> list : receiverGroups) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ReceiverDescription it;
            boolean bl;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl = false;
                collection.add(ResolutionStagesKt.prepareReceivers($this$findClosestMatchingReceivers, (FirExpression)((Object)it), expectedType, context2));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ReceiverDescription)element$iv$iv;
                bl = false;
                if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible($this$findClosestMatchingReceivers.getSystem(), it.getType(), expectedType, SimpleConstraintSystemConstraintPosition.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List currentResult = (List)destination$iv$iv;
            if (!(!((Collection)currentResult).isEmpty())) continue;
            return currentResult;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean isSuperCall(FirExpression $this$isSuperCall) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        return ((FirQualifiedAccessExpression)$this$isSuperCall).getCalleeReference() instanceof FirSuperReference;
    }

    private static final boolean isSuperReferenceExpression(FirExpression $this$isSuperReferenceExpression) {
        boolean bl;
        if ($this$isSuperReferenceExpression instanceof FirQualifiedAccessExpression) {
            FirReference calleeReference = ((FirQualifiedAccessExpression)$this$isSuperReferenceExpression).getCalleeReference();
            bl = calleeReference instanceof FirSuperReference;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInvokeFromExtensionFunctionType(Candidate $this$isInvokeFromExtensionFunctionType) {
        if ($this$isInvokeFromExtensionFunctionType.getExplicitReceiverKind() != ExplicitReceiverKind.DISPATCH_RECEIVER) return false;
        FirExpression firExpression = $this$isInvokeFromExtensionFunctionType.getDispatchReceiver();
        Object object = firExpression;
        if (firExpression == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        ConeKotlinType coneKotlinType2 = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object, $this$isInvokeFromExtensionFunctionType.getCallInfo().getSession());
        object = coneKotlinType2;
        if (coneKotlinType2 == null) return false;
        if (!CompilerConeAttributesKt.isExtensionFunctionType((ConeKotlinType)object)) return false;
        boolean bl = true;
        if (!bl) return false;
        FirBasedSymbol<?> firBasedSymbol = $this$isInvokeFromExtensionFunctionType.getSymbol();
        FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
        if (!Intrinsics.areEqual((Object)(firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getName() : null), (Object)OperatorNameConventions.INVOKE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean shouldHaveLowPriorityDueToSAM(@NotNull Candidate $this$shouldHaveLowPriorityDueToSAM, @NotNull BodyResolveComponents bodyResolveComponents) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveLowPriorityDueToSAM, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        if (!$this$shouldHaveLowPriorityDueToSAM.getUsesSamConversion()) return false;
        if (ResolutionStagesKt.isJavaApplicableCandidate($this$shouldHaveLowPriorityDueToSAM)) {
            return false;
        }
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = $this$shouldHaveLowPriorityDueToSAM.getArgumentMapping();
        Intrinsics.checkNotNull(linkedHashMap);
        Collection<FirValueParameter> collection = linkedHashMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$any$iv = collection;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirValueParameter it = (FirValueParameter)element$iv;
            boolean bl2 = false;
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(it.getReturnTypeRef());
            if (bodyResolveComponents.getSamResolver().isSamType(coneType)) {
                boolean bl3;
                FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(coneType, bodyResolveComponents.getSession());
                if (firRegularClassSymbol != null) {
                    boolean bl4;
                    FirBasedSymbol $this$isJavaOrEnhancement$iv = firRegularClassSymbol;
                    boolean $i$f$isJavaOrEnhancement = false;
                    FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
                    boolean $i$f$isJavaOrEnhancement2 = false;
                    if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java) return true;
                    if (Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
                        return true;
                    }
                    boolean bl5 = false;
                    if (bl5) return true;
                    Object e = $this$isJavaOrEnhancement$iv.getFir();
                    Object object = e instanceof FirCallableDeclaration ? (FirCallableDeclaration)e : null;
                    if (object != null && (object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object)) != null && (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) != null) {
                        if (DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) {
                            return true;
                        }
                        bl4 = false;
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        return true;
                    }
                    boolean bl6 = false;
                    if (bl6) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJavaApplicableCandidate(Candidate $this$isJavaApplicableCandidate) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = $this$isJavaApplicableCandidate.getSymbol();
        if (!(firBasedSymbol instanceof FirFunctionSymbol)) return false;
        FirFunctionSymbol firFunctionSymbol = (FirFunctionSymbol)firBasedSymbol;
        if (firFunctionSymbol == null) {
            return false;
        }
        FirFunctionSymbol symbol = firFunctionSymbol;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = symbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java) return true;
        if (Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        Object e = $this$isJavaOrEnhancement$iv.getFir();
        Object object = e instanceof FirCallableDeclaration ? (FirCallableDeclaration)e : null;
        if (object != null && (object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object)) != null && (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) != null) {
            if (DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) {
            return true;
        }
        if (!($this$isJavaApplicableCandidate.getOriginScope() instanceof FirTypeScope)) {
            return false;
        }
        if (!(symbol instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions((FirTypeScope)$this$isJavaApplicableCandidate.getOriginScope(), (FirNamedFunctionSymbol)symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> ResolutionStagesKt.isJavaApplicableCandidate$lambda$4(result2, arg_0)));
        return result2.element;
    }

    private static final void markCandidateForCompatibilityResolve(CheckerSink $this$markCandidateForCompatibilityResolve, ResolutionContext context2) {
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
            return;
        }
        $this$markCandidateForCompatibilityResolve.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuperCall(@NotNull FirElement $this$isSuperCall, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuperCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) return false;
        FirExpression firExpression = ((FirQualifiedAccessExpression)$this$isSuperCall).getExplicitReceiver();
        if (!((firExpression != null ? ReferenceUtilsKt.toReference(firExpression, session2) : null) instanceof FirSuperReference)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final ProcessorAction isJavaApplicableCandidate$lambda$4(Ref.BooleanRef $result, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$isJavaOrEnhancement$iv = it;
        $i$f$isJavaOrEnhancement = false;
        $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        $i$f$isJavaOrEnhancement = false;
        if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java != false || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE) != false) ** GOTO lbl-1000
        var5_6 = $this$isJavaOrEnhancement$iv.getFir();
        v0 = var5_6 instanceof FirCallableDeclaration != false ? (FirCallableDeclaration)var5_6 : null;
        v1 = v0 != null && (v0 = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(v0)) != null && (v0 = v0.getOriginal()) != null ? DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)v0) : false;
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        if (v2) {
            $result.element = true;
            v3 = ProcessorAction.STOP;
        } else {
            v3 = ProcessorAction.NEXT;
        }
        return v3;
    }

    public static final /* synthetic */ boolean access$isSuperReferenceExpression(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperReferenceExpression($receiver);
    }

    public static final /* synthetic */ boolean access$isInvokeFromExtensionFunctionType(Candidate $receiver) {
        return ResolutionStagesKt.isInvokeFromExtensionFunctionType($receiver);
    }

    public static final /* synthetic */ ReceiverDescription access$prepareReceivers(Candidate $receiver, FirExpression argumentExtensionReceiver, ConeKotlinType expectedType, ResolutionContext context2) {
        return ResolutionStagesKt.prepareReceivers($receiver, argumentExtensionReceiver, expectedType, context2);
    }

    public static final /* synthetic */ boolean access$isSuperCall(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperCall($receiver);
    }

    public static final /* synthetic */ List access$findClosestMatchingReceivers(Candidate $receiver, ConeKotlinType expectedType, List receiverGroups, ResolutionContext context2) {
        return ResolutionStagesKt.findClosestMatchingReceivers($receiver, expectedType, receiverGroups, context2);
    }

    public static final /* synthetic */ void access$markCandidateForCompatibilityResolve(CheckerSink $receiver, ResolutionContext context2) {
        ResolutionStagesKt.markCandidateForCompatibilityResolve($receiver, context2);
    }

    public static final /* synthetic */ ClassId access$getDYNAMIC_EXTENSION_ANNOTATION_CLASS_ID$p() {
        return DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID;
    }
}

