/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.util.PersistentMultimap;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\b\u0002\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0010J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\fJ$\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020%0(H\u0016J(\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020%0(H\u0016J.\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u001c\u0010'\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020%0+H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\u0004H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000401H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u000401H\u0016R!\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "properties", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "functions", "Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "classes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/FirSession;)V", "session", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getProperties", "()Lkotlinx/collections/immutable/PersistentMap;", "getFunctions", "()Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;", "getClasses", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "storeClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "storeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "storeVariable", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "storeBackingField", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "processFunctionsByName", "", "name", "processor", "Lkotlin/Function1;", "processPropertiesByName", "processClassifiersByNameWithSubstitution", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "mayContainName", "", "getCallableNames", "", "getClassifierNames", "providers"})
@SourceDebugExtension(value={"SMAP\nFirLocalScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1279#2,2:92\n1293#2,4:94\n*S KotlinDebug\n*F\n+ 1 FirLocalScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope\n*L\n81#1:92,2\n81#1:94,4\n*E\n"})
public final class FirLocalScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final PersistentMap<Name, FirVariableSymbol<?>> properties;
    @NotNull
    private final PersistentMultimap<Name, FirNamedFunctionSymbol> functions;
    @NotNull
    private final PersistentMap<Name, FirRegularClassSymbol> classes;
    @NotNull
    private final FirSession useSiteSession;

    private FirLocalScope(PersistentMap<Name, ? extends FirVariableSymbol<?>> properties2, PersistentMultimap<Name, FirNamedFunctionSymbol> functions, PersistentMap<Name, FirRegularClassSymbol> classes, FirSession useSiteSession) {
        this.properties = properties2;
        this.functions = functions;
        this.classes = classes;
        this.useSiteSession = useSiteSession;
    }

    @NotNull
    public final PersistentMap<Name, FirVariableSymbol<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final PersistentMultimap<Name, FirNamedFunctionSymbol> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final PersistentMap<Name, FirRegularClassSymbol> getClasses() {
        return this.classes;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    public FirLocalScope(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(ExtensionsKt.persistentMapOf(), new PersistentMultimap<Name, FirNamedFunctionSymbol>(), ExtensionsKt.persistentMapOf(), session2);
    }

    @NotNull
    public final FirLocalScope storeClass(@NotNull FirRegularClass klass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return new FirLocalScope(this.properties, this.functions, this.classes.put(klass.getName(), klass.getSymbol()), session2);
    }

    @NotNull
    public final FirLocalScope storeFunction(@NotNull FirSimpleFunction function2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return new FirLocalScope(this.properties, this.functions.put(function2.getName(), function2.getSymbol()), this.classes, session2);
    }

    @NotNull
    public final FirLocalScope storeVariable(@NotNull FirVariable variable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return new FirLocalScope(this.properties.put(variable.getName(), variable.getSymbol()), this.functions, this.classes, session2);
    }

    @NotNull
    public final FirLocalScope storeBackingField(@NotNull FirProperty property, @NotNull FirSession session2) {
        PersistentMap<Name, Object> enhancedProperties;
        PersistentMap<Name, Object> persistentMap;
        PersistentMap<Name, Object> persistentMap2;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Object object = property.getBackingField();
        if (object != null && (object = ((FirBackingField)object).getSymbol()) != null) {
            Object it = object;
            boolean bl = false;
            persistentMap2 = this.properties.put(StandardNames.BACKING_FIELD, (FirVariableSymbol<?>)it);
        } else {
            persistentMap2 = null;
        }
        if ((persistentMap = (enhancedProperties = persistentMap2)) == null) {
            persistentMap = this.properties;
        }
        return new FirLocalScope(persistentMap, this.functions, this.classes, session2);
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        for (FirNamedFunctionSymbol function2 : this.functions.get(name2)) {
            processor.invoke((Object)function2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        FirVariableSymbol property = (FirVariableSymbol)this.properties.get(name2);
        if (property != null) {
            processor.invoke((Object)property);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        FirRegularClassSymbol klass = (FirRegularClassSymbol)this.classes.get(name2);
        if (klass != null) {
            Iterable $this$associateWith$iv = klass.getTypeParameterSymbols();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                ConeTypeParameterType coneTypeParameterType = FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)it);
                map.put(t, coneTypeParameterType);
            }
            Map substitution = result$iv;
            processor.invoke((Object)klass, (Object)ConeSubstitutorByMap.Companion.create$default(ConeSubstitutorByMap.Companion, substitution, this.useSiteSession, false, 4, null));
        }
    }

    @Override
    public boolean mayContainName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.properties.containsKey(name2) || !((Collection)this.functions.get(name2)).isEmpty() || this.classes.containsKey(name2);
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.plus(this.properties.keySet(), (Iterable)this.functions.getKeys());
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return this.classes.keySet();
    }
}

