/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.overrides.MemberWithOriginal;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextWithAdditionalAxioms;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/overrides/IrOverrideChecker;", "", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Ljava/util/List;)V", "getBothWaysOverridability", "Lorg/jetbrains/kotlin/resolve/OverridingUtil$OverrideCompatibilityInfo$Result;", "overrider", "Lorg/jetbrains/kotlin/ir/overrides/MemberWithOriginal;", "candidate", "isOverridableBy", "Lorg/jetbrains/kotlin/resolve/OverridingUtil$OverrideCompatibilityInfo;", "superMember", "subMember", "checkIsInlineFlag", "", "isOverridableByWithoutExternalConditions", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "areTypeParametersEquivalent", "superTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "subTypeParameter", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "runExternalOverridabilityConditions", "basicResult", "ir.tree"})
public final class IrOverrideChecker {
    @NotNull
    private final IrTypeSystemContext typeSystem;
    @NotNull
    private final List<IrExternalOverridabilityCondition> externalOverridabilityConditions;

    public IrOverrideChecker(@NotNull IrTypeSystemContext typeSystem, @NotNull List<? extends IrExternalOverridabilityCondition> externalOverridabilityConditions) {
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        Intrinsics.checkNotNullParameter(externalOverridabilityConditions, (String)"externalOverridabilityConditions");
        this.typeSystem = typeSystem;
        this.externalOverridabilityConditions = externalOverridabilityConditions;
    }

    @NotNull
    public final OverridingUtil.OverrideCompatibilityInfo.Result getBothWaysOverridability(@NotNull MemberWithOriginal overrider, @NotNull MemberWithOriginal candidate2) {
        Intrinsics.checkNotNullParameter((Object)overrider, (String)"overrider");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        OverridingUtil.OverrideCompatibilityInfo.Result result2 = this.isOverridableBy(candidate2, overrider, false).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result2), (String)"getResult(...)");
        OverridingUtil.OverrideCompatibilityInfo.Result result1 = result2;
        OverridingUtil.OverrideCompatibilityInfo.Result result3 = this.isOverridableBy(overrider, candidate2, false).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result3), (String)"getResult(...)");
        OverridingUtil.OverrideCompatibilityInfo.Result result22 = result3;
        return result1 == result22 ? result1 : OverridingUtil.OverrideCompatibilityInfo.Result.INCOMPATIBLE;
    }

    @NotNull
    public final OverridingUtil.OverrideCompatibilityInfo isOverridableBy(@NotNull MemberWithOriginal superMember, @NotNull MemberWithOriginal subMember, boolean checkIsInlineFlag) {
        Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
        Intrinsics.checkNotNullParameter((Object)subMember, (String)"subMember");
        OverridingUtil.OverrideCompatibilityInfo basicResult = this.isOverridableByWithoutExternalConditions(superMember.getMember(), subMember.getMember(), checkIsInlineFlag);
        return this.runExternalOverridabilityConditions(superMember, subMember, basicResult);
    }

    /*
     * Unable to fully structure code
     */
    private final OverridingUtil.OverrideCompatibilityInfo isOverridableByWithoutExternalConditions(IrOverridableMember superMember, IrOverridableMember subMember, boolean checkIsInlineFlag) {
        block21: {
            block23: {
                block24: {
                    block22: {
                        var5_4 = superMember;
                        if (var5_4 instanceof IrSimpleFunction) {
                            if (!(subMember instanceof IrSimpleFunction)) {
                                v0 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Member kind mismatch");
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"incompatible(...)");
                                return v0;
                            }
                            if (((IrSimpleFunction)superMember).isSuspend() != ((IrSimpleFunction)subMember).isSuspend()) {
                                v1 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Incompatible suspendability");
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"incompatible(...)");
                                return v1;
                            }
                            v2 = TuplesKt.to((Object)superMember, (Object)subMember);
                        } else if (var5_4 instanceof IrProperty) {
                            if (!(subMember instanceof IrProperty)) {
                                v3 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Member kind mismatch");
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"incompatible(...)");
                                return v3;
                            }
                            v2 = TuplesKt.to((Object)((IrProperty)superMember).getGetter(), (Object)((IrProperty)subMember).getGetter());
                        } else {
                            throw new IllegalStateException(("Unexpected type of declaration: " + superMember.getClass() + ", " + superMember).toString());
                        }
                        var4_5 = v2;
                        superFunction = (IrSimpleFunction)var4_5.component1();
                        subFunction = (IrSimpleFunction)var4_5.component2();
                        if (!checkIsInlineFlag) break block21;
                        var8_7 = superMember;
                        if (!(var8_7 instanceof IrSimpleFunction)) break block22;
                        v4 = ((IrSimpleFunction)superMember).isInline();
                        break block23;
                    }
                    if (!(var8_7 instanceof IrProperty)) break block24;
                    v5 = ((IrProperty)superMember).getGetter();
                    if (v5 != null ? v5.isInline() : false) ** GOTO lbl-1000
                    v6 = ((IrProperty)superMember).getSetter();
                    v7 = v6 != null ? v6.isInline() : false;
                    if (v7) lbl-1000:
                    // 2 sources

                    {
                        v4 = true;
                    } else {
                        v4 = false;
                    }
                    break block23;
                }
                AddToStdlibKt.unreachableBranch(superMember);
                throw null;
            }
            isInline = v4;
            if (isInline) {
                v8 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Inline declaration can't be overridden");
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"incompatible(...)");
                return v8;
            }
        }
        if (!Intrinsics.areEqual((Object)superMember.getName(), (Object)subMember.getName())) {
            v9 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Name mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"incompatible(...)");
            return v9;
        }
        v10 = superFunction;
        superExtensionReceiver = v10 != null ? v10.getExtensionReceiverParameter() : null;
        v11 = subFunction;
        if (superExtensionReceiver == null != ((subExtensionReceiver = v11 != null ? v11.getExtensionReceiverParameter() : null) == null)) {
            v12 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"incompatible(...)");
            return v12;
        }
        v13 = superFunction;
        v14 = v13 != null ? v13.getTypeParameters() : null;
        if (v14 == null) {
            v14 = CollectionsKt.emptyList();
        }
        superTypeParameters = v14;
        v15 = subFunction;
        v16 = v15 != null ? v15.getTypeParameters() : null;
        if (v16 == null) {
            v16 = subTypeParameters = CollectionsKt.emptyList();
        }
        if (superTypeParameters.size() != subTypeParameters.size()) {
            v17 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Type parameter number mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"incompatible(...)");
            return v17;
        }
        v18 = superFunction;
        v19 = v18 != null ? v18.getValueParameters() : null;
        if (v19 == null) {
            v19 = CollectionsKt.emptyList();
        }
        superValueParameters = v19;
        v20 = subFunction;
        v21 = v20 != null ? v20.getValueParameters() : null;
        if (v21 == null) {
            v21 = subValueParameters = CollectionsKt.emptyList();
        }
        if (superValueParameters.size() != subValueParameters.size()) {
            v22 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Value parameter number mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"incompatible(...)");
            return v22;
        }
        typeCheckerState = IrTypeCheckerStateKt.createIrTypeCheckerState(new IrTypeSystemContextWithAdditionalAxioms(this.typeSystem, (List<? extends IrTypeParameter>)superTypeParameters, (List<? extends IrTypeParameter>)subTypeParameters));
        var14_15 = ((Iterable)superTypeParameters).iterator();
        var15_16 = 0;
        while (var14_15.hasNext()) {
            index = var15_16++;
            superTypeParameter = (IrTypeParameter)var14_15.next();
            if (this.areTypeParametersEquivalent(superTypeParameter, (IrTypeParameter)subTypeParameters.get(index), typeCheckerState)) continue;
            v23 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Type parameter bounds mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"incompatible(...)");
            return v23;
        }
        if (superExtensionReceiver != null && subExtensionReceiver != null && !AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, subExtensionReceiver.getType(), superExtensionReceiver.getType())) {
            v24 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Extension receiver parameter type mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"incompatible(...)");
            return v24;
        }
        var14_15 = ((Iterable)superValueParameters).iterator();
        var15_16 = 0;
        while (var14_15.hasNext()) {
            index = var15_16++;
            superValueParameter = (IrValueParameter)var14_15.next();
            if (AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, ((IrValueParameter)subValueParameters.get(index)).getType(), superValueParameter.getType())) continue;
            v25 = OverridingUtil.OverrideCompatibilityInfo.incompatible("Value parameter type mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"incompatible(...)");
            return v25;
        }
        v26 = OverridingUtil.OverrideCompatibilityInfo.success();
        Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"success(...)");
        return v26;
    }

    private final boolean areTypeParametersEquivalent(IrTypeParameter superTypeParameter, IrTypeParameter subTypeParameter, TypeCheckerState typeCheckerState) {
        List<IrType> superBounds = superTypeParameter.getSuperTypes();
        List subBounds = CollectionsKt.toMutableList((Collection)subTypeParameter.getSuperTypes());
        if (superBounds.size() != subBounds.size()) {
            return false;
        }
        block0: for (IrType superBound : superBounds) {
            ListIterator it = subBounds.listIterator();
            while (it.hasNext()) {
                IrType subBound = (IrType)it.next();
                if (!AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, superBound, subBound)) continue;
                it.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    private final OverridingUtil.OverrideCompatibilityInfo runExternalOverridabilityConditions(MemberWithOriginal superMember, MemberWithOriginal subMember, OverridingUtil.OverrideCompatibilityInfo basicResult) {
        IrExternalOverridabilityCondition.Result result2;
        boolean wasSuccess = basicResult.getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
        block10: for (IrExternalOverridabilityCondition externalCondition : this.externalOverridabilityConditions) {
            if (externalCondition.getContract() == IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY || wasSuccess && externalCondition.getContract() == IrExternalOverridabilityCondition.Contract.SUCCESS_ONLY) continue;
            result2 = externalCondition.isOverridable(superMember, subMember);
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 1: {
                    wasSuccess = true;
                    continue block10;
                }
                case 2: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("External condition");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                    return overrideCompatibilityInfo;
                }
                case 3: {
                    continue block10;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!wasSuccess) {
            return basicResult;
        }
        block11: for (IrExternalOverridabilityCondition externalCondition : this.externalOverridabilityConditions) {
            if (externalCondition.getContract() != IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY) continue;
            result2 = externalCondition.isOverridable(superMember, subMember);
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 2: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("External condition");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                    return overrideCompatibilityInfo;
                }
                case 1: {
                    throw new IllegalStateException(("Contract violation in " + externalCondition.getClass() + " condition. It's not supposed to end with success").toString());
                }
                case 3: {
                    continue block11;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.success();
        Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"success(...)");
        return overrideCompatibilityInfo;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrExternalOverridabilityCondition.Result.values().length];
            try {
                nArray[IrExternalOverridabilityCondition.Result.OVERRIDABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.INCOMPATIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

