/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.DeclarationCheckersKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SynchronizedAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isInInterface", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\ndeclarationCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationCheckers.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/SynchronizedAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class SynchronizedAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AnnotationDescriptor synchronizedAnnotation = JvmAnnotationUtilKt.findSynchronizedAnnotation(descriptor);
        if (synchronizedAnnotation != null && descriptor instanceof FunctionDescriptor) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(synchronizedAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            if (this.isInInterface((FunctionDescriptor)descriptor)) {
                context2.getTrace().report(ErrorsJvm.SYNCHRONIZED_IN_INTERFACE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            } else if (((FunctionDescriptor)descriptor).getModality() == Modality.ABSTRACT) {
                context2.getTrace().report(ErrorsJvm.SYNCHRONIZED_ON_ABSTRACT.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            } else if (((FunctionDescriptor)descriptor).isInline()) {
                context2.getTrace().report(ErrorsJvm.SYNCHRONIZED_ON_INLINE.on((KtElement)((PsiElement)annotationEntry)));
            } else if (((FunctionDescriptor)descriptor).isSuspend()) {
                context2.getTrace().report(ErrorsJvm.SYNCHRONIZED_ON_SUSPEND.on(context2.getLanguageVersionSettings(), annotationEntry));
            } else {
                DeclarationDescriptor it = ((FunctionDescriptor)descriptor).getContainingDeclaration();
                boolean bl = false;
                boolean bl2 = it instanceof ClassDescriptor && ((ClassDescriptor)it).isValue();
                if (bl2) {
                    context2.getTrace().report(ErrorsJvm.SYNCHRONIZED_ON_VALUE_CLASS.on((KtElement)((PsiElement)annotationEntry)));
                }
            }
        }
    }

    private final boolean isInInterface(FunctionDescriptor descriptor) {
        return DescriptorUtils.isInterface(descriptor.getContainingDeclaration()) || DeclarationCheckersKt.isInsideCompanionObjectOfInterface(DescriptorUtilsKt.getPropertyIfAccessor(descriptor)) && (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor) || AnnotationUtilKt.hasJvmStaticAnnotation(DescriptorUtilsKt.getPropertyIfAccessor(descriptor)));
    }
}

