/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractPropertyUpdatesReport;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.util.AggregateReportUtils;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="property-updates-aggregate-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, aggregator=true)
public class PropertyUpdatesAggregateReport
extends AbstractPropertyUpdatesReport {
    @Inject
    protected PropertyUpdatesAggregateReport(I18N i18n, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, artifactHandlerManager, repositorySystem, wagonMap, rendererFactory);
    }

    @Override
    protected void populateUpdateSet(Map<Property, PropertyVersions> propertyCollector) throws MojoExecutionException, MavenReportException {
        VersionsHelper helper = this.getHelper();
        for (MavenProject project : AggregateReportUtils.getProjectsToProcess(this.getProject())) {
            propertyCollector.putAll(helper.getVersionPropertiesMap(this.getRequest(project)));
        }
    }

    @Override
    protected boolean haveBuildProperties() {
        for (MavenProject project : AggregateReportUtils.getProjectsToProcess(this.getProject())) {
            if (project.getProperties() == null || project.getProperties().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getOutputName() {
        return "property-updates-aggregate-report";
    }
}

