/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="resolve-ranges", threadSafe=true)
public class ResolveRangesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="processProperties", defaultValue="true")
    private boolean processProperties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    private final Pattern matchRangeRegex = Pattern.compile(",");

    @Inject
    public ResolveRangesMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        if (this.hasDependencyManagement() && this.hasDependenciesInDependencyManagement() && this.isProcessingDependencyManagement()) {
            this.getLog().debug((CharSequence)("processing dependencyManagement of " + this.getProject().getId()));
            this.resolveRanges(pom, this.getProject().getModel().getDependencyManagement().getDependencies());
        }
        if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
            this.getLog().debug((CharSequence)("processing dependencies of " + this.getProject().getId()));
            this.resolveRanges(pom, this.getProject().getModel().getDependencies());
        }
        if (this.hasParent() && this.isProcessingParent()) {
            this.getLog().debug((CharSequence)("processing parent " + this.getProject().getId()));
            this.resolveRangesInParent(pom);
        }
        if (this.processProperties) {
            this.getLog().debug((CharSequence)("processing properties of " + this.getProject().getId()));
            this.resolvePropertyRanges(pom);
        }
    }

    private boolean hasParent() {
        return this.getProject().getModel().getParent() != null;
    }

    private boolean hasDependenciesInDependencyManagement() {
        return this.getProject().getModel().getDependencyManagement().getDependencies() != null;
    }

    private boolean hasDependencyManagement() {
        return this.getProject().getModel().getDependencyManagement() != null;
    }

    private void resolveRangesInParent(MutableXMLStreamReader pom) throws MojoExecutionException, VersionRetrievalException, XMLStreamException {
        Artifact artifact;
        Matcher versionMatcher = this.matchRangeRegex.matcher(this.getProject().getModel().getParent().getVersion());
        if (versionMatcher.find() && (artifact = this.toArtifact(this.getProject().getModel().getParent())) != null && this.isIncluded(artifact)) {
            this.getLog().debug((CharSequence)("Resolving version range for parent: " + artifact));
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null) {
                ArtifactVersion latestVersion = this.findLatestVersion(artifact, artifact.getVersionRange(), this.allowSnapshots, false);
                if (latestVersion != null) {
                    artifactVersion = latestVersion.toString();
                } else {
                    this.getLog().warn((CharSequence)("Not updating version " + artifact + " : could not resolve any versions"));
                }
            }
            if (artifactVersion != null) {
                if (PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)artifactVersion)) {
                    this.getLog().debug((CharSequence)("Version set to " + artifactVersion + " for parent: " + artifact));
                } else {
                    this.getLog().warn((CharSequence)("Could not find the version tag for parent " + artifact + " in project " + this.getProject().getId() + " so unable to set version to " + artifactVersion));
                }
            }
        }
    }

    private void resolveRanges(MutableXMLStreamReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        for (Dependency dep : dependencies) {
            Artifact artifact;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) continue;
            if (StringUtils.isBlank((CharSequence)dep.getVersion())) {
                throw new MojoExecutionException("Found invalid managed dependency " + this.toString(dep) + " without a version");
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            Matcher versionMatcher = this.matchRangeRegex.matcher(dep.getVersion());
            if (!versionMatcher.find() || (artifact = this.toArtifact(dep)) == null || !this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Resolving version range for dependency: " + artifact));
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null) {
                ArtifactVersion latestVersion = this.findLatestVersion(artifact, artifact.getVersionRange(), this.allowSnapshots, false);
                if (latestVersion != null) {
                    artifactVersion = latestVersion.toString();
                } else {
                    this.getLog().warn((CharSequence)("Not updating version " + artifact + " : could not resolve any versions"));
                }
            }
            if (artifactVersion == null) continue;
            if (PomHelper.setDependencyVersion((MutableXMLStreamReader)pom, (String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)dep.getVersion(), (String)artifactVersion, (Model)this.getProject().getModel(), (Log)this.getLog())) {
                this.getLog().debug((CharSequence)("Version set to " + artifactVersion + " for dependency: " + artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Could not find the version tag for dependency " + artifact + " in project " + this.getProject().getId() + " so unable to set version to " + artifactVersion));
        }
    }

    private void resolvePropertyRanges(MutableXMLStreamReader pom) throws XMLStreamException, MojoExecutionException {
        if (this.includeProperties == null) {
            Properties originalProperties = this.getProject().getOriginalModel().getProperties();
            this.includeProperties = String.join((CharSequence)",", originalProperties.stringPropertyNames());
        }
        Map propertyVersions = this.getHelper().getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest.builder().withMavenProject(this.getProject()).withIncludeProperties(this.includeProperties).withExcludeProperties(this.excludeProperties).build());
        for (Map.Entry entry : propertyVersions.entrySet()) {
            Optional<Segment> unchangedSegment1;
            Property property = (Property)entry.getKey();
            PropertyVersions version = (PropertyVersions)entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null || !this.matchRangeRegex.matcher(currentVersion).find()) continue;
            property.setVersion(currentVersion);
            Log log = this.getLog();
            if (log != null && !this.allowIncrementalUpdates) {
                log.info((CharSequence)"Assuming allowMinorUpdates false because allowIncrementalUpdates is false.");
            }
            if (log != null && !this.allowMinorUpdates) {
                log.info((CharSequence)"Assuming allowMajorUpdates false because allowMinorUpdates is false.");
            }
            Optional<Object> optional = this.allowMajorUpdates && this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.empty() : (this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.of(Segment.MAJOR) : (unchangedSegment1 = this.allowIncrementalUpdates ? Optional.of(Segment.MINOR) : Optional.of(Segment.INCREMENTAL)));
            if (log != null && log.isDebugEnabled()) {
                log.debug((CharSequence)(unchangedSegment1.map(Segment::minorTo).map(Segment::toString).orElse("ALL") + " version changes allowed"));
            }
            try {
                this.updatePropertyToNewestVersion(pom, property, version, currentVersion, false, unchangedSegment1);
            }
            catch (InvalidVersionSpecificationException | InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s due to: %s", property.getName(), property.getVersion(), e.getMessage()));
            }
        }
    }
}

