/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

@Named(value="requireReleaseVersion")
public final class RequireReleaseVersion
extends AbstractStandardEnforcerRule {
    private final MavenProject project;
    private boolean failWhenParentIsSnapshot = true;

    @Inject
    public RequireReleaseVersion(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        Artifact parentArtifact;
        if (this.project.getArtifact().isSnapshot()) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message).append(System.lineSeparator());
            }
            buf.append("This project cannot be a snapshot:").append(this.project.getArtifact().getId());
            throw new EnforcerRuleException(buf.toString());
        }
        if (this.failWhenParentIsSnapshot && (parentArtifact = this.project.getParentArtifact()) != null && parentArtifact.isSnapshot()) {
            throw new EnforcerRuleException("Parent Cannot be a snapshot: " + parentArtifact.getId());
        }
    }

    public void setFailWhenParentIsSnapshot(boolean failWhenParentIsSnapshot) {
        this.failWhenParentIsSnapshot = failWhenParentIsSnapshot;
    }

    public String toString() {
        return String.format("RequireReleaseVersion[failWhenParentIsSnapshot=%b]", this.failWhenParentIsSnapshot);
    }
}

