/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher;
    private OutputStream output;
    private byte[] ibuffer = new byte[1];
    private byte[] obuffer;

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.output = outputStream;
        this.cipher = cipher;
    }

    protected CipherOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.output = outputStream;
        this.cipher = new NullCipher();
    }

    public void write(int n) throws IOException {
        this.ibuffer[0] = (byte)n;
        this.obuffer = this.cipher.update(this.ibuffer, 0, 1);
        if (this.obuffer != null) {
            this.output.write(this.obuffer);
            this.obuffer = null;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.obuffer = this.cipher.update(byArray, n, n2);
        if (this.obuffer != null) {
            this.output.write(this.obuffer);
            this.obuffer = null;
        }
    }

    public void flush() throws IOException {
        if (this.obuffer != null) {
            this.output.write(this.obuffer);
            this.obuffer = null;
        }
        this.output.flush();
    }

    public void close() throws IOException {
        try {
            this.obuffer = this.cipher.doFinal();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            this.obuffer = null;
        }
        catch (BadPaddingException badPaddingException) {
            this.obuffer = null;
        }
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }
}

