/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.event;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class RepeatedSingletonJob
implements Runnable {
    private boolean working = false;
    private final Executor executor;
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "RepeatedSingletonJob");

    public RepeatedSingletonJob(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("Null executor!");
        }
        this.executor = executor;
    }

    public boolean isWorking() {
        return this.working;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        RepeatedSingletonJob repeatedSingletonJob = this;
        synchronized (repeatedSingletonJob) {
            if (!this.working) {
                if (logger.traceOn()) {
                    logger.trace("resume", "");
                }
                this.working = true;
                this.execute();
            }
        }
    }

    public abstract void task();

    public abstract boolean isSuspended();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.traceOn()) {
            logger.trace("run", "execute the task");
        }
        try {
            this.task();
        }
        catch (Exception exception) {
            logger.trace("run", "failed to execute the task", exception);
        }
        RepeatedSingletonJob repeatedSingletonJob = this;
        synchronized (repeatedSingletonJob) {
            if (!this.isSuspended()) {
                this.execute();
            } else {
                if (logger.traceOn()) {
                    logger.trace("run", "suspend the task");
                }
                this.working = false;
            }
        }
    }

    private void execute() {
        try {
            this.executor.execute(this);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            logger.warning("execute", "Executor threw exception (" + this.getClass().getName() + ")", rejectedExecutionException);
            throw new RejectedExecutionException("Executor.execute threw exception -should not be possible", rejectedExecutionException);
        }
    }
}

