/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DirectAudioDevice;
import com.sun.media.sound.Platform;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class DirectAudioDeviceProvider
extends MixerProvider {
    private static DirectAudioDeviceInfo[] infos;
    private static DirectAudioDevice[] devices;

    public DirectAudioDeviceProvider() {
        if (Platform.isDirectAudioEnabled()) {
            DirectAudioDeviceProvider.init();
        } else {
            infos = new DirectAudioDeviceInfo[0];
            devices = new DirectAudioDevice[0];
        }
    }

    private static synchronized void init() {
        int n = DirectAudioDeviceProvider.nGetNumDevices();
        if (infos == null || infos.length != n) {
            infos = new DirectAudioDeviceInfo[n];
            devices = new DirectAudioDevice[n];
            for (int i = 0; i < infos.length; ++i) {
                DirectAudioDeviceProvider.infos[i] = DirectAudioDeviceProvider.nNewDirectAudioDeviceInfo(i);
            }
        }
    }

    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] infoArray = new Mixer.Info[infos.length];
        System.arraycopy(infos, 0, infoArray, 0, infos.length);
        return infoArray;
    }

    public Mixer getMixer(Mixer.Info info) {
        int n;
        if (info == null) {
            for (n = 0; n < infos.length; ++n) {
                Mixer mixer = this.getDevice(infos[n]);
                if (mixer.getSourceLineInfo().length <= 0) continue;
                return mixer;
            }
        }
        for (n = 0; n < infos.length; ++n) {
            if (!infos[n].equals(info)) continue;
            return this.getDevice(infos[n]);
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    private Mixer getDevice(DirectAudioDeviceInfo directAudioDeviceInfo) {
        int n = directAudioDeviceInfo.getIndex();
        if (devices[n] == null) {
            DirectAudioDeviceProvider.devices[n] = new DirectAudioDevice(directAudioDeviceInfo);
        }
        return devices[n];
    }

    private static native int nGetNumDevices();

    private static native DirectAudioDeviceInfo nNewDirectAudioDeviceInfo(int var0);

    static {
        Platform.initialize();
    }

    static class DirectAudioDeviceInfo
    extends Mixer.Info {
        private int index;
        private int maxSimulLines;
        private int deviceID;

        private DirectAudioDeviceInfo(int n, int n2, int n3, String string, String string2, String string3, String string4) {
            super(string, string2, "Direct Audio Device: " + string3, string4);
            this.index = n;
            this.maxSimulLines = n3;
            this.deviceID = n2;
        }

        int getIndex() {
            return this.index;
        }

        int getMaxSimulLines() {
            return this.maxSimulLines;
        }

        int getDeviceID() {
            return this.deviceID;
        }
    }
}

