/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.local.client;

import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.handler.MessageContextImpl;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.Tie;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.spi.runtime.WebServiceContext;
import com.sun.xml.internal.ws.transport.WSConnectionImpl;
import com.sun.xml.internal.ws.transport.local.LocalMessage;
import com.sun.xml.internal.ws.transport.local.server.LocalConnectionImpl;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClientTransport
extends WSConnectionImpl {
    private RuntimeEndpointInfo endpointInfo;
    private Tie tie = new Tie();
    LocalMessage lm = new LocalMessage();

    public LocalClientTransport(RuntimeEndpointInfo runtimeEndpointInfo) {
        this(runtimeEndpointInfo, null);
    }

    public LocalClientTransport(RuntimeEndpointInfo runtimeEndpointInfo, OutputStream outputStream) {
        this.endpointInfo = runtimeEndpointInfo;
        this.debugStream = outputStream;
    }

    @Override
    public OutputStream getOutput() {
        try {
            this.lm.setOutput(new ByteArrayBuffer());
            return this.lm.getOutput();
        }
        catch (Exception exception) {
            throw new ClientTransportException("local.client.failed", new Object[]{exception});
        }
    }

    private static void checkMessageContentType(WSConnection wSConnection, boolean bl) {
        String string = System.getProperty("com.sun.xml.ws.client.ContentNegotiation", "none").intern();
        String string2 = wSConnection.getHeaders().get("Content-Type").get(0);
        if (string == "none" ? string2.indexOf("text/xml") < 0 && string2.indexOf("application/soap+xml") < 0 && string2.indexOf("application/xop+xml") < 0 : (string == "optimistic" ? string2.indexOf("application/fastinfoset") < 0 && string2.indexOf("application/soap+fastinfoset") < 0 : string == "pessimistic" && bl && string2.indexOf("application/fastinfoset") < 0 && string2.indexOf("application/soap+fastinfoset") < 0)) {
            throw new RuntimeException("Invalid content type '" + string2 + "' with content negotiation set to '" + string + "'.");
        }
    }

    @Override
    public void closeOutput() {
        super.closeOutput();
        LocalConnectionImpl localConnectionImpl = new LocalConnectionImpl(this.lm);
        localConnectionImpl.setHeaders(this.getHeaders());
        LocalClientTransport.checkMessageContentType(this, false);
        try {
            WebServiceContext webServiceContext = this.endpointInfo.getWebServiceContext();
            webServiceContext.setMessageContext(new MessageContextImpl());
            this.tie.handle(localConnectionImpl, this.endpointInfo);
            LocalClientTransport.checkMessageContentType(localConnectionImpl, true);
        }
        catch (Exception exception) {
            new ProtocolException("Server side Exception:" + exception);
        }
    }

    @Override
    public InputStream getInput() {
        try {
            return this.lm.getOutput().newInputStream();
        }
        catch (Exception exception) {
            throw new ClientTransportException("local.client.failed", new Object[]{exception});
        }
    }

    @Override
    public void setHeaders(Map<String, List<String>> map) {
        this.lm.setHeaders(map);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.lm.getHeaders();
    }
}

