/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Proxy {
    private Type type;
    private SocketAddress sa;
    public static final Proxy NO_PROXY = new Proxy();

    private Proxy() {
        this.type = Type.DIRECT;
        this.sa = null;
    }

    public Proxy(Type type, SocketAddress socketAddress) {
        if (type == Type.DIRECT || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("type " + (Object)((Object)type) + " is not compatible with address " + socketAddress);
        }
        this.type = type;
        this.sa = socketAddress;
    }

    public Type type() {
        return this.type;
    }

    public SocketAddress address() {
        return this.sa;
    }

    public String toString() {
        if (this.type() == Type.DIRECT) {
            return "DIRECT";
        }
        return (Object)((Object)this.type()) + " @ " + this.address();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Proxy)) {
            return false;
        }
        Proxy proxy = (Proxy)object;
        if (proxy.type() == this.type()) {
            if (this.address() == null) {
                return proxy.address() == null;
            }
            return this.address().equals(proxy.address());
        }
        return false;
    }

    public final int hashCode() {
        if (this.address() == null) {
            return this.type().hashCode();
        }
        return this.type().hashCode() + this.address().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DIRECT,
        HTTP,
        SOCKS;

    }
}

