/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.PreferencesFactory;
import java.util.prefs.XmlSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preferences {
    private static final PreferencesFactory factory = Preferences.factory();
    public static final int MAX_KEY_LENGTH = 80;
    public static final int MAX_VALUE_LENGTH = 8192;
    public static final int MAX_NAME_LENGTH = 80;
    private static Permission prefsPerm = new RuntimePermission("preferences");

    private static PreferencesFactory factory() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.util.prefs.PreferencesFactory");
            }
        });
        if (string != null) {
            try {
                return (PreferencesFactory)Class.forName(string, false, ClassLoader.getSystemClassLoader()).newInstance();
            }
            catch (Exception exception) {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkPermission(new AllPermission());
                    }
                    return (PreferencesFactory)Class.forName(string, false, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                catch (Exception exception2) {
                    InternalError internalError = new InternalError("Can't instantiate Preferences factory " + string);
                    internalError.initCause(exception2);
                    throw internalError;
                }
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<PreferencesFactory>(){

            @Override
            public PreferencesFactory run() {
                return Preferences.factory1();
            }
        });
    }

    private static PreferencesFactory factory1() {
        Iterator<PreferencesFactory> iterator = ServiceLoader.load(PreferencesFactory.class, ClassLoader.getSystemClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                throw serviceConfigurationError;
            }
        }
        String string = System.getProperty("os.name").startsWith("Windows") ? "java.util.prefs.WindowsPreferencesFactory" : "java.util.prefs.FileSystemPreferencesFactory";
        try {
            return (PreferencesFactory)Class.forName(string, false, null).newInstance();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Can't instantiate platform default Preferences factory " + string);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static Preferences userNodeForPackage(Class<?> clazz) {
        return Preferences.userRoot().node(Preferences.nodeName(clazz));
    }

    public static Preferences systemNodeForPackage(Class<?> clazz) {
        return Preferences.systemRoot().node(Preferences.nodeName(clazz));
    }

    private static String nodeName(Class clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Arrays have no associated preferences node.");
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "/<unnamed>";
        }
        String string2 = string.substring(0, n);
        return "/" + string2.replace('.', '/');
    }

    public static Preferences userRoot() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(prefsPerm);
        }
        return factory.userRoot();
    }

    public static Preferences systemRoot() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(prefsPerm);
        }
        return factory.systemRoot();
    }

    protected Preferences() {
    }

    public abstract void put(String var1, String var2);

    public abstract String get(String var1, String var2);

    public abstract void remove(String var1);

    public abstract void clear() throws BackingStoreException;

    public abstract void putInt(String var1, int var2);

    public abstract int getInt(String var1, int var2);

    public abstract void putLong(String var1, long var2);

    public abstract long getLong(String var1, long var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void putFloat(String var1, float var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void putDouble(String var1, double var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void putByteArray(String var1, byte[] var2);

    public abstract byte[] getByteArray(String var1, byte[] var2);

    public abstract String[] keys() throws BackingStoreException;

    public abstract String[] childrenNames() throws BackingStoreException;

    public abstract Preferences parent();

    public abstract Preferences node(String var1);

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract void removeNode() throws BackingStoreException;

    public abstract String name();

    public abstract String absolutePath();

    public abstract boolean isUserNode();

    public abstract String toString();

    public abstract void flush() throws BackingStoreException;

    public abstract void sync() throws BackingStoreException;

    public abstract void addPreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void removePreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void addNodeChangeListener(NodeChangeListener var1);

    public abstract void removeNodeChangeListener(NodeChangeListener var1);

    public abstract void exportNode(OutputStream var1) throws IOException, BackingStoreException;

    public abstract void exportSubtree(OutputStream var1) throws IOException, BackingStoreException;

    public static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        XmlSupport.importPreferences(inputStream);
    }
}

