/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import com.sun.beans.decoder.ElementHandler;
import com.sun.beans.decoder.ValueObject;
import com.sun.beans.decoder.ValueObjectImpl;
import com.sun.beans.finder.ConstructorFinder;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewElementHandler
extends ElementHandler {
    private List<Object> arguments = new ArrayList<Object>();
    private ValueObject value = ValueObjectImpl.VOID;
    private Class<?> type;

    NewElementHandler() {
    }

    @Override
    public void addAttribute(String string, String string2) {
        if (string.equals("class")) {
            this.type = this.getOwner().findClass(string2);
        } else {
            super.addAttribute(string, string2);
        }
    }

    @Override
    protected final void addArgument(Object object) {
        if (this.arguments == null) {
            throw new IllegalStateException("Could not add argument to evaluated element");
        }
        this.arguments.add(object);
    }

    @Override
    protected final Object getContextBean() {
        return this.type != null ? this.type : super.getContextBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ValueObject getValueObject() {
        if (this.arguments != null) {
            try {
                this.value = this.getValueObject(this.type, this.arguments.toArray());
            }
            catch (Exception exception) {
                this.getOwner().handleException(exception);
            }
            finally {
                this.arguments = null;
            }
        }
        return this.value;
    }

    ValueObject getValueObject(Class<?> clazz, Object[] objectArray) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("Class name is not set");
        }
        Class<?>[] classArray = NewElementHandler.getArgumentTypes(objectArray);
        Constructor<?> constructor = ConstructorFinder.findConstructor(clazz, classArray);
        if (constructor.isVarArgs()) {
            objectArray = NewElementHandler.getArguments(objectArray, constructor.getParameterTypes());
        }
        return ValueObjectImpl.create(constructor.newInstance(objectArray));
    }

    static Class<?>[] getArgumentTypes(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }

    static Object[] getArguments(Object[] objectArray, Class<?>[] classArray) {
        Class<?> clazz;
        int n = classArray.length - 1;
        if (classArray.length == objectArray.length) {
            Object object = objectArray[n];
            if (object == null) {
                return objectArray;
            }
            clazz = classArray[n];
            if (clazz.isAssignableFrom(object.getClass())) {
                return objectArray;
            }
        }
        int n2 = objectArray.length - n;
        clazz = classArray[n].getComponentType();
        Object object = Array.newInstance(clazz, n2);
        System.arraycopy(objectArray, n, object, 0, n2);
        Object[] objectArray2 = new Object[classArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        return objectArray2;
    }
}

