/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace.serial;

import com.sun.jmx.namespace.serial.RewritingProcessor;
import com.sun.jmx.namespace.serial.SerialRewritingProcessor;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultRewritingProcessor
extends RewritingProcessor {
    private final boolean identity;

    public DefaultRewritingProcessor(String string) {
        this(string, null);
    }

    public DefaultRewritingProcessor(String string, String string2) {
        super(new SerialRewritingProcessor(string, string2));
        this.identity = string.equals(string2);
    }

    private ObjectName rewriteObjectName(RewriteMode rewriteMode, ObjectName objectName) {
        return this.changeContext(rewriteMode, objectName);
    }

    private ObjectInstance rewriteObjectInstance(RewriteMode rewriteMode, ObjectInstance objectInstance) {
        ObjectName objectName = objectInstance.getObjectName();
        ObjectName objectName2 = this.changeContext(rewriteMode, objectName);
        if (objectName2 == objectName) {
            return objectInstance;
        }
        return new ObjectInstance(objectName2, objectInstance.getClassName());
    }

    private Object processObject(RewriteMode rewriteMode, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ObjectName) {
            return this.rewriteObjectName(rewriteMode, (ObjectName)object);
        }
        if (object instanceof ObjectInstance) {
            return this.rewriteObjectInstance(rewriteMode, (ObjectInstance)object);
        }
        return this.processAnyObject(rewriteMode, object);
    }

    private Object processAnyObject(RewriteMode rewriteMode, Object object) {
        switch (rewriteMode) {
            case INPUT: {
                return super.rewriteInput(object);
            }
            case OUTPUT: {
                return super.rewriteOutput(object);
            }
        }
        throw new AssertionError();
    }

    private ObjectName changeContext(RewriteMode rewriteMode, ObjectName objectName) {
        switch (rewriteMode) {
            case INPUT: {
                return this.toSourceContext(objectName);
            }
            case OUTPUT: {
                return this.toTargetContext(objectName);
            }
        }
        throw new AssertionError();
    }

    @Override
    public ObjectName toTargetContext(ObjectName objectName) {
        if (this.identity) {
            return objectName;
        }
        return super.toTargetContext(objectName);
    }

    @Override
    public ObjectName toSourceContext(ObjectName objectName) {
        if (this.identity) {
            return objectName;
        }
        return super.toSourceContext(objectName);
    }

    @Override
    public <T> T rewriteInput(T t) {
        if (this.identity) {
            return t;
        }
        return (T)this.processObject(RewriteMode.INPUT, t);
    }

    @Override
    public <T> T rewriteOutput(T t) {
        if (this.identity) {
            return t;
        }
        return (T)this.processObject(RewriteMode.OUTPUT, t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RewriteMode {
        INPUT,
        OUTPUT;

    }
}

