/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.rmid;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ExecOptionPermission
extends Permission {
    private transient boolean wildcard;
    private transient String name;
    private static final long serialVersionUID = 5842294756823092756L;

    public ExecOptionPermission(String string) {
        super(string);
        this.init(string);
    }

    public ExecOptionPermission(String string, String string2) {
        this(string);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ExecOptionPermission)) {
            return false;
        }
        ExecOptionPermission execOptionPermission = (ExecOptionPermission)permission;
        if (this.wildcard) {
            if (execOptionPermission.wildcard) {
                return execOptionPermission.name.startsWith(this.name);
            }
            return execOptionPermission.name.length() > this.name.length() && execOptionPermission.name.startsWith(this.name);
        }
        if (execOptionPermission.wildcard) {
            return false;
        }
        return this.name.equals(execOptionPermission.name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ExecOptionPermission execOptionPermission = (ExecOptionPermission)object;
        return this.getName().equals(execOptionPermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new ExecOptionPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }

    private void init(String string) {
        if (string == null) {
            throw new NullPointerException("name can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("name can't be empty");
        }
        if (string.endsWith(".*") || string.endsWith("=*") || string.equals("*")) {
            this.wildcard = true;
            this.name = string.length() == 1 ? "" : string.substring(0, string.length() - 1);
        } else {
            this.name = string;
        }
    }

    private static class ExecOptionPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private Hashtable permissions = new Hashtable(11);
        private boolean all_allowed = false;
        private static final long serialVersionUID = -1242475729790124375L;

        public void add(Permission permission) {
            if (!(permission instanceof ExecOptionPermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            ExecOptionPermission execOptionPermission = (ExecOptionPermission)permission;
            this.permissions.put(execOptionPermission.getName(), permission);
            if (!this.all_allowed && execOptionPermission.getName().equals("*")) {
                this.all_allowed = true;
            }
        }

        public boolean implies(Permission permission) {
            int n;
            if (!(permission instanceof ExecOptionPermission)) {
                return false;
            }
            ExecOptionPermission execOptionPermission = (ExecOptionPermission)permission;
            if (this.all_allowed) {
                return true;
            }
            String string = execOptionPermission.getName();
            Permission permission2 = (Permission)this.permissions.get(string);
            if (permission2 != null) {
                return permission2.implies(permission);
            }
            int n2 = string.length() - 1;
            while ((n = string.lastIndexOf(".", n2)) != -1) {
                permission2 = (Permission)this.permissions.get(string = string.substring(0, n + 1) + "*");
                if (permission2 != null) {
                    return permission2.implies(permission);
                }
                n2 = n - 1;
            }
            string = execOptionPermission.getName();
            n2 = string.length() - 1;
            while ((n = string.lastIndexOf("=", n2)) != -1) {
                permission2 = (Permission)this.permissions.get(string = string.substring(0, n + 1) + "*");
                if (permission2 != null) {
                    return permission2.implies(permission);
                }
                n2 = n - 1;
            }
            return false;
        }

        public Enumeration elements() {
            return this.permissions.elements();
        }
    }
}

