/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CardLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -4328196481005934313L;
    Vector vector = new Vector();
    int currentCard = 0;
    int hgap;
    int vgap;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("tab", Hashtable.class), new ObjectStreamField("hgap", Integer.TYPE), new ObjectStreamField("vgap", Integer.TYPE), new ObjectStreamField("vector", Vector.class), new ObjectStreamField("currentCard", Integer.TYPE)};

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object == null) {
                object = "";
            }
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
            }
            this.addLayoutComponent((String)object, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (!this.vector.isEmpty()) {
                component.setVisible(false);
            }
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!((Card)this.vector.get((int)i)).name.equals(string)) continue;
                ((Card)this.vector.get((int)i)).comp = component;
                return;
            }
            this.vector.add(new Card(string, component));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.vector.size(); ++i) {
                if (((Card)this.vector.get((int)i)).comp != component) continue;
                if (component.isVisible() && component.getParent() != null) {
                    this.next(component.getParent());
                }
                this.vector.remove(i);
                if (this.currentCard <= i) break;
                --this.currentCard;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            return new Dimension(insets.left + insets.right + n2 + this.hgap * 2, insets.top + insets.bottom + n3 + this.vgap * 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getMinimumSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            return new Dimension(insets.left + insets.right + n2 + this.hgap * 2, insets.top + insets.bottom + n3 + this.vgap * 2);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            Component component = null;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                component = container.getComponent(i);
                component.setBounds(this.hgap + insets.left, this.vgap + insets.top, container.width - (this.hgap * 2 + insets.left + insets.right), container.height - (this.vgap * 2 + insets.top + insets.bottom));
                if (!component.isVisible()) continue;
                bl = true;
            }
            if (!bl && n > 0) {
                container.getComponent(0).setVisible(true);
            }
        }
    }

    void checkLayout(Container container) {
        if (container.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for CardLayout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void first(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                component.setVisible(false);
                break;
            }
            if (n > 0) {
                this.currentCard = 0;
                container.getComponent(0).setVisible(true);
                container.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                component.setVisible(false);
                this.currentCard = (i + 1) % n;
                component = container.getComponent(this.currentCard);
                component.setVisible(true);
                container.validate();
                return;
            }
            this.showDefaultComponent(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previous(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                component.setVisible(false);
                this.currentCard = i > 0 ? i - 1 : n - 1;
                component = container.getComponent(this.currentCard);
                component.setVisible(true);
                container.validate();
                return;
            }
            this.showDefaultComponent(container);
        }
    }

    void showDefaultComponent(Container container) {
        if (container.getComponentCount() > 0) {
            this.currentCard = 0;
            container.getComponent(0).setVisible(true);
            container.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                component.setVisible(false);
                break;
            }
            if (n > 0) {
                this.currentCard = n - 1;
                container.getComponent(this.currentCard).setVisible(true);
                container.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Container container, String string) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            int n;
            this.checkLayout(container);
            Component component = null;
            int n2 = this.vector.size();
            for (n = 0; n < n2; ++n) {
                serializable = (Card)this.vector.get(n);
                if (!((Card)serializable).name.equals(string)) continue;
                component = ((Card)serializable).comp;
                this.currentCard = n;
                break;
            }
            if (component != null && !component.isVisible()) {
                n2 = container.getComponentCount();
                for (n = 0; n < n2; ++n) {
                    serializable = container.getComponent(n);
                    if (!((Component)serializable).isVisible()) continue;
                    ((Component)serializable).setVisible(false);
                    break;
                }
                component.setVisible(true);
                container.validate();
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.hgap = getField.get("hgap", 0);
        this.vgap = getField.get("vgap", 0);
        if (getField.defaulted("vector")) {
            Hashtable hashtable = (Hashtable)getField.get("tab", null);
            this.vector = new Vector();
            if (hashtable != null && !hashtable.isEmpty()) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Component component = (Component)hashtable.get(string);
                    this.vector.add(new Card(string, component));
                    if (!component.isVisible()) continue;
                    this.currentCard = this.vector.size() - 1;
                }
            }
        } else {
            this.vector = (Vector)getField.get("vector", null);
            this.currentCard = getField.get("currentCard", 0);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, Component> hashtable = new Hashtable<String, Component>();
        int n = this.vector.size();
        for (int i = 0; i < n; ++i) {
            Card card = (Card)this.vector.get(i);
            hashtable.put(card.name, card.comp);
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("hgap", this.hgap);
        putField.put("vgap", this.vgap);
        putField.put("vector", this.vector);
        putField.put("currentCard", this.currentCard);
        putField.put("tab", hashtable);
        objectOutputStream.writeFields();
    }

    class Card
    implements Serializable {
        static final long serialVersionUID = 6640330810709497518L;
        public String name;
        public Component comp;

        public Card(String string, Component component) {
            this.name = string;
            this.comp = component;
        }
    }
}

