/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    private final E[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int n) {
        return ++n == this.items.length ? 0 : n;
    }

    private void insert(E e) {
        this.items[this.putIndex] = e;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private E extract() {
        E[] EArray = this.items;
        E e = EArray[this.takeIndex];
        EArray[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return e;
    }

    void removeAt(int n) {
        E[] EArray = this.items;
        if (n == this.takeIndex) {
            EArray[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int n2;
            while ((n2 = this.inc(n)) != this.putIndex) {
                EArray[n] = EArray[n2];
                n = n2;
            }
            EArray[n] = null;
            this.putIndex = n;
        }
        --this.count;
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int n) {
        this(n, false);
    }

    public ArrayBlockingQueue(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public ArrayBlockingQueue(int n, boolean bl, Collection<? extends E> collection) {
        this(n, bl);
        if (n < collection.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock;
        block4: {
            if (e == null) {
                throw new NullPointerException();
            }
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                if (this.count != this.items.length) break block4;
                boolean bl = false;
                Object var5_5 = null;
                reentrantLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        this.insert(e);
        boolean bl = true;
        Object var5_6 = null;
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            try {
                while (this.count == EArray.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notFull.signal();
                throw interruptedException;
            }
            this.insert(e);
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean offer(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var5_4 = var4_3.toNanos(var2_2);
        var7_5 = this.lock;
        var7_5.lockInterruptibly();
        while (true) lbl-1000:
        // 2 sources

        {
            if (this.count == this.items.length) ** break block8
            this.insert(var1_1);
            var8_6 = true;
            var10_9 = null;
            var7_5.unlock();
            return var8_6;
            break;
        }
        catch (Throwable var9_12) {
            var10_11 = null;
            var7_5.unlock();
            throw var9_12;
        }
        {
            block9: {
                if (var5_4 > 0L) break block9;
                var8_7 = false;
                var10_10 = null;
                var7_5.unlock();
                return var8_7;
            }
            try {
                var5_4 = this.notFull.awaitNanos(var5_4);
                continue;
            }
            catch (InterruptedException var8_8) {
                this.notFull.signal();
                throw var8_8;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        E e;
        ReentrantLock reentrantLock;
        block3: {
            E e2;
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                if (this.count != 0) break block3;
                e2 = null;
                Object var5_4 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e2;
        }
        E e3 = e = this.extract();
        Object var5_5 = null;
        reentrantLock.unlock();
        return e3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e2;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            e = e2 = this.extract();
            Object var5_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        var4_3 = var3_2.toNanos(var1_1);
        var6_4 = this.lock;
        var6_4.lockInterruptibly();
        while (true) lbl-1000:
        // 2 sources

        {
            if (this.count == 0) break block7;
            var8_8 = var7_5 = this.extract();
            var10_9 = null;
            var6_4.unlock();
            break;
        }
        catch (Throwable var9_12) {
            var10_11 = null;
            var6_4.unlock();
            throw var9_12;
        }
        {
            block8: {
                block7: {
                    return var8_8;
                }
                if (var4_3 > 0L) break block8;
                var7_6 = null;
                var10_10 = null;
                var6_4.unlock();
                return var7_6;
            }
            try {
                var4_3 = this.notEmpty.awaitNanos(var4_3);
                continue;
            }
            catch (InterruptedException var7_7) {
                this.notEmpty.signal();
                throw var7_7;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            e = this.count == 0 ? null : (E)this.items[this.takeIndex];
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.items.length - this.count;
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            while (true) {
                if (n2++ >= this.count) {
                    boolean bl2 = false;
                    Object var8_8 = null;
                    reentrantLock.unlock();
                    return bl2;
                }
                if (object.equals(EArray[n])) {
                    this.removeAt(n);
                    bl = true;
                    break;
                }
                n = this.inc(n);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var8_9 = null;
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            while (n2++ < this.count) {
                if (object.equals(EArray[n])) {
                    boolean bl2 = true;
                    Object var8_8 = null;
                    reentrantLock.unlock();
                    return bl2;
                }
                n = this.inc(n);
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var8_9 = null;
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            int n2 = this.takeIndex;
            while (n < this.count) {
                objectArray[n++] = EArray[n2];
                n2 = this.inc(n2);
            }
            Object[] objectArray2 = objectArray;
            Object var8_7 = null;
            reentrantLock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            int n2 = this.takeIndex;
            while (n < this.count) {
                objectArray[n++] = EArray[n2];
                n2 = this.inc(n2);
            }
            if (objectArray.length > this.count) {
                objectArray[this.count] = null;
            }
            Object[] objectArray2 = objectArray;
            Object var8_7 = null;
            reentrantLock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            String string = super.toString();
            Object var4_3 = null;
            reentrantLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = this.count;
            while (n2-- > 0) {
                EArray[n] = null;
                n = this.inc(n);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            int n2 = this.takeIndex;
            int n3 = this.count;
            for (n = 0; n < n3; ++n) {
                collection.add(EArray[n2]);
                EArray[n2] = null;
                n2 = this.inc(n2);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n4 = n;
            Object var9_8 = null;
            reentrantLock.unlock();
            return n4;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            int n3;
            int n4 = this.takeIndex;
            int n5 = this.count;
            int n6 = n3 = n < this.count ? n : this.count;
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(EArray[n4]);
                EArray[n4] = null;
                n4 = this.inc(n4);
            }
            if (n2 > 0) {
                this.count -= n2;
                this.takeIndex = n4;
                this.notFull.signalAll();
            }
            int n7 = n2;
            Object var11_10 = null;
            reentrantLock.unlock();
            return n7;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Itr itr = new Itr();
            Object var4_3 = null;
            reentrantLock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private int nextIndex;
        private E nextItem;
        private int lastRet = -1;

        Itr() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                this.nextItem = ArrayBlockingQueue.this.items[ArrayBlockingQueue.this.takeIndex];
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == ArrayBlockingQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ArrayBlockingQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object e;
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object e2 = this.nextItem;
                this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex);
                this.checkNext();
                e = e2;
                Object var5_4 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                int n = this.lastRet;
                if (n == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int n2 = ArrayBlockingQueue.this.takeIndex;
                ArrayBlockingQueue.this.removeAt(n);
                this.nextIndex = n == n2 ? ArrayBlockingQueue.this.takeIndex : n;
                this.checkNext();
                Object var5_4 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }
}

