/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.beans.ConstructorProperties;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class BoxLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private int axis;
    private Container target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private transient PrintStream dbg;

    @ConstructorProperties(value={"target", "axis"})
    public BoxLayout(Container container, int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        this.axis = n;
        this.target = container;
    }

    BoxLayout(Container container, int n, PrintStream printStream) {
        this(container, n);
        this.dbg = printStream;
    }

    public final Container getTarget() {
        return this.target;
    }

    public final int getAxis() {
        return this.axis;
    }

    public synchronized void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    public void addLayoutComponent(String string, Component component) {
        this.invalidateLayout(component.getParent());
    }

    public void removeLayoutComponent(Component component) {
        this.invalidateLayout(component.getParent());
    }

    public void addLayoutComponent(Component component, Object object) {
        this.invalidateLayout(component.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    public synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Component component;
        int n;
        this.checkContainer(container);
        int n2 = container.getComponentCount();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        int n3 = this.resolveAxis(this.axis, componentOrientation);
        boolean bl = n3 != this.axis ? componentOrientation.isLeftToRight() : true;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            this.checkRequests();
            if (n3 == 0) {
                SizeRequirements.calculateTiledPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2, bl);
                SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
            } else {
                SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2, bl);
                SizeRequirements.calculateTiledPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
            }
        }
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            component.setBounds((int)Math.min((long)insets.left + (long)nArray[n], Integer.MAX_VALUE), (int)Math.min((long)insets.top + (long)nArray3[n], Integer.MAX_VALUE), nArray2[n], nArray4[n]);
        }
        if (this.dbg != null) {
            for (n = 0; n < n2; ++n) {
                component = container.getComponent(n);
                this.dbg.println(component.toString());
                this.dbg.println("X: " + this.xChildren[n]);
                this.dbg.println("Y: " + this.yChildren[n]);
            }
        }
    }

    void checkContainer(Container container) {
        if (this.target != container) {
            throw new AWTError("BoxLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n;
            int n2 = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n2];
            this.yChildren = new SizeRequirements[n2];
            for (n = 0; n < n2; ++n) {
                Component component = this.target.getComponent(n);
                if (!component.isVisible()) {
                    this.xChildren[n] = new SizeRequirements(0, 0, 0, component.getAlignmentX());
                    this.yChildren[n] = new SizeRequirements(0, 0, 0, component.getAlignmentY());
                    continue;
                }
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component.getMaximumSize();
                this.xChildren[n] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, component.getAlignmentX());
                this.yChildren[n] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, component.getAlignmentY());
            }
            n = this.resolveAxis(this.axis, this.target.getComponentOrientation());
            if (n == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    private int resolveAxis(int n, ComponentOrientation componentOrientation) {
        int n2 = n == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n);
        return n2;
    }
}

