/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "SliderUI";
    private boolean paintTicks = false;
    private boolean paintTrack = true;
    private boolean paintLabels = false;
    private boolean isInverted = false;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks = false;
    boolean snapToValue = true;
    protected int orientation;
    private Dictionary labelTable;
    protected ChangeListener changeListener = this.createChangeListener();
    protected transient ChangeEvent changeEvent = null;

    private void checkOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int n) {
        this(n, 0, 100, 50);
    }

    public JSlider(int n, int n2) {
        this(0, n, n2, (n + n2) / 2);
    }

    public JSlider(int n, int n2, int n3) {
        this(0, n, n2, n3);
    }

    public JSlider(int n, int n2, int n3, int n4) {
        this.checkOrientation(n);
        this.orientation = n;
        this.setModel(new DefaultBoundedRangeModel(n4, 0, n2, n3));
        this.updateUI();
    }

    public JSlider(BoundedRangeModel boundedRangeModel) {
        this.orientation = 0;
        this.setModel(boundedRangeModel);
        this.updateUI();
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI sliderUI) {
        super.setUI(sliderUI);
    }

    public void updateUI() {
        this.setUI((SliderUI)UIManager.getUI(this));
        this.updateLabelUIs();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel2 != null) {
            boundedRangeModel2.removeChangeListener(this.changeListener);
        }
        this.sliderModel = boundedRangeModel;
        if (boundedRangeModel != null) {
            boundedRangeModel.addChangeListener(this.changeListener);
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : Integer.valueOf(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : Integer.valueOf(boundedRangeModel.getValue()));
        }
        this.firePropertyChange("model", boundedRangeModel2, this.sliderModel);
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        if (n2 == n) {
            return;
        }
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n2, boundedRangeModel.getValue());
        }
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(int n) {
        int n2 = this.getModel().getMinimum();
        this.getModel().setMinimum(n);
        this.firePropertyChange("minimum", (Object)n2, (Object)n);
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setMaximum(int n) {
        int n2 = this.getModel().getMaximum();
        this.getModel().setMaximum(n);
        this.firePropertyChange("maximum", (Object)n2, (Object)n);
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean bl) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl2 = boundedRangeModel.getValueIsAdjusting();
        boundedRangeModel.setValueIsAdjusting(bl);
        if (bl2 != bl && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.BUSY : null, bl ? AccessibleState.BUSY : null);
        }
    }

    public int getExtent() {
        return this.getModel().getExtent();
    }

    public void setExtent(int n) {
        this.getModel().setExtent(n);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = this.orientation;
        this.orientation = n;
        this.firePropertyChange("orientation", n2, n);
        if (n2 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (n != n2) {
            this.revalidate();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateLabelSizes();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (!this.isShowing()) {
            return false;
        }
        Enumeration enumeration = this.labelTable.elements();
        while (enumeration.hasMoreElements()) {
            JLabel jLabel;
            Component component = (Component)enumeration.nextElement();
            if (!(component instanceof JLabel) || !SwingUtilities.doesIconReferenceImage((jLabel = (JLabel)component).getIcon(), image) && !SwingUtilities.doesIconReferenceImage(jLabel.getDisabledIcon(), image)) continue;
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }
        return false;
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary dictionary) {
        Dictionary dictionary2 = this.labelTable;
        this.labelTable = dictionary;
        this.updateLabelUIs();
        this.firePropertyChange("labelTable", dictionary2, this.labelTable);
        if (dictionary != dictionary2) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void updateLabelUIs() {
        Dictionary dictionary = this.getLabelTable();
        if (dictionary == null) {
            return;
        }
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            JComponent jComponent = (JComponent)dictionary.get(enumeration.nextElement());
            jComponent.updateUI();
            jComponent.setSize(jComponent.getPreferredSize());
        }
    }

    private void updateLabelSizes() {
        Dictionary dictionary = this.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                JComponent jComponent = (JComponent)enumeration.nextElement();
                jComponent.setSize(jComponent.getPreferredSize());
            }
        }
    }

    public Hashtable createStandardLabels(int n) {
        return this.createStandardLabels(n, this.getMinimum());
    }

    public Hashtable createStandardLabels(int n, int n2) {
        if (n2 > this.getMaximum() || n2 < this.getMinimum()) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Label incremement must be > 0");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SmartHashtable
        extends Hashtable<Object, Object>
        implements PropertyChangeListener {
            int increment = 0;
            int start = 0;
            boolean startAtMin = false;

            public SmartHashtable(int n, int n2) {
                this.increment = n;
                this.start = n2;
                this.startAtMin = n2 == JSlider.this.getMinimum();
                this.createLabels();
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("minimum") && this.startAtMin) {
                    this.start = JSlider.this.getMinimum();
                }
                if (propertyChangeEvent.getPropertyName().equals("minimum") || propertyChangeEvent.getPropertyName().equals("maximum")) {
                    Object k;
                    Enumeration enumeration = JSlider.this.getLabelTable().keys();
                    Hashtable hashtable = new Hashtable();
                    while (enumeration.hasMoreElements()) {
                        k = enumeration.nextElement();
                        Object v = JSlider.this.labelTable.get(k);
                        if (v instanceof 1SmartHashtable.LabelUIResource) continue;
                        hashtable.put(k, v);
                    }
                    this.clear();
                    this.createLabels();
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        k = enumeration.nextElement();
                        this.put(k, hashtable.get(k));
                    }
                    ((JSlider)propertyChangeEvent.getSource()).setLabelTable(this);
                }
            }

            void createLabels() {
                for (int i = this.start; i <= JSlider.this.getMaximum(); i += this.increment) {
                    this.put(i, new 1SmartHashtable.LabelUIResource("" + i, 0));
                }
            }

            class 1SmartHashtable.LabelUIResource
            extends JLabel
            implements UIResource {
                public 1SmartHashtable.LabelUIResource(String string, int n) {
                    super(string, n);
                    this.setName("Slider.label");
                }

                public Font getFont() {
                    Font font = super.getFont();
                    if (font != null && !(font instanceof UIResource)) {
                        return font;
                    }
                    return JSlider.this.getFont();
                }

                public Color getForeground() {
                    Color color = super.getForeground();
                    if (color != null && !(color instanceof UIResource)) {
                        return color;
                    }
                    if (!(JSlider.this.getForeground() instanceof UIResource)) {
                        return JSlider.this.getForeground();
                    }
                    return color;
                }
            }
        }
        SmartHashtable smartHashtable = new SmartHashtable(n, n2);
        Dictionary dictionary = this.getLabelTable();
        if (dictionary != null && dictionary instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)dictionary));
        }
        this.addPropertyChangeListener(smartHashtable);
        return smartHashtable;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        boolean bl2 = this.isInverted;
        this.isInverted = bl;
        this.firePropertyChange("inverted", bl2, this.isInverted);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int n) {
        int n2 = this.majorTickSpacing;
        this.majorTickSpacing = n;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0 && this.getPaintLabels()) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("majorTickSpacing", n2, this.majorTickSpacing);
        if (this.majorTickSpacing != n2 && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int n) {
        int n2 = this.minorTickSpacing;
        this.minorTickSpacing = n;
        this.firePropertyChange("minorTickSpacing", n2, this.minorTickSpacing);
        if (this.minorTickSpacing != n2 && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    boolean getSnapToValue() {
        return this.snapToValue;
    }

    public void setSnapToTicks(boolean bl) {
        boolean bl2 = this.snapToTicks;
        this.snapToTicks = bl;
        this.firePropertyChange("snapToTicks", bl2, this.snapToTicks);
    }

    void setSnapToValue(boolean bl) {
        boolean bl2 = this.snapToValue;
        this.snapToValue = bl;
        this.firePropertyChange("snapToValue", bl2, this.snapToValue);
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean bl) {
        boolean bl2 = this.paintTicks;
        this.paintTicks = bl;
        this.firePropertyChange("paintTicks", bl2, this.paintTicks);
        if (this.paintTicks != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean bl) {
        boolean bl2 = this.paintTrack;
        this.paintTrack = bl;
        this.firePropertyChange("paintTrack", bl2, this.paintTrack);
        if (this.paintTrack != bl2) {
            this.repaint();
        }
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean bl) {
        boolean bl2 = this.paintLabels;
        this.paintLabels = bl;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("paintLabels", bl2, this.paintLabels);
        if (this.paintLabels != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.paintTicks ? "true" : "false";
        String string2 = this.paintTrack ? "true" : "false";
        String string3 = this.paintLabels ? "true" : "false";
        String string4 = this.isInverted ? "true" : "false";
        String string5 = this.snapToTicks ? "true" : "false";
        String string6 = this.snapToValue ? "true" : "false";
        String string7 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",isInverted=" + string4 + ",majorTickSpacing=" + this.majorTickSpacing + ",minorTickSpacing=" + this.minorTickSpacing + ",orientation=" + string7 + ",paintLabels=" + string3 + ",paintTicks=" + string + ",paintTrack=" + string2 + ",snapToTicks=" + string5 + ",snapToValue=" + string6;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJSlider() {
            super(JSlider.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JSlider.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JSlider.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return JSlider.this.getValue();
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            JSlider.this.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return JSlider.this.getMinimum();
        }

        public Number getMaximumAccessibleValue() {
            BoundedRangeModel boundedRangeModel = JSlider.this.getModel();
            return boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider.this.fireStateChanged();
        }
    }
}

