/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.EditableView;
import javax.swing.text.html.HTML;

class HiddenTagView
extends EditableView
implements DocumentListener {
    float yAlign = 1.0f;
    boolean isSettingAttributes;
    static final int circleR = 3;
    static final int circleD = 6;
    static final int tagSize = 6;
    static final int padding = 3;
    static final Color UnknownTagBorderColor = Color.black;
    static final Border StartBorder = new StartTagBorder();
    static final Border EndBorder = new EndTagBorder();

    HiddenTagView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        Font font;
        JTextField jTextField = new JTextField(this.getElement().getName());
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            font = ((StyledDocument)document).getFont(this.getAttributes());
            jTextField.setFont(font);
        } else {
            font = jTextField.getFont();
        }
        jTextField.getDocument().addDocumentListener(this);
        this.updateYAlign(font);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(null);
        if (this.isEndTag()) {
            jPanel.setBorder(EndBorder);
        } else {
            jPanel.setBorder(StartBorder);
        }
        jPanel.add(jTextField);
        return jPanel;
    }

    public float getAlignment(int n) {
        if (n == 1) {
            return this.yAlign;
        }
        return 0.5f;
    }

    public float getMinimumSpan(int n) {
        if (n == 0 && this.isVisible()) {
            return Math.max(30.0f, super.getPreferredSpan(n));
        }
        return super.getMinimumSpan(n);
    }

    public float getPreferredSpan(int n) {
        if (n == 0 && this.isVisible()) {
            return Math.max(30.0f, super.getPreferredSpan(n));
        }
        return super.getPreferredSpan(n);
    }

    public float getMaximumSpan(int n) {
        if (n == 0 && this.isVisible()) {
            return Math.max(30.0f, super.getMaximumSpan(n));
        }
        return super.getMaximumSpan(n);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateModelFromText();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateModelFromText();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateModelFromText();
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (!this.isSettingAttributes) {
            this.setTextFromModel();
        }
    }

    void updateYAlign(Font font) {
        Container container = this.getContainer();
        FontMetrics fontMetrics = container != null ? container.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        float f = fontMetrics.getHeight();
        float f2 = fontMetrics.getDescent();
        this.yAlign = f > 0.0f ? (f - f2) / f : 0.0f;
    }

    void resetBorder() {
        Component component = this.getComponent();
        if (component != null) {
            if (this.isEndTag()) {
                ((JPanel)component).setBorder(EndBorder);
            } else {
                ((JPanel)component).setBorder(StartBorder);
            }
        }
    }

    void setTextFromModel() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._setTextFromModel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HiddenTagView.this._setTextFromModel();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setTextFromModel() {
        Document document = this.getDocument();
        try {
            JTextComponent jTextComponent;
            this.isSettingAttributes = true;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            if ((jTextComponent = this.getTextComponent()) != null) {
                jTextComponent.setText(this.getRepresentedText());
                this.resetBorder();
                Container container = this.getContainer();
                if (container != null) {
                    this.preferenceChanged(this, true, true);
                    container.repaint();
                }
            }
            Object var5_4 = null;
            this.isSettingAttributes = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.isSettingAttributes = false;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
    }

    void updateModelFromText() {
        if (!this.isSettingAttributes) {
            if (SwingUtilities.isEventDispatchThread()) {
                this._updateModelFromText();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HiddenTagView.this._updateModelFromText();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _updateModelFromText() {
        Document document = this.getDocument();
        Object object = this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.UnknownTag && document instanceof StyledDocument) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            JTextComponent jTextComponent = this.getTextComponent();
            if (jTextComponent != null) {
                String string = jTextComponent.getText();
                this.isSettingAttributes = true;
                try {
                    simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, new HTML.UnknownTag(string));
                    ((StyledDocument)document).setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), simpleAttributeSet, false);
                    Object var7_6 = null;
                    this.isSettingAttributes = false;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.isSettingAttributes = false;
                    throw throwable;
                }
            }
        }
    }

    JTextComponent getTextComponent() {
        Component component = this.getComponent();
        return component == null ? null : (JTextComponent)((Container)component).getComponent(0);
    }

    String getRepresentedText() {
        String string = this.getElement().getName();
        return string == null ? "" : string;
    }

    boolean isEndTag() {
        Object object;
        AttributeSet attributeSet = this.getElement().getAttributes();
        return attributeSet != null && (object = attributeSet.getAttribute(HTML.Attribute.ENDTAG)) != null && object instanceof String && ((String)object).equals("true");
    }

    static class EndTagBorder
    implements Border,
    Serializable {
        EndTagBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UnknownTagBorderColor);
            graphics.drawLine((n += 3) + (n3 -= 6) - 1, n2 + 3, n + n3 - 1, n2 + n4 - 3);
            graphics.drawArc(n + n3 - 6 - 1, n2 + n4 - 6 - 1, 6, 6, 270, 90);
            graphics.drawArc(n + n3 - 6 - 1, n2, 6, 6, 0, 90);
            graphics.drawLine(n + 6, n2, n + n3 - 3, n2);
            graphics.drawLine(n + 6, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
            graphics.drawLine(n + 6, n2, n, n2 + n4 / 2);
            graphics.drawLine(n + 6, n2 + n4, n, n2 + n4 / 2);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 11, 2, 5);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    static class StartTagBorder
    implements Border,
    Serializable {
        StartTagBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UnknownTagBorderColor);
            graphics.drawLine(n += 3, n2 + 3, n, n2 + n4 - 3);
            graphics.drawArc(n, n2 + n4 - 6 - 1, 6, 6, 180, 90);
            graphics.drawArc(n, n2, 6, 6, 90, 90);
            graphics.drawLine(n + 3, n2, n + (n3 -= 6) - 6, n2);
            graphics.drawLine(n + 3, n2 + n4 - 1, n + n3 - 6, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 6, n2, n + n3 - 1, n2 + n4 / 2);
            graphics.drawLine(n + n3 - 6, n2 + n4, n + n3 - 1, n2 + n4 / 2);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 5, 2, 11);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

