/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAEncTSEnc;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbAsReq
extends KrbKdcReq {
    private PrincipalName princName;
    private ASReq asReqMessg;
    private boolean DEBUG = Krb5.DEBUG;
    private static KDCOptions defaultKDCOptions = new KDCOptions();
    private boolean PA_ENC_TIMESTAMP_REQUIRED = false;
    private boolean pa_exists = false;
    private int pa_etype = 0;
    private byte[] pa_salt = null;
    private byte[] pa_s2kparams = null;
    private boolean KDC_EMPTY_ADDRESSES_ALLOWED = true;

    KrbAsReq(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws KrbException, IOException {
        this(encryptionKeyArray, false, 0, null, null, defaultKDCOptions, principalName, null, null, null, null, null, null, null);
    }

    KrbAsReq(PrincipalName principalName, EncryptionKey[] encryptionKeyArray, boolean bl, int n, byte[] byArray, byte[] byArray2) throws KrbException, IOException {
        this(encryptionKeyArray, bl, n, byArray, byArray2, defaultKDCOptions, principalName, null, null, null, null, null, null, null);
    }

    private static int[] getETypesFromKeys(EncryptionKey[] encryptionKeyArray) {
        int[] nArray = new int[encryptionKeyArray.length];
        for (int i = 0; i < encryptionKeyArray.length; ++i) {
            nArray[i] = encryptionKeyArray[i].getEType();
        }
        return nArray;
    }

    public void updatePA(int n, byte[] byArray, byte[] byArray2, PrincipalName principalName) {
        this.pa_exists = true;
        this.pa_etype = n;
        this.pa_salt = byArray;
        this.pa_s2kparams = byArray2;
        if (byArray != null && byArray.length > 0) {
            String string = new String(byArray);
            principalName.setSalt(string);
            if (this.DEBUG) {
                System.out.println("Updated salt from pre-auth = " + principalName.getSalt());
            }
        }
        this.PA_ENC_TIMESTAMP_REQUIRED = true;
    }

    public KrbAsReq(char[] cArray, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        this(cArray, false, 0, null, null, kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbAsReq(char[] cArray, boolean bl, int n, byte[] byArray, byte[] byArray2, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        EncryptionKey[] encryptionKeyArray = null;
        if (bl) {
            this.updatePA(n, byArray, byArray2, principalName);
        }
        if (cArray != null) {
            encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, principalName.getSalt(), bl, this.pa_etype, this.pa_s2kparams);
        }
        if (this.DEBUG) {
            System.out.println(">>>KrbAsReq salt is " + principalName.getSalt());
        }
        try {
            this.init(encryptionKeyArray, kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
        }
        finally {
            if (encryptionKeyArray != null) {
                for (int i = 0; i < encryptionKeyArray.length; ++i) {
                    encryptionKeyArray[i].destroy();
                }
            }
        }
    }

    public KrbAsReq(EncryptionKey[] encryptionKeyArray, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        this(encryptionKeyArray, false, 0, null, null, kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
    }

    public KrbAsReq(EncryptionKey[] encryptionKeyArray, boolean bl, int n, byte[] byArray, byte[] byArray2, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        if (bl) {
            this.updatePA(n, byArray, byArray2, principalName);
            if (this.DEBUG) {
                System.out.println(">>>KrbAsReq salt is " + principalName.getSalt());
            }
        }
        this.init(encryptionKeyArray, kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
    }

    private void init(EncryptionKey[] encryptionKeyArray, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        if (kDCOptions.get(2) || kDCOptions.get(4) || kDCOptions.get(28) || kDCOptions.get(30) || kDCOptions.get(31)) {
            throw new KrbException(101);
        }
        if (!kDCOptions.get(6) && kerberosTime != null) {
            kerberosTime = null;
        }
        if (!kDCOptions.get(8) && kerberosTime3 != null) {
            kerberosTime3 = null;
        }
        this.princName = principalName;
        EncryptionKey encryptionKey = null;
        int[] nArray2 = null;
        if (this.pa_exists && this.pa_etype != 0) {
            if (this.DEBUG) {
                System.out.println("Pre-Authenticaton: find key for etype = " + this.pa_etype);
            }
            encryptionKey = EncryptionKey.findKey(this.pa_etype, encryptionKeyArray);
            nArray2 = new int[]{this.pa_etype};
        } else {
            nArray2 = EType.getDefaults("default_tkt_enctypes", encryptionKeyArray);
            encryptionKey = EncryptionKey.findKey(nArray2[0], encryptionKeyArray);
        }
        PAData[] pADataArray = null;
        if (this.PA_ENC_TIMESTAMP_REQUIRED) {
            if (this.DEBUG) {
                System.out.println("AS-REQ: Add PA_ENC_TIMESTAMP now");
            }
            PAEncTSEnc pAEncTSEnc = new PAEncTSEnc();
            byte[] byArray = pAEncTSEnc.asn1Encode();
            if (encryptionKey != null) {
                EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, 1);
                pADataArray = new PAData[]{new PAData(2, encryptedData.asn1Encode())};
            }
        }
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq calling createMessage");
        }
        if (nArray == null) {
            nArray = nArray2;
        }
        if (Config.getInstance().useAddresses()) {
            this.KDC_EMPTY_ADDRESSES_ALLOWED = false;
        }
        if (hostAddresses == null && !this.KDC_EMPTY_ADDRESSES_ALLOWED) {
            hostAddresses = HostAddresses.getLocalAddresses();
        }
        this.asReqMessg = this.createMessage(pADataArray, kDCOptions, principalName, principalName.getRealm(), principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
        this.obuf = this.asReqMessg.asn1Encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbAsRep getReply(char[] cArray) throws KrbException, IOException {
        if (cArray == null) {
            throw new KrbException(400);
        }
        KrbAsRep krbAsRep = null;
        EncryptionKey[] encryptionKeyArray = null;
        try {
            encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, this.princName.getSalt(), this.pa_exists, this.pa_etype, this.pa_s2kparams);
            krbAsRep = this.getReply(encryptionKeyArray);
        }
        finally {
            if (encryptionKeyArray != null) {
                for (int i = 0; i < encryptionKeyArray.length; ++i) {
                    encryptionKeyArray[i].destroy();
                }
            }
        }
        return krbAsRep;
    }

    public String send() throws IOException, KrbException {
        String string = null;
        if (this.princName != null) {
            string = this.princName.getRealmString();
        }
        return this.send(string);
    }

    public KrbAsRep getReply(EncryptionKey[] encryptionKeyArray) throws KrbException, IOException {
        return new KrbAsRep(this.ibuf, encryptionKeyArray, this);
    }

    private ASReq createMessage(PAData[] pADataArray, KDCOptions kDCOptions, PrincipalName principalName, Realm realm, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws Asn1Exception, KrbApErrException, RealmException, UnknownHostException, IOException {
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq in createMessage");
        }
        PrincipalName principalName3 = null;
        if (principalName2 == null) {
            if (realm == null) {
                throw new RealmException(601, "default realm not specified ");
            }
            principalName3 = new PrincipalName("krbtgt/" + realm.toString(), 2);
        } else {
            principalName3 = principalName2;
        }
        KerberosTime kerberosTime4 = null;
        kerberosTime4 = kerberosTime2 == null ? new KerberosTime() : kerberosTime2;
        KDCReqBody kDCReqBody = new KDCReqBody(kDCOptions, principalName, realm, principalName3, kerberosTime, kerberosTime4, kerberosTime3, Nonce.value(), nArray, hostAddresses, null, ticketArray);
        return new ASReq(pADataArray, kDCReqBody);
    }

    ASReq getMessage() {
        return this.asReqMessg;
    }
}

