Contributing to CVC4 for SPARK 2014
===================================

This repository is specific to SPARK 2014. We suggest you submit your
contributions to the development of CVC4 to the [official
repository](https://github.com/CVC4/CVC4).

Original content of Contributing
=================================

# Contributing

External contributions to cvc5 may be proposed using git's standard pull request
mechanism.  The following terms apply to all such contributions:

- We require all pull requests to be squashed into a single commit before
  being submitted and to be signed using `git commit -s`.

- cvc5 is distributed under the terms of the modified BSD license (see
  [COPYING](https://github.com/cvc5/cvc5/blob/main/COPYING) file).  By
  submitting a signed contribution, you automatically agree to accept the conditions
  described in [COPYING](https://github.com/cvc5/cvc5/blob/main/COPYING).

- By submitting a signed contribution, you additionally automatically agree
  that the [Developer Certificate of Origin](https://developercertificate.org)
  shown below applies to your contribution.

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
1 Letterman Drive
Suite D4700
San Francisco, CA, 94129

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.


Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```

If you are interested in becoming a long-term contributor to the cvc5 project,
please contact one of the
[project leaders](https://cvc5.github.io/people.html#project-leaders).
We'd be happy to point you to some internal documentation to help you out.
