# Changelog

## v0.3.0

- Added service files for OpenRC and systemd.
- When a local message is missing from the status database but has a UID hint
  in its filename, compare it to an existing remote message with the same UID.
  If it is identical, don't upload it and treat it as in-sync. This is an
  opportunistic check and should not be relied upon. If a message is detected
  on the remote side first and was not synchronised by ImapGoose, it will still
  be downloaded, potentially duplicating it if another copy existed locally.
- Implement a new "index" operation executed with the `-i` flag. See man page
  for details.
- Fix multiple flags (e.g.: `-mv`) not working.

## v0.2.4

- Don't echo password when prompted by the `capcheck` helper.
- Fix various issue handling files renamed due to flag changes:
  - When querying the status database, match files which share the same unique
    prefix, regardless of flags.
  - Each time flags are updated, record the new filename of the file.
  - Handle renamed files when resolving the absolute path of a message.

## v0.2.3

- Write new unseen messages into `/new` and others into `/cur`.
- Don't perform migrations with `-m` if reading from `stdin` fails.
- Fix various synchronisation bugs.
- Stop requesting unused ModSeq for each message.
- Preserve flags during concurrent edits. E.g.: if a flag is added to a message
  locally and another flag is change remotely, attempt to preserve both changes.

## v0.2.2

- Fix "database is locked" error in certain conditions.
- Fix bug when locking mailboxes to avoid concurrent worker access.
- Write new messages into the `/new` instead of `/cur` subdirectory of a
  Maildir.

## v0.2.1

- Fix local maildirs not being re-scanned for changes that happened while
  ImapGoose was not running.
- Stop requesting changes via IMAP when we receive a filesystem event, and stop
  scanning filesystem for changes when we receive an IMAP notification.
- Process file notification in batches, further improving performance.
- Properly scan nested Maildirs. Support for nested directories focused mostly
  on the IMAP side and didn't pick up changes which only occurred in the
  filesystem.
- Other minor fixes.

## v0.2.0

Treatment of nested mailboxes has changed. Previously, mailboxes from IMAP to
Maildir where mapped as:

    lists/mine -> lists.mine
    lists.mine -> lists.mine

This is problematic in case examples on the left exist. As of this version,
nested mailboxes are synchronised as such:

    lists/mine -> lists/mine
    lists.mine -> lists.mine

A one-time migration process must be executed to acomodate mailboxes into the
new layout and keep the status repository aligned with this change. To perform
this migration run `imapgoose -m`. The migration process merely moves
directories around and updates the status repository. It should only take a
second.

Minor changes in this release:

- Fixed mix-up in error message.
- Force termination of slow operations at shutdown.
