package sync

import imap2 "github.com/emersion/go-imap/v2"

// flagsEqual compares two flag slices for equality, ignoring ordering.
func flagsEqual(a, b []imap2.Flag) bool {
	if len(a) != len(b) {
		return false
	}

	// Create a map for efficient lookup.
	flagMap := make(map[imap2.Flag]bool)
	for _, f := range a {
		flagMap[f] = true
	}

	for _, f := range b {
		if !flagMap[f] {
			return false
		}
	}

	return true
}

// flagDifference returns flags in 'a' that are not in 'b'.
func flagDifference(a, b []imap2.Flag) []imap2.Flag {
	bMap := make(map[imap2.Flag]bool)
	for _, flag := range b {
		bMap[flag] = true
	}

	var diff []imap2.Flag
	for _, flag := range a {
		if !bMap[flag] {
			diff = append(diff, flag)
		}
	}
	return diff
}
