/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Classes that override equals should also override hashCode.", severity=BugPattern.SeverityLevel.ERROR, tags={"FragileCode"})
public class EqualsHashCode
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> NON_TRIVIAL_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.equalsMethodDeclaration(), Matchers.not((Matcher)Matchers.singleStatementReturnMatcher((Matcher)Matchers.instanceEqualsInvocation()))});

    public Description matchClass(ClassTree classTree, VisitorState state) {
        MethodTree methodTree = EqualsHashCode.checkMethodPresence(classTree, state);
        if (methodTree == null || this.isSuppressed(methodTree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree);
    }

    @Nullable
    private static MethodTree checkMethodPresence(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (((Symbol)symbol).getKind() != ElementKind.CLASS) {
            return null;
        }
        if (symbol == state.getSymtab().objectType.tsym) {
            return null;
        }
        MethodTree requiredMethod = null;
        for (Tree tree : classTree.getMembers()) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !NON_TRIVIAL_EQUALS.matches((Tree)(methodTree = (MethodTree)tree), state)) continue;
            requiredMethod = methodTree;
        }
        if (requiredMethod == null) {
            return null;
        }
        Symbol.MethodSymbol expectedMethodSym = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)symbol, (Name)state.getName("hashCode"), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
        if (!expectedMethodSym.owner.equals(state.getSymtab().objectType.tsym)) {
            return null;
        }
        return requiredMethod;
    }
}

