/*
 * Copyright (c) 2005 Jacob Meuser <jakemsr@jakemsr.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: bsdav_streams.c,v 1.2 2005/11/20 00:35:16 jakemsr Exp $
 */

#include "includes.h"

#include "bsdav.h"


int
bsdav_write_stream_header(FILE *file, struct bsdav_stream_header *strhdr)
{
	if (fprintf(file, BSDAV_STRHDR_SFMT, strhdr->tssec, strhdr->tsusec,
	    strhdr->vidfmt, strhdr->vidwth, strhdr->vidhgt, strhdr->vidmfs,
	    strhdr->audfmt, strhdr->audchn, strhdr->audsrt,
	    strhdr->audmfs) != BSDAV_STRHDR_SIZE)
		return(1);

	return(0);
}


int
bsdav_read_stream_header(FILE *file, struct bsdav_stream_header *strhdr)
{
	if (fscanf(file, BSDAV_STRHDR_SFMT, &strhdr->tssec, &strhdr->tsusec,
	    &strhdr->vidfmt, &strhdr->vidwth, &strhdr->vidhgt, &strhdr->vidmfs,
	    &strhdr->audfmt, &strhdr->audchn, &strhdr->audsrt,
	    &strhdr->audmfs) != BSDAV_STRHDR_NMEM)
		return(1);

	return(0);
}


void
bsdav_dump_stream_header(struct bsdav_stream_header *strhdr)
{
	printf("stream header:\n");
	printf("  start time sec = %ld\n", strhdr->tssec);
	printf("  start time usec = %ld\n", strhdr->tsusec);
	printf("  video format = %s\n", bsdav_vid_fmts[strhdr->vidfmt].name);
	printf("  video width = %d\n", strhdr->vidwth);
	printf("  video height = %d\n", strhdr->vidhgt);
	printf("  video max. frame size = %d\n", strhdr->vidmfs);
	printf("  audio format = %s\n", bsdav_aud_fmts[strhdr->audfmt].name);
	printf("  audio channels = %d\n", strhdr->audchn);
	printf("  audio sample rate = %d\n", strhdr->audsrt);
	printf("  audio max. frame size = %d\n", strhdr->audmfs);

	return;
}


long
bsdav_find_stream_header(FILE *file)
{
int found;
int d;

	found = 0;

	while (found == 0) {
		if (fgetc(file) == 'B') {
			if (fscanf(file, "SDAVSTR%016x", &d) == 1) {
				found = 1;
				fseek(file, -24, SEEK_CUR);
			}
		}
		if (feof(file))
			break;
	}

	if (found == 1)
		return(ftell(file));
	else
		return(-1);
}

