# $NetBSD: web.xml.mk,v 1.18 2020/06/29 12:29:34 rillig Exp $
#

# This file is included by web.site.mk, so you should not include it
# yourself. It provides a method for converting XML files in the DocBook
# webpage format into HTML documents.
#
# The following variables may be set in htdocs Makefiles:
#
# XMLDOCS
#	A list of XML document identifiers, which are usually the same
#	as the basename of the XML document.
#
#	Alternatively, such an identifier can be of the form
#	"docid:stylesheets:xml:target". This is syntactic sugar for
#	setting XSLTS.<docid>, XML.<docid> and TARGET.<docid>. If any of
#	the components is left empty, the default value (see below) is
#	used.
#
#	Note: Multiple stylesheets are separated by comma, not by
#	white-space.
#
#	Examples:
#		XMLDOCS+=	doc1
#		XMLDOCS+=	packages:pkgsrc-home.xsl::
#		XMLDOCS+=	developers:index.xsl,docbook-website::
#
# TARGET.<id>
#	The target filename. The default value is <id>.html.
#
#	Example:
#		TARGET.doc1=	document1.html
#
# XSLTS.<id>
#	List of the XSLT stylesheets. The first item is used for
#	processing the file, the others are added as dependencies.
#
# XSLT.<id>
#	Filename of the primary XSLT stylesheet. The default value is
#	<id>.xsl. The following keywords are interpreted specially:
#
#		docbook		- Norm Walsh's DocBook stylesheet
#		docbook-website	- Norm Walsh's Website stylesheet
#		xsl		- <id>.xsl
#
#	When a documents needs multiple style sheets, they can then be
#	given in a comma-separated list.
#
#	Examples:
#		XSLT.doc1=		doc1.xsl
#
# XML.<id>
#	Filename of the XML document. The default value is <id>.xml.
#	FIXME: Better explain this.
#
#	Example:
#		XML.doc1=	doc1.xml data.xml
#
# DEPENDS.<id>
#	Additional dependencies. The default value is the empty list.
#
#	Example:
#		DEPENDS.doc1=	includes.xsl
#
# PARAMS.<id>
#	Arguments passed to xsltproc(1).
#
#	Examples:
#		PARAMS.doc1=	--catalogs --nonet --xinclude
#		PARAMS.doc1=	--stringparam WEB_PREFIX ${WEB_PREFIX}
#
# XSLTPROCOPTS.<id>
#	Arguments passed to xsltproc(1) instead of the default
#	arguments.
#
#	No example available.
#
# XSLTPROC_ARGS
#	Arguments passed to all invocations of xsltproc(1).
#
#	Example:
#		XSLTPROC_ARGS+=	--stringparam l10n.gentext.language de
#

XML_CATALOG_FILES=	file://${WEB_PREFIX}/share/xml/catalog.xml
XML_CATALOG_FILES+=	file://${WEB_PREFIX}/share/xml/catalog-common.xml
.if defined(PKG_SYSCONFDIR.xmlcatmgr)
XML_CATALOG_FILES+=	file://${PKG_SYSCONFDIR.xmlcatmgr}/xml/catalog
.elif defined(PKG_SYSCONFBASE)
XML_CATALOG_FILES+=	file://${PKG_SYSCONFBASE}/xml/catalog
.else
XML_CATALOG_FILES+=	file://${LOCALBASE}/etc/xml/catalog
.endif

# backward compatibility

XSLFILE?=	${WEB_PREFIX}/share/xsl/netbsd-webpage-${DOCLANG}.xsl
XMLDEPS+=	${AUTOLAYOUTFILE}
XMLDEPS+=	${XSLFILE}
XMLDEPS+=	${WEB_PREFIX}/share/xsl/webpage.xsl
XMLDEPS+=	${WEB_PREFIX}/share/xsl/global.xsl


XSLTPROC_ENV+=	SGML_CATALOG_FILES=
XSLTPROC_ENV+=	XML_CATALOG_FILES="${XML_CATALOG_FILES}"

XSLTPROCOPTS=	${XSLTPROC_ARGS}
XSLTPROCOPTS+=	--xinclude
XSLTPROCOPTS+=	--stringparam LOCALBASE ${LOCALBASE}
XSLTPROCOPTS+=	--stringparam WEB_PREFIX ${WEB_PREFIX}
XSLTPROCOPTS+=	--stringparam reltopdir ${HTDOCS_RELTOPDIR}
.if defined(XML_CATALOG_FILES) && !empty(XML_CATALOG_FILES)
XSLTPROCOPTS+=	--nonet --catalogs
.endif
XSLTPROC_BIN?=	${PREFIX}/bin/xsltproc
XSLTPROC=	env ${XSLTPROC_ENV} ${XSLTPROC_BIN}

XMLLINTOPTS+=	--xinclude --valid --noout
.if defined(XML_CATALOG_FILES) && !empty(XML_CATALOG_FILES)
XMLLINTOPTS+=	--nonet --catalogs
.endif
XMLLINT=	env ${XSLTPROC_ENV} ${PREFIX}/bin/xmllint

ULIMIT?=	800000
.if ${ULIMIT} > 0
DO_ULIMIT=	ulimit -d ${ULIMIT} &&
.endif

.for doc in ${XMLDOCS}

# extract docid from "docid:xslt:xml:target".
.  for id in ${doc:C,:.*$,,}

.    if ${doc:C,[^:],,g} == ":::"
XSLTS.${id}=	${doc:C,^([^:]*):([^:]*):([^:]*):([^:]*)$,\2,:C|,| |g}
XML.${id}=	${doc:C,^([^:]*):([^:]*):([^:]*):([^:]*)$,\3,}
TARGET.${id}=	${doc:C,^([^:]*):([^:]*):([^:]*):([^:]*)$,\4,}

.    elif ${doc:C,[^:],,g} != ""
ERRORS+=	"[web.xml.mk] XMLDOCS.${id} must have exactly four components."
.    endif

.    if !defined(XSLTS.${id}) || empty(XSLT.${id})
XSLTS.${id}?=	docbook-website
.    endif

# Take the first XSLT from the list.
.    for xslt in ${XSLTS.${id}}
XSLT.${id}?=	${xslt}
.    endfor

# Use default value if parameter not specified or empty.
.    if !defined(XML.${id}) || empty(XML.${id})
XML.${id}=	${id}.xml
.    endif
.    if !defined(TARGET.${id}) || empty(TARGET.${id})
TARGET.${id}=	${id}.html
.    endif

XSLTPROCOPTS.${id}?=	${XSLTPROCOPTS}
GENDOCS+=		${TARGET.${id}}
CLEANFILES+=		${TARGET.${id}}

.    if ${XSLT.${id}} == docbook
XSLT.${id}=	http://www.NetBSD.org/XML/htdocs/lang/share/xsl/netbsd.xsl
.    elif ${XSLT.${id}} == docbook-website
XSLT.${id}=	http://www.NetBSD.org/XML/htdocs/lang/share/xsl/netbsd-webpage-${DOCLANG}.xsl
.    elif ${XSLT.${id}} == xsl
XSLT.${id}=	${id}.xsl
.    else
DEPENDS.${id}+=	${XSLT.${id}}
.    endif

# Additional dependencies.
#
XSLTS.${id}?=		# none
.    if !empty(XSLTS.${id}:Mdocbook)
DEPENDS.${id}+=	${WEB_PREFIX}/share/xsl/netbsd.xsl
.    endif
.    if !empty(XSLTS.${id}:Mdocbook-website)
DEPENDS.${id}+=	${AUTOLAYOUTFILE}
DEPENDS.${id}+=	${WEB_PREFIX}/share/xsl/webpage.xsl
XSLTPROCOPTS.${id}+=	--stringparam autolayout-file ${AUTOLAYOUTFILE}
.    endif
.    if !empty(XSLTS.${id}:Mxsl)
DEPENDS.${id}+=	${XSLT.${id}}
.    endif

DEPENDS.${id}+=	${WEB_PREFIX}/share/xsl/global.xsl
DEPENDS.${id}+=	${WEB_PREFIX}/share/xsl/portpage.xsl

${TARGET.${id}}: ${XML_INCLUDES} ${XML.${id}} ${DEPENDS.${id}}
	@${ECHO} "[xsltproc] ${XML.${id}} -> ${.TARGET}"
	${RUN} ${DO_ULIMIT} ${XSLTPROC} ${XSLTPROCOPTS.${id}}		\
		-o ${.TARGET} ${PARAMS.${id}}				\
		${XSLT.${id}} ${XML.${id}}
#. if !defined(NO_TIDY)
#	-${TIDY} ${TIDYOPTS} ${.TARGET}
#. endif

VALIDATE_DOCS+=	VALIDATE.${id}
VALIDATE.${id}:
	@${ECHO} "==>[xmllint] ${XML.${id}}"
	${RUN} ${XMLLINT} ${XMLLINTOPTS} ${XML.${id}} 2>&1		\
	| ${SED} -e 's/^/ | /'
.  endfor
.endfor
