# $NetBSD: doc.docbook.mk,v 1.54 2025/07/24 18:09:59 martin Exp $
#
# Generates various output formats for a documentation in DocBook format.
# This is completely independent from web.site.mk.
#
# Settable variables:
#
# DOC
#	The basename of the document to be generated.
#
# FORMATS
#	The list of desired output formats.
#
#	Possible: html html-split ascii epub ps pdf
#	Default: html-split
#
# Targets:
#	all ps pdf html html-split ascii epub
#	clean cleandir
#	install lint
#

# include default settings and /etc/mk.conf first
.include "web.prefs.mk"

LOCALBASE?=	/usr/pkg
.if exists(${LOCALBASE}/sbin/pkg_info)
PKG_INFO?=	${LOCALBASE}/sbin/pkg_info
.endif
PKG_INFO?=	/usr/sbin/pkg_info
PREFIX?=	${LOCALBASE}
SGML_PREFIX?=	${PREFIX}/share/sgml
XML_PREFIX?=	${PREFIX}/share/xml
XSL_PREFIX?=	${PREFIX}/share/xsl
XML_DECL?=	${SGML_PREFIX}/docbook/dsssl/modular/dtds/decls/xml.dcl
DBX_SGML_CATALOG?=	${SGML_PREFIX}/docbook/4.2/catalog
DBX_XML_CATALOG?=	${SGML_PREFIX}/docbook/4.2/catalog.xml
DBX_XML_DTD?=	${XML_PREFIX}/docbook/4.2/docbookx.dtd
DBX_XSL_HTML?=	${XSL_PREFIX}/docbook/html/docbook.xsl
DBX_XSL_HTMLCHUNK?=	${XSL_PREFIX}/docbook/html/chunk.xsl
REQPKGS_COMMON=	docbook>=4.0 docbook-xml>=4.0 opensp>=1.5
REQPKGS_XSL=	libxslt>=1.0.30 docbook-xsl>=1.62.4
REQPKGS_DSSSL=	openjade>=1.3.2 dsssl-docbook-modular>=1.54
REQPKGS_PRINT?=	tex-jadetex>=3.13 ghostscript>=7.05
REQPKGS_ASCII=	w3m>=0.4
.if defined(NO_TIDY) && empty(NO_TIDY:M[Yy][Ee][Ss])
REQPKGS_HTML=	tidy-[0-9]*
.endif
REQPKGS=	${REQPKGS_COMMON}
.BEGIN:
	@missing=""; \
	for dep in ${REQPKGS:S,<,\\<,:S,>,\\>,}; do \
		${PKG_INFO} -e "$$dep" > /dev/null 2>&1 \
		|| missing="$$missing $$dep"; \
	done; \
	[ "$$missing" ] || exit 0; \
	echo "===> ERROR: The following packages are missing for typesetting:"; \
	for dep in $$missing; do \
		echo "      - $$dep"; \
	done; \
	echo "  Make sure to install the latest package of meta-pkgs/netbsd-doc"; \
	echo "  and meta-pkgs/netbsd-www via pkgsrc. For printable formats,"; \
	echo "  meta-pkgs/netbsd-doc-print is needed."; \
	exit 1

.if exists(${.CURDIR}/share/catalog)
CATALOGS+=	${.CURDIR}/share/catalog
.endif
CATALOGS+=	${WEB_PREFIX}/share/xml/catalog
CATALOGS+=	${SGML_PREFIX}/catalog
CATALOGS+=	${SGML_PREFIX}/docbook/dsssl/modular/catalog
CATALOGS+=	${DBX_SGML_CATALOG}

XML_CATALOGS=	${XML_CATALOG_FILES}

XML_CATALOG_FILES=	file://${WEB_PREFIX}/${DOCLANG}/share/xml/catalog.xml \
			file://${WEB_PREFIX}/share/xml/catalog.xml \
			file://${WEB_PREFIX}/share/xml/catalog-common.xml
.if defined(PKG_SYSCONFDIR.xmlcatmgr)
XML_CATALOG_FILES+=	file://${PKG_SYSCONFDIR.xmlcatmgr}/xml/catalog
.elif defined(PKG_SYSCONFBASE)
XML_CATALOG_FILES+=	file://${PKG_SYSCONFBASE}/xml/catalog
.else
XML_CATALOG_FILES+=	file://${LOCALBASE}/etc/xml/catalog
.endif

DOCLANG?=	en

XML_ENCODING?=	utf-8
SP_ENCODING?=	utf-8
SX_ENCODING?=	utf-8

SED?=		/usr/bin/sed
CAT?=		/bin/cat

PS2PDF?=	${PREFIX}/bin/ps2pdf
DVIPS?=		${PREFIX}/bin/dvips

W3M_BIN?=	${PREFIX}/bin/w3m
W3M_OPTS=	-config /dev/null -dump ${XML_ENCODING:S/^/-O /} -no-graph ${W3M_FLAGS}
W3M=		${W3M_BIN} ${W3M_OPTS}

TIDY_BIN?=	${PREFIX}/bin/tidy
TIDY_OPTS?=	-i -m -f /dev/null -asxml ${TIDYFLAGS}
TIDY?=		env HTML_TIDY=/dev/null ${TIDY_BIN} ${TIDY_OPTS} ${TIDY_FLAGS}

MANIFEST?=	HTML.manifest
HTML_INDEX?=	index.html

DOCBOOKCSS=	${WEB_PREFIX}/share/xml/docbook.css

WEB_PREFIX_RELATIVE=	${.CURDIR:tA:S,^${WEB_PREFIX:tA}/,,:C,.[^/]+/?,../,g:S,/$,,}

CLEANFILES+=	${MANIFEST}
CLEANFILES+=	${SXERR}

.MAIN: all

all ps pdf html html-split ascii epub: build

.if make(html)
FORMATS?=	html
.elif make(html-split)
FORMATS?=	html-split
.elif make(ps)
FORMATS?=	ps
.elif make(pdf)
FORMATS?=	pdf
.elif make(ascii)
FORMATS?=	ascii
.elif make(epub)
FORMATS?=	epub
.endif
FORMATS?=	html-split

build: ${FORMATS:@f@build-${f}@}

build-html: ${DOC}.html
build-html-split: ${HTML_INDEX}
build-ps: ${DOC}.ps
build-pdf: ${DOC}.pdf
build-ascii: ${DOC}.txt
build-epub: ${DOC}.epub

clean:
	if [ -r ${MANIFEST} ]; then rm -f `cat ${MANIFEST}`; fi
	rm -f ${CLEANFILES}

cleandir: clean
	rm -f default-chunk.xml default.xml
	rm -f *~ core *.core *.rtf *.html *.fot *.log
	rm -f *.aux *.dvi *.tex *.out *.ps *.pdf *.txt *.epub

.SUFFIXES:
.SUFFIXES: .tex .xml .sgml .html .rtf .ps .pdf .txt .epub

.PHONY: all clean cleandir install lint
.PHONY: html html-split ps pdf ascii epub
.PHONY: build-html build-ps build-pdf build-ascii build-epub

.include <bsd.obj.mk>
.include "doc.docbook.dsssl.mk"
.include "doc.docbook.xsl.mk"

.if ${FORMATS:Mps} || ${FORMATS:Mpdf}
REQPKGS+=	${REQPKGS_DSSSL}
.endif
.if ${FORMATS:Mhtml} || ${FORMATS:Mhtml-split} || ${FORMATS:Mascii} || ${FORMATS:Mepub}
REQPKGS+=	${REQPKGS_XSL}
.endif
.if ${FORMATS:Mascii}
REQPKGS+=	${REQPKGS_ASCII}
.endif
.if ${FORMATS:Mhtml} || ${FORMATS:Mhtml-split}
REQPKGS+=	${REQPKGS_HTML}
.endif
.if ${FORMATS:Mps} || ${FORMATS:Mpdf}
REQPKGS+=	${REQPKGS_PRINT}
.endif

DESTDIR?=	/tmp/htdocs

#INSTALL_FILES+=	${DOCBOOKCSS}

install: ${FORMATS:@f@install-${f}@}

install-ascii: ${DOC}.txt
	mkdir -p ${DESTDIR}
	cp $? ${DESTDIR}

install-html: ${DOC}.html ${INSTALL_FILES}
	mkdir -p ${DESTDIR}
	cp $? ${DESTDIR}

install-html-split: ${HTML_INDEX} ${MANIFEST} ${INSTALL_FILES}
	mkdir -p ${DESTDIR}
	cp ${HTML_INDEX} `cat ${MANIFEST}` ${DESTDIR}

install-ps: ${DOC}.ps
	mkdir -p ${DESTDIR}
	cp $? ${DESTDIR}

install-pdf: ${DOC}.pdf
	mkdir -p ${DESTDIR}
	cp $? ${DESTDIR}

show-var: .PHONY
	@echo ${${VARNAME}:Q}
